@extends($activeTemplate.'layouts.home')

@push('style')
@endpush


@section('header')
@include($activeTemplate. 'layouts.home_navprev')
@endsection

@section('content')

@php
$link = route('invite', ['code' => auth()->user()->ref_code]);
@endphp

<div class="message-box">

    <div class="invitation-link">
        <div>
            <a href="javascript:void(0);">Daily Profit</a>
            <a href="javascript:void(0);">{{ Session::get('currency_sym') }}{{ showAmount(auth()->user()->pending_income) }}</a>
            <button id="whatsapp-share" data-url="{{ $link }}" data-id="20">Claim</button>
        </div>
        <p>
            NOTE: Daily Profit is available at exactly 24hours after you've purhased a product. For instance, if you activated a product at 20:30 PM, your earnings will be available the next day at 20:30 PM
        </p>
    </div>

    @foreach($logs as $log)

        @php
            $plan = $log->plan;
            $nextTime = \Carbon\Carbon::parse($log->next_return_date);
            $formattedDateTime = \Carbon\Carbon::parse($log->created_at)->format('d.m.y H:i');
            $formattedNextDateTime = \Carbon\Carbon::parse($log->next_return_date)->format('d M H:i A');
        @endphp


        <!-- About sample -->
        <a href="javascript:void(0);" class="message">
            <div>
                <img src="{{ asset('assets') }}/{{ $plan->img }}" alt="avatar">
                <div>
                    <div>
                        <p><strong>{{ $plan->name }}</strong></p>
                        {{-- <iconify-icon width="15" height="15" icon="ep:d-arrow-right"></iconify-icon> --}}
                    </div>
                    <div>
                        <p>Purchase Date <span> {{ $formattedDateTime }} </p>
                        {{-- <p class="label unread">unread</p> --}}
                    </div>
                    <div>
                        <p>Valid For <span> {{ $log->total_return }} Days </span> </p>
                    </div>
                    {{--<div>
                        Earning <span class="text-success"> {{ $plan->cur_sym }}{{ getAmount($log->interest_amount * $log->total_paid) }} of {{ $log->total_paid }} Days</span> </p>
                    </div>--}}
                    <div>
                        <p>Earning: <span> <b>{{ $plan->cur_sym }}{{ getAmount($log->interest_amount * $log->total_paid) }}</b> of {{ $log->total_paid }} Days</span> : Next Earn<span> {{ $formattedNextDateTime }} </span> </p>
                    </div>
                </div>
            </div>
        </a>
        <!-- end about sample -->

    @endforeach

</div>
@endsection

@push('script')
<script>
    $('#whatsapp-share').on('click', function() {
        var url = $(this).data('url');

        // Open WhatsApp share dialog
        //window.open('https://api.whatsapp.com/send?text=Claim bonuses and withdraw to your bank account with Equinixstocks. Use my invite link ' + encodeURIComponent(url), '_blank');

        // Send AJAX request
        $.ajax({
            url: "{{ route('user.collect.income') }}",
            method: 'POST',
            data: {
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                modalMessage(response.message, 200, data.link);
            },
            error: function(xhr, status, error) {
                var data = JSON.parse(xhr.responseText);
                var responseMessage = data.message
                modalMessage(responseMessage);
            }
        });
    });
</script>
@endpush