@extends($activeTemplate.'layouts.home')

@push('style')
@endpush

@section('wrapper')<div class="wrapper">@endsection

@section('header')
@include($activeTemplate. 'layouts.home_navprev')
@endsection

@section('content')
<div class="inner-wrapper-with-header">

    <div class="support">

        <div>
            <iconify-icon width="56" height="56" icon="logos:whatsapp-icon"></iconify-icon>
            <div>
                <p>WhatsApp: </p>
                <p id="whatsapp-number">{{ config('settings')->whatsapp_number }}</p>
            </div>
            <button data-role="copier" data-target="whatsapp-number">Copy</button>
        </div>
    </div>

</div>
@endsection

@push('script')
<script>
    //copier
    //the copied text should be in <p> tag
    var copiers = document.querySelectorAll("[data-role='copier']");
    Array.from(copiers).forEach(copier =>
        copier.addEventListener('click', ()=>{
            var target = copier.getAttribute('data-target')
            navigator.clipboard.writeText(document.getElementById(target).innerHTML)

            copier.innerHTML = "Copied!";
            setTimeout(function(){
                copier.innerHTML = "Copy"
            }, 1000)
        })
    )
</script>
@endpush