@extends($activeTemplate.'layouts.home')

@push('style')
@endpush

@section('wrapper')<div class="wrapper">@endsection

@section('header')
@include($activeTemplate. 'layouts.home_navprev')
@endsection

@section('content')
<script>
    "use strict"

    function createCountDown(elementId, sec) {
        var tms = sec;
        var x = setInterval(function() {
            var distance = tms * 1000;
            var days = Math.floor(distance / (1000 * 60 * 60 * 24));
            var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            var seconds = Math.floor((distance % (1000 * 60)) / 1000);
            document.getElementById(elementId).innerHTML = hours + "h " + minutes + "m " + seconds + "s ";
            if (distance < 0) {
                clearInterval(x);
                document.getElementById(elementId).innerHTML = "-";
            }
            tms--;
        }, 1000);
    }
</script>

<div class="inner-wrapper-with-header">
    @foreach($plans as $plan)
    @php

        $buyLimit = (config('settings')->buy_limit && $plan['escape_buy_limit'] != 1) ? config('settings')->buy_limit : $plan['buy_limit'];
        $limiBuy = (config('settings')->buy_limit && $plan['escape_buy_limit'] != 1) ? config('settings')->limit_buy : $plan['limit_buy'];
        $buyLimitType = (config('settings')->buy_limit && $plan['escape_buy_limit'] != 1) ? config('settings')->buy_limit_type : $plan['buy_limit_type'];

        if($buyLimitType) {
			$investment = \App\Models\Investment::where(['user_id' => auth()->user()->id, 'plan_id' => $plan['id']])->where('created_at', '>=', \Carbon\Carbon::now()->subHours(24))->count();
        }else {
			$investment = (config('settings')->buy_limit && $plan['escape_buy_limit'] != 1) ? \App\Models\Investment::where(['plan_id' => $plan['id']])->count() : \App\Models\Investment::where(['user_id' => auth()->user()->id, 'plan_id' => $plan['id']])->count();
        }

        $boughtCount = $investment;

        $statusLink = 0;
        $statusText = '';
        $statusUpcoming = 0;
        
        if($plan['p_status'] == 'to_buy' && $boughtCount >= $limiBuy && $buyLimit) {
            $statusClass = 'text-danger';
            $statusText = 'Out of Stock';
        }elseif($plan['p_status'] == 'trial' && $boughtCount >= $limiBuy || $plan['p_status'] == 'solid_out') {
            $statusClass = 'text-danger';
            $statusText = 'Out of Stock';
        }elseif($plan['p_status'] == 'coming') {
            $statusClass = 'badge badge-warning';
            $statusText = 'Upcoming';
        $statusUpcoming = 1;
        }else {
            $statusClass = 'badge badge-primary';
            $statusText = 'Available';
            $statusLink = 1;
        }

        $nextTime = \Carbon\Carbon::parse($plan['lock_endat']);
        @endphp

        @if($plan['p_status'] == 'coming')
        <script>
            createCountDown('counter<?php echo $plan['id']; ?>', {{ $nextTime->diffInSeconds() }});
        </script>
    @endif

    <a href="@if($statusLink) {{ route('user.product.view', ['id' => $plan['identifier']]) }} @else javascript:void(0); @endif" class="package mb-2">
        <!-- heading -->
        <div class="heading">
            <div>
                <div></div>
                {{--<img src="{{ asset('users/assets/basic/img/logowhite.png') }}" alt="" srcset="" />--}}
                <p>EQUINIX</p>
                <div></div>
            </div>
        </div>

        <div>
            <!-- feature img -->
            <div>
                <p>{{ $plan['name'] }}</p>
                <img src="{{ asset('assets/'.$plan['img']) }}" alt="{{ $plan['name'] }}">
                <table>
                    <tr><td>Daily Profit</td> <td>{{ $plan->cur_sym }}{{ showAmount($plan->interest_amount) }}</td></tr>
                    <tr><td>Total Profit</td> <td>{{ $plan->cur_sym }}{{ showAmount($plan->interest_amount * $plan->total_return) }}</td></tr>
                    <tr><td>Duration</td> <td>{{ $plan->total_return }} Days</td></tr>
                </table>
            </div>
            <!-- end featured img -->

            <!-- action buttons -->
            <div>
                <div>
                    @if($statusLink)<button id="btn-pay">Details</button disabled> @else <button id="counter<?php echo $plan['id']; ?>">Sold Out</button> @endif
                </div>
                <div>
                    <div role="button">
                        <p>Present Price</p>
                        <p>{{ $plan['cur_sym'] }}{{ showAmount($plan['min_amount']) }}</p>
                    </div>
                </div>
            </div>
            <!-- end actions buttons -->
        </div>

        <div class="item-number">
            <p>N0.{{ $loop->iteration }}</p>
        </div>

    </a>
    @endforeach

</div>
@endsection

@push('script')

@endpush