@extends($activeTemplate.'layouts.profile')

@push('style')
@endpush

@section('content')

<div class="my-container my">

    <!-- heading -->
    <div class="heading">
        <div>
            {{--<a class="text-primary/50" href="{{ route('user.online.support') }}">
                <iconify-icon icon="material-symbols-light:support-agent-outline-rounded"" width="30" height="30"></iconify-icon>
            </a>--}}
        </div>

        <div>
            <img src="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}">
            <p>{{ auth()->user()->username }}</p>
        </div>
    </div>

    <!-- heading middle -->
    <div class="middle-heading">
        <div>
            <div>
                <p>{{ Session::get('currency_sym') }}{{ getAmount($todayIncome) }}</p>
                <p>Today Income</p>
            </div>

            <div>
                <p>{{ Session::get('currency_sym') }}{{ getAmount($referralIncome) }}</p>
                <p>Total Income</p>
            </div>

            <div>
                <p>{{ Session::get('currency_sym') }}{{ getAmount($totalInvest) }}</p>
                <p>Total Assets</p>
            </div>
            
            <div>
            <p>{{ Session::get('currency_sym') }}{{ getAmount($userBalance['main']) }}</p>
            <p>Recharge</p>
            </div>

            <div>
                <p>{{ Session::get('currency_sym') }}{{ getAmount($userBalance['income']) }}</p>
                <p>Income</p>
            </div>

            <div>
                <p>{{ Session::get('currency_sym') }}0</p>
                <p>Points</p>
            </div>

        </div>

        <div>
            <a class="btn btn-1" href="{{ route('user.deposit') }}">
                <iconify-icon width="20" height="20" icon="uil:atm-card"></iconify-icon>
                <span>Topup</span>
            </a>

            <a class="btn btn-2" href="{{ route('user.withdraw') }}">
                <iconify-icon width="20" height="20" icon="uil:atm-card"></iconify-icon>
                <span>Withdraw</span>
            </a>
        </div>
    </div>


    <!-- common function -->
    <div class="functions text-red">
        <p>Common function</p>
        <div>
            <a href="{{ route('user.agents') }}">
                <iconify-icon width="30" height="30" icon="ph:users-three"></iconify-icon>
                <p>My Team</p>
            </a>

            <a href="{{ route('user.investment.log') }}">
                <iconify-icon width="30" height="30" icon="ph:stack-duotone"></iconify-icon>
                <p>My Income</p>
            </a>

            <a href="{{ route('user.transaction.type', ['type' => 'income']) }}">
                <iconify-icon width="30" height="30" icon="game-icons:pay-money"></iconify-icon>
                <p>Earn</p>
            </a>

            <a href="{{ route('user.withdrawal.password') }}">
                <iconify-icon width="30" height="30" icon="solar:money-bag-line-duotone"></iconify-icon>
                <p>PIN Change</p>
            </a>

            <a href="{{ route('user.gift') }}">
                <iconify-icon width="30" height="30" icon="ph:gift-light"></iconify-icon>
                <p>Gift</p>
            </a>

            <a href="{{ route('user.account-setup') }}">
                <iconify-icon width="30" height="30" icon="eos-icons:database-outlined"></iconify-icon>
                <p>Bind Bank</p>
            </a>

            <a href="{{ route('user.transaction') }}">
                <iconify-icon width="30" height="30" icon="charm:notes-tick"></iconify-icon>
                <p>Record</p>
            </a>

            <a href="{{ route('user.change.password') }}">
                <iconify-icon width="30" height="30" icon="solar:shield-bold-duotone"></iconify-icon>
                <p>Security</p>
            </a>

        </div>
    </div>
    <!-- end common function -->

    <!-- other function -->
    <div class="functions">
        <p>Other</p>
        <div>
            <a href="{{ route('user.logout') }}">
                <iconify-icon width="30" height="30" icon="ri:logout-circle-r-line"></iconify-icon>
                <p>Logout</p>
            </a>
        </div>
    </div>
    <!-- end other function -->

</div>
<!-- earning bottom drawer -->

</div>
@endsection

@push('script')
@endpush