@extends($activeTemplate.'layouts.home')

@push('style')
@endpush

@section('container')<div class="team-container">@endsection
@section('wrapper')<div class="">@endsection

@section('header')
@include($activeTemplate. 'layouts.home_navprev')
@endsection

@section('content')

@php
$link = route('invite', ['code' => auth()->user()->ref_code]);
$code = auth()->user()->ref_code;
@endphp

<!-- balance -->
<div class="team-summary">
    <div>
        <p>
            <span><iconify-icon icon="heroicons-solid:cube"></iconify-icon></span>
            Team Invested
        </p>
        <p>{{ Session::get('currency_sym') }}{{ showAmount($totalInvest) }}</p>
    </div>

    <div>
        <p>
            <span><iconify-icon icon="streamline:graph-arrow-increase"></iconify-icon></span>
            Team Number
        </p>
        <p>{{ $totalTeamMember }}</p>
    </div>
</div>

    <div class="invitation-link">
    <p>Invitation Link</p>
    <div>
        <a href="{{ $link }}">{{ $link }}</a>
        <button onclick="copyText('{{ $link }}');">copy</button>
    </div>
    </div>

    <!-- tabs -->
    <div class="team-tabs">
    <button @if($lev_id == 1) class="active" @endif onclick="location.href='{{ route('user.agents', ['id' => 1]) }}';">Level 1</button>
    <button @if($lev_id == 2) class="active" @endif onclick="location.href='{{ route('user.agents', ['id' => 2]) }}';">Level 2</button>
    <button @if($lev_id == 3) class="active" @endif onclick="location.href='{{ route('user.agents', ['id' => 3]) }}';">Level 3</button>
    </div>

    <!-- summary -->
    <div class="other-summary">
        <div>
            <p>{{ $ActiveMemberstotal }}</p>
            <p>Total valid</p>
        </div>

        <div>
            <p>{{ Session::get('currency_sym') }}{{ showAmount($totalCommission) }}</p>
            <p>Total income</p>
        </div>

        <div>
        @foreach($levels as $level)
        @if($level->level == $lev_id) <p>{{ $level->percent }}%</p>@endif
        @endforeach
            <p>Total profit</p>
        </div>
    </div>

    <table class="team-members">
        <thead>
            <tr><th>Phone number</th> <th>Invitation</th> <th>Assets</th></tr>
        </thead>
        <tbody>
            @php
                $lastUsers = collect($levelUsers)->reverse()->take(10)->reverse();
            @endphp

            @foreach($lastUsers as $user)
                @php
                    $team_size = DB::table('users')->where('ref_by', $user->id)->count();
                    $total_assets = DB::table('investments')->where('user_id', $user->id)->sum('amount');
                @endphp    
                <tr><td>{{ substr_replace($user->mobile, str_repeat("*", 3), 3, 3) }}</td> <td>{{ $team_size }}</td> <td>{{ Session::get('currency_sym') }}{{ showAmount($total_assets) }}</td></tr>
            @endforeach
        </tbody>
    </table>
@endsection

@push('script')
<script>
    function copyText(textToCopy) {
        navigator.clipboard.writeText(textToCopy)
            .then(function () {
                modalMessage("Copied!");
            })
            .catch(function (error) {
                console.error('Unable to copy: ', error);
            });
    }
</script>
@endpush