@extends($activeTemplate.'layouts.home')

@push('style')
@endpush

@section('wrapper')<div class="wrapper">@endsection

@section('header')
@include($activeTemplate. 'layouts.home_navprev')
@endsection

@section('content')
<div class="inner-wrapper-with-header">

    <div class="team-container transaction-detail">

        <!-- header leading buttons -->
        <div class="details">
        <div class="switch-buttons">
            <div class="mb-2 @if($type=='all') active @endif" onclick="location.href='{{ route('user.transaction.type', ['type' => 'all']) }}';">
                <p>All</p>
            </div>

            <div class="mb-2 @if($type=='deposit') active @endif" onclick="location.href='{{ route('user.transaction.type', ['type' => 'deposit']) }}';">
                <p>Recharge</p>
            </div>

            <div class="@if($type=='withdraw') active @endif" onclick="location.href='{{ route('user.transaction.type', ['type' => 'withdraw']) }}';">
                <p>Withdraw</p>
            </div>
            

            <div class="@if($type=='income') active @endif" onclick="location.href='{{ route('user.transaction.type', ['type' => 'income']) }}';">
                <p>Earn Income</p>
            </div>
        </div>
        </div>

        <!-- details -->
        <div class="flex flex-col gap-y-3">

            @foreach($transactions as $data)

            @php
                $status = '';
                if($data->status == 1) {
                    $status = '<p class="success">Successful</p>';
                }elseif($data->status == 2) {
                    $status = '<p class="pending">Pending</p>';
                }elseif($data->status == 3) {
                    $status = '<p class="pending">Cancelled</p>';
                }
            @endphp

            <div class="recharge-detail">

                <!-- heading -->
                <div class="heading">
                    <iconify-icon icon="noto:spiral-notepad"></iconify-icon>
                    <p>{{ $data->trx }}</p>
                </div>

                <!-- description -->
                <div class="description">
                    <div>
                        <p>Amount</p>
                        <p>{{ showAmount($data->amount) }}</p>
                    </div>

                    <div>
                        <p>Order date</p>
                        <p>{{ $data->created_at->format('m.d.Y h:i')}}</p>
                    </div>
                </div>

                <div class="footer">
                    {!! $status !!}
                    <p class="text-primary">&darr; {{ ucwords($data->type) }}</p>
                </div>
            </div>
            @endforeach

    </div>

</div>
@endsection

@push('script')
@endpush