@extends($activeTemplate.'layouts.home')

@push('style')
@endpush

@section('wrapper')<div class="wrapper">@endsection

@section('header')
@include($activeTemplate. 'layouts.home_navprev')
@endsection

@php
    
    $buyLimit = (config('settings')->buy_limit && $plan->escape_buy_limit != 1) ? config('settings')->buy_limit :$plan->buy_limit;
    $limiBuy = (config('settings')->buy_limit && $plan->escape_buy_limit != 1) ? config('settings')->limit_buy : $plan->limit_buy;
    
    $statusLink = 0;
    if($plan['p_status'] == 'coming') {
		$statusClass = 'bg-secondary';
		$statusName = 'UPCOMING';
    }elseif($boughtCount >= $limiBuy && $buyLimit || $plan['p_status'] == 'solid_out' || $plan['purchased'] >= $plan['all_limit_buy']) {
		$statusClass = 'bg-danger';
		$statusName = ($plan['p_status'] == 'trial') ? 'Activate' : 'SOLD OUT';
    }else {
		$statusClass = 'bg-primary-blue';
		$statusName = ($plan['p_status'] == 'trial') ? 'Activate' : 'BUY NOW';
		$statusLink = 1;
    }
@endphp

@section('content')
<div class="inner-wrapper-with-header">
    <!-- package sample -->
    <div class="package">
        <!-- heading -->
        <div class="heading">
            <div>
                <div></div>
                {{--<img src="{{ asset('users/assets/basic/img/logowhite.png') }}" alt="" srcset="" />--}}
                <p>EQUINIX</p>
                <div></div>
            </div>
        </div>

        <div>
            <!-- feature img -->
            <div>
                <p>{{ $plan->name }}</p>
                <img src="{{ asset('assets/'.$plan->img) }}" alt="{{ $plan->name }}">
            </div>
            <!-- end featured img -->

            <!-- action buttons -->
            <div>
                <div>
                    {{--<p>{{ $plan->name }}</p>--}}
                    @if($statusLink)<p id="btn-pay">Buy Now</p> @else <p>{{$statusName}}</p> @endif
                </div>
                <div>
                    <div role="button">
                        <p>Present Price</p>
                        <p>{{ $plan->cur_sym }}{{ showAmount($plan->min_amount) }}</p>
                    </div>
                </div>
            </div>
            <!-- end actions buttons -->
        </div>

        <div class="item-number">
            <p></p>
        </div>

    </div>
    <!-- end package sample -->

    <!-- package sample -->
    <div class="package-detail">

        <p>Item description</p>

        <div>
            <p>Duration:</p>
            <p>{{ $plan->total_return }} Days</p>
        </div>

        <div>
            <p>Daily profit</p>
            <p>{{ $plan->cur_sym }}{{ showAmount($plan->interest_amount) }}</p>
        </div>

        <div>
            <p>Total profit</p>
            <p>{{ $plan->cur_sym }}{{ showAmount($plan->interest_amount * $plan->total_return) }}</p>
        </div>

        @if($buyLimit)
        <div>
            <p>Recruit limit</p>
            <p>{{ $boughtCount }} of {{ $limiBuy }}</p>
        </div>
        @endif

    </div>

    <input type="hidden" id="coupon" value="">
    <input type="hidden" id="pay_with" value="{{ $plan->cur_text }}">
</div>
@endsection

@push('script')
<script>
    $('#btn-pay').on('click', function() {
        
        // Data
        var coupon = $('#coupon').val();
        var pay_with = $('#pay_with').val();

        $.ajax({
            url: "{{ route('user.investment.post') }}",
            type: 'POST',
            data: {
                'id': "{{ $plan->id }}",
                'coupon': coupon,
                'pay_with': pay_with
            },
             beforeSend: function() {
                // Handle before sending the request
                mui.showLoading("Please wait...", "div");
            },
            success: function(data) {
                
                // Redirect
                if(data.link) {
                    modalMessage(data.message, 200, data.link);
                    return true;
                }
                mui.hideLoading();
                modalMessage(data.message);
            },
            error: function(xhr, status, error) {
                var data = JSON.parse(xhr.responseText);
                var responseMessage = data.message

                // Validator message
                if (data.errors) {
                    var errorMessages = [];
                    for (var key in data.errors) {
                        if (data.errors.hasOwnProperty(key)) {
                            errorMessages.push(data.errors[key][0]);
                        }
                    }

                    responseMessage = errorMessages.join(", ")
                }

                // Redirect
                if(data.link) {
                    modalMessage(data.message, 400, data.link);
                    return true;
                }

                mui.hideLoading();
                modalMessage(responseMessage);
            }
        });
    })

    $('#coupon').on('keyup input', function() {
        
        // Data
        var coupon = $(this).val();

        if(coupon == "") {
            $(".error-coupon, .success-coupon").addClass("d-none");
            getRate();
            return true;
        }

        $.ajax({
            url: "{{ route('user.coupon.use') }}",
            type: 'POST',
            data: {
                'code': coupon,
                'amount': "{{ showAmount($plan->min_amount) }}",
                'package': '{{ $plan->id }}'
            },
             beforeSend: function() {
                // Handle before sending the request
                //mui.showLoading("Please wait...", "div");
                
                $(".error-coupon, .success-coupon").html('');
                $(".error-coupon, .success-coupon").addClass("d-none");
            },
            success: function(data) {
                
                //mui.hideLoading();
                
                //$("#final").text("{{ Session::get('currency_sym') }}" + data.data.charge);
                //$("#coupon_amount").val(data.data.charge);
                $(".success-coupon").html("Discount of {{ $plan->cur_text }} "+ data.data.discount +" Will be added to your income balance as a bonus you received");
                $(".success-coupon").removeClass("d-none");

                getRate();
            },
            error: function(xhr, status, error) {
                var data = JSON.parse(xhr.responseText);
                var responseMessage = data.message

                // Validator message
                if (data.errors) {
                    var errorMessages = [];
                    for (var key in data.errors) {
                        if (data.errors.hasOwnProperty(key)) {
                            errorMessages.push(data.errors[key][0]);
                        }
                    }

                    responseMessage = errorMessages.join(", ")
                }

                //mui.hideLoading();
                $(".error-coupon").html(responseMessage);
                $(".error-coupon").removeClass("d-none");
                $("#final").text("{{ Session::get('currency_sym') }}{{ showAmount($plan->min_amount) }}");
            }
        });
    })

    $('#pay_with').on('change', function() {
        getRate();
    })

    function getRate() {

        var exchange_summary = $('.exchange-summary');
        var currency = "{{ $plan->cur_text }}";
        var pay_wallet = $('#pay_with').val();

        if(currency == pay_wallet || pay_wallet == "") {
            exchange_summary.html('');
            exchange_summary.addClass('d-none');
            return true;
        }

        $.ajax({
            url: "{{ route('user.transaction.rate') }}",
            type: 'POST',
            data: {
                'amount': $('#coupon_amount').val(),
                'from_currency': currency,
                'to_currency': pay_wallet
            },
            success: function(response) {
                exchange_rate = (response.data.rate_text) ? response.data.rate_text : '';
                exchange_fee = response.data.currency.sym + response.data.fees;
                exchange_summary.html("Exchange Rate " + exchange_rate + " </br>Throng " + pay_wallet +" recharge wallet, you will be charged " + response.data.currency.sym + response.data.amount_with_fees);
                exchange_summary.removeClass('d-none');
            },

            error: function(err) {
                exchange_summary.html('');
                exchange_summary.addClass('d-none');
            }
        });
    }
</script>
@endpush