@extends($activeTemplate.'layouts.home')

@push('style')
<style>
    body {
        height: 115vh;
    }
</style>
@endpush

@section('wrapper')<div class="wrapper zero-padding">@endsection

@section('header')
<!-- top nav -->
<div class="top-nav transparent">
    <a href="{{ route('user.home') }}">
        <iconify-icon icon="pepicons-pop:angle-left" width="30" height="30"></iconify-icon>
    </a>

    <div>
        <p>Withdraw</p>
    </div>

    <a href="{{ route('user.home') }}">
        <iconify-icon icon="pepicons-pop:angle-left" width="30" height="30"></iconify-icon>
    </a>
</div>
<!-- end top nav -->
@endsection

@section('content')
<div class="inner-wrapper-with-header">

    <div class="container-wrapper">

        <!-- withdraw details section -->
        <div class="withdraw-details-container">
            <div class="withdraw-details">

                <!-- detail 01 -->
                <div>
                    <div>Income Balance</div>
                    <div>{{ $currency['cur_sym'] }}{{ showAmount($userBalance['income']) }}</div>
                </div>
            </div>
        </div>

        @php
        $accountNumber = (auth()->user()->bankAccount) ? auth()->user()->bankAccount->account_number : '';
        $accountName = (auth()->user()->bankAccount) ? explode(' ', auth()->user()->bankAccount->account_name)[0] : '';
        $bankName = (auth()->user()->bankAccount) ? auth()->user()->bankAccount->bank_name : '';
        @endphp

        <!-- withdrawal form -->
        <div class="withdrawa-form">

            <!-- amount input -->
            <div>
                <p class="label">Amount</p>
                <div class="input-wrapper">
                    <p class="text-semibold">{{ $currency['cur_sym'] }}</p>
                    <input type="text" id="amount" placeholder="Withdraw amount" />
                </div>
            </div>

            <!-- withdraw to account -->
            <div>
                <p class="label">Withdraw to account</p>
                <div class="input-wrapper">
                    <iconify-icon width="20" icon="mingcute:bank-card-line"></iconify-icon>
                    <p>{{ $bankName }}</p>
                    <div class="inner-input">
                        <input type="text" placeholder="{{ $accountName }}" readonly/>
                        {{--<iconify-icon width="20" icon="ph:play-fill"></iconify-icon>--}}
                    </div>
                </div>
            </div>

            <!-- password for withdraw -->
            <div>
                <div class="input-wrapper mb-2">
                    <input type="password" name="password" id="password" placeholder="Enter the transaction password" />
                </div>
                    {{--<p">Transaction Fee: <a href="javascript:void(0);" style="color: #888;"> {{ $withdrawMethod[0]->percent_charge}}%</a></p>--}}
            </div>

            @csrf

            <input type="hidden" id="method" value="{{ $withdrawMethod[0]->id}}">
            <input type="hidden" id="debit_with" value="2">

            <!-- pay method -->
            <div class="label-container ">
                <button type="button" class="recharge-btn">Withdraw <span id="current-value"></span> <iconify-icon icon="pepicons-pop:angle-right" width="15" height="15"></iconify-icon></button>
            </div>

            <div class="charge-description">
                <p>Withdrawal instructions</p>
                {!! $withdrawMethod[0]->description !!}
            </div>
        </div>
        
    </div>

</div>
@endsection

@push('script')
<script src="{{ asset('users/assets/basic/js/recharge-amount.js') }}"></script>

<script>
    $(".recharge-btn").click(function() {

        // Form input Value
        var amount = $('#amount');
        var method = $('#method');
        var debit_from = $('#debit_with');
        var password = $('#password');
        var token = document.querySelector('input[name="_token"]').value;

        // Enable form submit
        var is_status = true;

        // Verify input
        if (!amount.val()) {
            modalMessage("Please enter amount");
            is_status = false;
        }

        // Verify input
        if (!debit_from.val()) {
            modalMessage("Please select debit wallet");
            is_status = false;
        }

        // Verify input
        if (!password.val()) {
            modalMessage("Please enter transaction password");
            is_status = false;
        }
        // End Verify

        // Send Data
        if (is_status) {

            // AJAX POST
            $.ajax({
                type: "POST",
                url: "{{ route('user.withdraw.money') }}",
                data: {
                    amount: amount.val(),
                    method: method.val(),
                    debit_from: debit_from.val(),
                    password: password.val(),
                    _token: token
                },
                beforeSend: function() {
                    // Handle before sending the request
                    mui.showLoading("Please wait...", "div");
                },
                success: function(data) {
                    // Handle successful request
                    mui.hideLoading();
                    //window.location.href = data.link;
                    modalMessage(data.message, 200, data.link);
                },
                error: function(xhr, status, error) {
                    var responseText = JSON.parse(xhr.responseText);

                    // Handle errors
                    mui.hideLoading();
                    modalMessage(responseText.message);
                },
                fail: function() {
                    // Handle failed requests
                    mui.hideLoading();
                    modalMessage("Request Failed");
                }
            });
        }


        return false;
    })
</script>
@endpush