<!DOCTYPE html>
<html lang="en">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
		<meta name="renderer" content="webkit">
		<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
		<meta name="viewport" content="width=device-width,user-scalable=0,initial-scale=1,maximum-scale=1, minimum-scale=1">
		<meta name="apple-mobile-web-app-capable" content="yes">
		<link rel="shortcut icon" href="{{ getImage(imagePath()['logoIcon']['path'] .'/favicon.png') }}{{ $catch}}" type="image/x-icon">

		<meta name="csrf-token" content="{{ csrf_token() }}">

		<title>@if(View::hasSection('pageTitle')) @yield('pageTitle') @else {{ config('settings')->sitename(__($pageTitle)) }} @endif</title>

		<link rel="stylesheet" href="/assets/css/layui.css{{$catch}}" />
		<link rel="stylesheet" href="/assets/css/main.css{{$catch}}" />
		<link rel="stylesheet" href="/assets/css/march.css{{$catch}}">
		<link rel="stylesheet" href="{{ asset('users/jasper/css/loading.css') }}{{$catch}}">
		<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
		<script src="/assets/js/layui.js{{$catch}}"></script>

		@stack('style-lib')

		@stack('style')
	</head>
	
	<body style="min-height: 100%; width: 100%; background-size: 100% auto; background: #f1f1f1; ">
		<input type="hidden" id="techannel" value="{{ config('settings')->whatsapp_url }}">
		<input type="hidden" id="androidurl" value="{{ config('settings')->telegram_url }}">
		<div class="indexdiv"></div>

		<div style=" max-width:450px; margin:0 auto; position:relative;">

			@yield('content')
	
			@include($activeTemplate. 'layouts.menu')
			
		</div>

		@stack('script')

		@include($activeTemplate. 'partials.notify')

		<a href="" target="_blank" style="display:none;"><span id="jump"></span></a>
	</body>
</html>