@php $loginContent = getContent(config('settings')->active_template, 'login.content', true); @endphp
<!DOCTYPE html>
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
		<?php $pageTitle = @$loginContent->data_values->title; ?>
		<title>{{ $pageTitle }}</title>
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
		
		<link rel="shortcut icon" href="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}" type="image/x-icon">
		<meta name="keywords" content="{!! @$loginContent->data_values->keyword !!}">

		{{--<!-- Apple Stuff -->--}}
		<link rel="apple-touch-icon" href="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}">
		<meta name="apple-mobile-web-app-capable" content="yes">
		<meta name="apple-mobile-web-app-status-bar-style" content="black">
		<meta name="apple-mobile-web-app-title" content="{{ $pageTitle }}">

		{{--<!-- Facebook Meta Tags -->--}}
		<meta property="og:type" content="website">
		<meta property="og:image:type" content="jpg" />
		<meta property="og:image:width" content="1080" />
		<meta property="og:image:height" content="840" />
		<meta property="og:url" content="{{ url()->current() }}">
		
		{{--<!-- Twitter Meta Tags -->--}}
		<meta name="twitter:card" content="summary_large_image">

		<meta name="description" content="{!! @$loginContent->data_values->description !!}">
		<meta itemprop="name" content="{{$pageTitle}}">
		<meta itemprop="description" content="{!! @$loginContent->data_values->description !!}">
		<meta itemprop="image" content="{{ getImage( 'assets/images/frontend/login/' .@$loginContent->data_values->seo_image, '1080x840') }}">

		<meta property="og:title" content="{{$pageTitle}}">
		<meta property="og:description" content="{!! @$loginContent->data_values->description !!}">
		<meta property="og:image" content="{{ getImage( 'assets/images/frontend/login/' .@$loginContent->data_values->seo_image, '1080x840') }}"/>

		<link rel="stylesheet" href="/assets/css/layui.css{{$catch}}">
		<link href="/assets/css/auth.css{{$catch}}" rel="stylesheet">
		<link rel="stylesheet" href="{{ asset('users/jasper/css/loading.css') }}{{$catch}}">
		<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
		<script src="/assets/js/layui.js{{$catch}}"></script>
	</head>

	<body style="background: url({{ getImage( 'assets/images/frontend/login/' .@$loginContent->data_values->backgroud, '1080x840') }}) no-repeat; background-size: 100% 115%; ">
		<input type="hidden" id="moblie_qu_hid" value="234">
		<input type="hidden" id="telegram" value="{{ config('settings')->whatsapp_url }}">
		<input type="hidden" id="whatsapp" value="{{ config('settings')->telegram_url }}">
		@csrf

		<div style=" max-width:450px; margin:0 auto;">
			<div style="padding-top:120px;">
				<div style="width: 95%; margin: 0 auto; background: #00000098; border-radius: 10px; ">
					<div style="text-align: center; ">
						<img src="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}" style="height:60px; padding-top:25px;padding-bottom:25px;">
					</div>
					<div class="layui-form" style="margin:0 auto; width:87%;">
						<div class="layui-form-item" style="height:48px;">
							<div class="inputdiv">
								<img src="/assets/images/i4.png" style="margin-right:5px;color:#000; height:21px; margin-top:11px;">
								<input type="text" style="height:45px; border-radius:25px;" id="moblie" class="layui-input" placeholder="Username" autocomplete="off">
							</div>
						</div>
						<div class="layui-form-item" style="height:48px; margin-top:10px;">
							<div class="inputdiv passwordIn">
								<img src="/assets/images/i2.png" style="margin-right:5px;color:#000; height:21px; margin-top:11px;">
								<input type="password" id="password" style="height:45px;border-radius:25px;" maxlength="20" placeholder="Enter your password" autocomplete="off" class="layui-input">
								<img class="viewPass" src="/assets/images/eye-fill.png" style="margin-right:5px;color:#000; height:21px; margin-top:11px;">
							</div>
						</div>
						<div class="layui-form-item" style="margin-top:20px; color:#000; text-align:center; font-size:14px;">
							<div style="float:left;width:48%;text-align:left; margin-left:2%; height:25px;line-height:25px; color:#fff;">
								<input type="checkbox" id="rememberpassword" lay-filter="rememberpassword" lay-skin="primary" title="Remember" style="margin-left:0px;"><div class="layui-unselect checkOptionbox layui-form-checkbox" lay-skin="primary"><label for="rememberpassword">Remember</label></div>
							</div>
							<a style="float: left; width: 48%; text-decoration: underline; color: #fff; text-align: right; margin-right: 2%; height: 25px; line-height: 25px;" class="linkBTN" data-href="{{ route('user.register') }}">Register an account &gt; </a>
						</div>
						<div class="layui-form-item" style="margin-top:20px; text-align:center;">
							<input class="layui-btn" id="login" value="Sign in" style="width: 45%; font-weight: 600; height: 40px; line-height: 40px; font-size: 16px; display: inline-block; background: #000; color: #fff; border: 1px groove #c0c0c0; border-radius: 25px;  " type="button">
						</div>
						<div style="color:#fff; text-align:center; margin-top:15px; height:75px;">
							<div style="color: #0C95B3; font-size: 14px; width: 100%; margin: 0 auto; margin-top: 30px; ">
								@if( config('settings')->whatsapp_url )
								<div style="float:left;width:50%;">
									<img src="/assets/images/t1.png" style="height:40px;" id="service">
								</div>
								@endif

								@if( config('settings')->telegram_url )
								<div style="float:left;width:50%;">
									<img src="/assets/images/t2.png" style="height: 40px;" id="service1">
								</div>
								@endif
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		@include($activeTemplate. 'partials.notify')
		
		<script type="text/javascript">
            $().ready(function () {
                check();
				function check() {
					var rememberpassword = localStorage.getItem("rememberpassword");
					if (rememberpassword == "1") {
						var moblie = localStorage.getItem("moblie");
						var password = localStorage.getItem("password");
						$("#moblie").val(moblie);
						$("#password").val(password);
						$("#rememberpassword").prop("checked", true);
					}
				}
				
				$(document).on("click", "#rememberpassword", function(data) {
					console.log('sss');
                    if ($('#rememberpassword').prop('checked')) {
                        localStorage.setItem("rememberpassword", 1);
                    } else {
                        localStorage.setItem("rememberpassword", 0);
                    }
                });

                $("#service").click(function () {
					console.log('ss');
                    var androidurl = $("#whatsapp").val();
                    if (window.android) {
                        window.android.callAndroid("open," + androidurl)
                        return;
                    }
                    if (window.webkit && window.webkit.messageHandlers) {
                        window.webkit.messageHandlers.nativeExt.postMessage({ msg: 'open,' + androidurl });
                        return;
                    }
                    $("#jump").parent().attr("href", androidurl), $("#jump").trigger("click");
                });

                $("#service1").click(function () {
					console.log('ss');
                    var androidurl = $("#telegram").val();
                    if (window.android) {
                        window.android.callAndroid("open," + androidurl)
                        return;
                    }
                    if (window.webkit && window.webkit.messageHandlers) {
                        window.webkit.messageHandlers.nativeExt.postMessage({ msg: 'open,' + androidurl });
                        return;
                    }
                    $("#jump").parent().attr("href", androidurl), $("#jump").trigger("click");
                });

                $("#login").click(function () {
                    var moblie = $("#moblie").val();
                    var moblie_qu = $("#moblie_qu_hid").val();
                    var password = $("#password").val();
					var token = document.querySelector('input[name="_token"]').value;
					
					// Enable form submit
					var is_status = true;

					// Verify input
					if (!moblie) {
						modalMessage('Your Username is Required 所需數量');
						is_status = false;
					}

					if (!password) {
						modalMessage('Password filed is also required 輸入密碼');
						is_status = false;
					}
					
					if (is_status) {
						$.ajax({
							url: "",
							type: 'POST',
							data: {
								password: password,
								username: moblie,
								moblie_qu: moblie_qu,
								time: Math.random(),
								_token: token
							},
							beforeSend: function() {
								loading.showLoading({type: 2,tip: "Hold on 抓住.."});
							},
							success: function(data) {
								if ($("#rememberpassword").prop("checked")) {
									localStorage.setItem("moblie", moblie);
									localStorage.setItem("password", password);
								}
								modalMessage('Login Successful 成功的', 200, data.intended);
							},
							error: function(xhr, status, error) {
								var data = JSON.parse(xhr.responseText);
								var responseMessage = data.message

								if (data.errors) {
									var errorMessages = [];
									for (var key in data.errors) {
										if (data.errors.hasOwnProperty(key)) {
											errorMessages.push(data.errors[key][0]);
										}
									}

									responseMessage = errorMessages.join(", ")
								}

								if(data.link) {
									modalMessage(data.message, 400, data.link);
									return true;
								}

								loading.hideLoading();
								modalMessage(responseMessage);
							}
						});
					}
                });

            });
    </script>
	
	<a href="" target="_blank" style="display:none;"><span id="jump"></span></a>
	
	</body>
</html>