@extends($activeTemplate.'layouts.dash')

@push('style')
@endpush

@php
$accountNumber = (auth()->user()->bankAccount) ? auth()->user()->bankAccount->account_number : '';
$accountName = (auth()->user()->bankAccount) ? auth()->user()->bankAccount->account_name : '';
$bankName = (auth()->user()->bankAccount) ? auth()->user()->bankAccount->bank_name : '';
$bankCode = (auth()->user()->bankAccount) ? auth()->user()->bankAccount->bank_code : '';
@endphp

@section('content')

<div style="background: none; height: auto; overflow: hidden; ">
	<div class="top" style="background: none;">
		<div data-href="{{ route('user.profile') }}" class="linkBTN" style="float:left; line-height:46px;width:50%; height:46px;cursor:pointer;" id="btnClose">
			<img src="/assets/images/arrow-back-up.png" style="margin-left:12px;width:32px;" />
		</div>
	</div>
	<div style="padding-top:30px;">
		<div style="float: left; width: 100%; text-align: center; color: #fff;">
			<div style="height: 100px; line-height: 100px; margin:0 auto; width:100px; border-radius: 100px; background:#fff;">
				<img src="{{ getImage(imagePath()['logoIcon']['path'] .'/favicon.png') }}{{ $catch}}" style="height: 90px; border-radius:100px;">
			</div>
			<div style="padding:5px; padding-top:10px;color:#000; font-weight:bold; font-size:20px; margin-top:10px;" id="uid">Bank Account</div>
			<div style="padding:5px; padding-top:5px;color:#000; font-size:12px;">Set up your account details for withdrawal</div>
		</div>
	</div>
</div>

<div class="layui-form layui-tab-content" style="padding:5px 10px; margin-top:50px;">
	<div class="layui-form layui-tab-content" style="padding: 10px 0;">
		<div class="layui-form">
			<div class="layui-form layui-form-pane">
				<div class="layui-form-item layui-form-text">
					<div class="layui-input-block" style="">
						<form action="" class="set-password" method="post" style="margin: 10px; line-height:20px; color:#808080;margin-top:0px;">
							@csrf
							
							<div class="layui-form layui-form-pane">
								<div class="layui-form-item" style="height:48px;">
									<div class="inputdiv" style="padding: 0px;">
										<select name="bank_code" id="bank_name" style="padding-left: 12px;width:100%">
											<option class="text-black" value="">Select</option>
											@foreach($banks as $bank)
												<option class="text-black" value="{{ $bank['bank_code'] }}" @if($bankCode == $bank['bank_code']) selected @endif >{{ $bank['name'] }}</option>
											@endforeach
										</select>
									</div>
								</div>

								<div class="layui-form-item" style="height:48px;">
									<div class="inputdiv">
										<i class="layui-icon layui-icon-layer"></i>
										<input type="number" name="account_number" id="account" placeholder="Enter Account Number" value="{{ $accountNumber }}" class="layui-input" autocomplete="off">
									</div>
								</div>

								<div class="layui-form-item" style="height:48px;">
									<div class="inputdiv">
										<i class="layui-icon layui-icon-user"></i>
										<input type="text" name="account_name" id="account_name" placeholder="Enter account name" value="{{ $accountName }}" class="layui-input" autocomplete="off">
									</div>
								</div>
								
								<input value="{{ $bankName }}" type="hidden" name="bank_name" id="bank_code">

								<div class="layui-form-item" style="height:48px;">
									<input class="layui-btn" id="confirm" value="SET BANK ACCOUNT" style="width: 100%; border: 0px; color: #fff; background: #000; height:45px; line-height:45px; border-radius: 25px; " type="submit" />
								</div>
							</div>
						</form>
						
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

@endsection

@push('script')
<textarea style="display: none;" id="all_banks">{!! $all_banks !!}</textarea>

<script>
    let all_banks = JSON.parse($("#all_banks").val());

    (function ($) {
        "use strict";

        function getByValue(value) {
            let arr = all_banks;
            for (var i = 0, iLen = arr.length; i < iLen; i++) {
                if (arr[i].bank_code == value) return arr[i].name;
            }
        }

        $("#bank_name").change(function (e) {
            let code = $("#bank_name").val();
            let account = $("#account").val();

            let t = getByValue(code);

            $("#bank_code").val(t);
            if (account != "" && code != "" && account == 10) {
                get_account_info(code, account);
            }
        });

        $("#account").change(function () {
            let code = $("#bank_name").val();
            let account = $("#account").val();

            if (account == "" || code == "" || account.length < 10) {
                $("#reg").prop('disabled', true);
                $("#account_name").val("");
                return;
            }
            get_account_info(code, account);
        });

        function get_account_info(code, account) {
			loading.showLoading({type: 2,tip: "Wait ..."});

            $.ajax({
                url: "{{ route('account.fetch') }}",
                type: 'get',
                dataType: 'json',
                data: {
                    'bank-verification': '',
                    'code': code,
                    'account': account
                },
                success: function (response) {
					loading.hideLoading();
                    if (response.status == "error") {
                        $("#account_name").val("");
						modalMessage("Could not get account details. Try again");
                        $("#reg").prop('disabled', false);
                        return;
                    }

                    $("#reg").removeAttr('disabled');
                    console.log(response.data);
                    $("#account_name").val(response.data.account_name);
					modalMessage("Account found ["+response.data.account_name+"]" );
                },

                error: function (err) {
                    console.log(err.responseText);
					loading.hideLoading();
                }
            });
        }

    })(jQuery);
</script>

@endpush
