@extends($activeTemplate.'layouts.dash')

@push('style-lib')
    <link rel="stylesheet" href="{{ asset('assets/app/style.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/app/payment.css') }}">
    <style>* {color: black;}</style>
@endpush

@section('content')
	<div>
		<form action="" method="POST" enctype="multipart/form-data" class="payment-container">
			<div>
				<!-- title with counterv and hour glasse -->
				<div class="title">
					<div>
						<img src="{{ asset('assets/app/img/hourglass.svg') }}" alt="hourglass">

						<!-- countdown container -->
						<p id="count-down"></p>
					</div>
				</div>
				<!-- end title -->

				<!-- step 1 -->
				<div class="step one">
					<!-- Payment info -->
					<p>Step one: Copy account and money</p>
					<div>
						<!-- detail -->
						<div>
							<p>Bank name</p>
							<p> {{ config('settings')->bank_name }} </p>
						</div>

						<!-- detail -->
						<div>
							<p>Recepient</p>
							<p> {{ config('settings')->account_name }} </p>
						</div>

						<!-- detail -->
						<div>
							<p>Account</p>
							<div>
								<span id="account_number"> {{ config('settings')->account_number }} </span>
								<button type="button" data-clipboard-target="#account_number"
									role="copy">Copy</button>
							</div>
						</div>

						<!-- detail -->
						<div>
							<p>Amount</p>
							<div>
								NGN<span>{{ number_format($data['final_amo'], 0, '', '') }}</span>
								<button type="button" role="copy">Copy</button>
							</div>
						</div>

					</div>
				</div>

				<!-- step 2 -->
				<div class="step two">
					<p>Step two: Copy transfer narration</p>
					<div>
						<div>
							<p>Narration</p>
							<div>
								<p>{{ $data['trx'] }}</p>
								<button type="button" role="copy">Copy</button>
							</div>
						</div>
					</div>
				</div>

				<!-- step 3 -->
				<div class="step three sender-info">
					<p>Step three: Proof of payment</p>

					<div>


						@if ($method->gateway_parameter)
							@foreach (json_decode($method->gateway_parameter) as $k => $v)
								@if ($v->type == 'text')
									<!-- input -->
									<input type="text" name="{{ $k }}" value="{{ old($k) }}"
										placeholder="{{ __($v->field_level) }}" />
								@elseif($v->type == 'file')
									<!-- input -->


									<p>
										Select {{ __(inputTitle($v->field_level)) }} @if ($v->validation == 'required')
										<span style="color: red;">*</span>
									@endif
									</p>
									<input type="file" style="display: block;" accept="image/*"
										name="{{ $k }}" value="{{ old($k) }}"
										placeholder="{{ __($v->field_level) }}">
								@endif
							@endforeach
						@endif

					</div>
				</div>

				<!-- step 3 -->
				<div class="step four guide">
					<p>Payment Guide</p>
					<div>

						<p>Open your bank app and make the transfer, Copy the bank account shown below and input the
							amount shown above</p>
					</div>
				</div>
				<!-- submit button -->
				<div>
					<button type="submit" class="submit-btn">I have made payment</button>
				</div>
				<br/><br/><br/><br/>
			</div>
		</form>
	</div>

	<script src="{{ asset('assets/app/js/copypaste.js') }}{{ $catch}}"></script>
	<script src="{{ asset('assets/app/js/pageTimeOut.js') }}"></script>
	<script>
		pageTimeOutCountDown({
			initialValue: 596,
			redirectTo: "{{ route('user.home') }}",
			containerId: 'count-down'
		})
	</script>
@endsection
