@extends($activeTemplate.'layouts.dash')

@push('style-lib')
    <link rel="stylesheet" href="{{ asset('assets/app/payment.css') }}">
    <style>* {color: black;} .payment-container>div>div.one>div>div{margin-bottom: 10px; border-bottom: 1px solid #e4e4e4;padding-bottom: 3px;}</style>
@endpush

@section('content')
<header class="">
	<div class="header h5MaxWidth clear display alignCenter">
		<a class="back iconfont icon-arrow-left-2" onclick="jumpLink('{{ route('user.deposit.history') }}');"></a>
		<h2 class="flex1">Channel payment</h2>
		<img id="QRCLogo" src="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}" style="padding:6px;display:none" class="back" />
	</div>
</header>


<div class="main" style="padding:0px;">
	<div style="width: 100%; margin: 0 auto; text-align: center;  position: relative; height: auto; overflow: hidden; background-image: linear-gradient(to top, rgba(255, 0, 0, 0), rgb(255 165 0));">
		<img src="{{ asset('assets/images/crypto-pay.png') }}" style=" width:100%;">
	</div>
	<div class="about" style="padding:10px;"></div>

	<div class="payment-container" style="min-height:auto;">
		<div>
			<div class="step one">
				<!-- Payment info -->
				<p>Kindly preview your deposit request</p>
				<div>
					<!-- detail -->
					<div>
						<p>Get amount</p>
						<p> {{ config('settings')->cur_sym }}{{showAmount($deposit->amount,0)}} </p>
					</div>

					<!-- detail -->
					<div>
						<p>Charges</p>
						<p> {{ showAmount($deposit->charge) }} </p>
					</div>

					<!-- detail -->
					<div>
						<p>Currency</p>
						<p> {{ $deposit->method_currency }} </p>
					</div>

					<!-- detail -->
					<div style="margin-bottom:0px;border-bottom:0px">
						<p>Pay amount</p>
						<div>
							<span style="font-weight:700;">{{ ($deposit->final_amo + 0) }}</span>
							<button type="button" role="copy">Copy</button>
						</div>
					</div>

				</div>
			</div>
			
			<div class="title" style="padding:5px;">
				<div>
					<img src="{{ asset('assets/app/img/hourglass.svg') }}" alt="hourglass">

					<!-- countdown container -->
					<span data-v-385ac480="" id="count-down"><span class="minutes">23</span>:<span class="seconds">53</span></span>
				</div>
			</div>
			<div class="step one accountInfo" data-v-c35495fc="" style="">
				<!-- Payment info -->
				<p>Payment details: copy wallet info </p>
				<div>
					<div>
						<p>Network</p>
						<p id="bankname"> USDT BEP 20</p>
					</div>

					<!-- detail -->
					<div>
						<p>Wallet</p>
						<div>
							<span id="account_number">{{ substr($deposit->btc_wallet, 0, 5) . str_repeat('*', 4) . substr($deposit->btc_wallet, -8) }}</span>
							<span style="display:none">{{ $deposit->btc_wallet }}</span>
							<button type="button" role="copy">Copy</button>
						</div>
					</div>

				</div>
				<div class="getQRcodeBtn clickBtn radius7PX flex3 display alignCenter justifyCenter" id="getQRC" onclick="getQRC()" style="padding:10px;color:#000;border-radius: 0 0 .75rem .75rem;">
					@lang('SCAN QR CODE')
				</div>
			</div>
			

			<!-- submit button -->
			<div>
				<button type="button" class="submit-btn confirmPay" onclick="confirmBox('CONFIRM PAYMENT','Are you sure you have made the payment of {{number_format($deposit->final_amo, 4)}} USDT to the generated wallet address?, click go ahead to verify payment.','{{ route('user.home') }}');" > I'VE PAID NOW</button>
			</div>
			
		</div>
	</div>
</div>
@endsection

@push('script')
	<script src="{{ asset('assets/app/js/copypaste.js') }}{{ $catch}}"></script>
	<script src="{{ asset('assets/app/js/pageTimeOut.js') }}{{ $catch}}"></script>
	<script src="{{ asset('users/js/jqueryqr.js') }}" type="text/javascript"></script>
	<script src="{{ asset('users/js/qrcode.js') }}" type="text/javascript"></script>

	<script>
		initializeClock({
			redirectTo: "{{ route('user.home') }}",
			container: 'count-down',
			deadline: new Date(Date.parse('{{$data->initiate}}'))
		});
		
		function getQRC() {
			var QRCodeHtml = ""
			QRCodeHtml += `<div id="invitationQRCode"><canvas width="400" height="400"></canvas></div>
			<div class="explain"></div>`;
			prompt('', QRCodeHtml, "QRCode", 1);

			$('#invitationQRCode').erweima({
				mode: 2,
				mSize: 8,
				image: $("#QRCLogo")[0],
				text: '{{ $deposit->btc_wallet }}',
			});
			$(".cancelBtn").on("click", function() {
				removePrompt("QRCode")
			})
		}
		
    </script>
@endpush