@extends($activeTemplate.'layouts.dash')

@section('content')
<div class="container">
    <div class="row justify-content-center">
            <div class="col-md-4">
                <img src="{{$deposit->gatewayCurrency()->methodImage()}}" class="card-img-top" alt="@lang('Image')" class="w-100">

            <div class="custom--card mt-2 text-center h-auto">
                <div class="card-body">
                    <form action="{{$data->url}}" method="{{$data->method}}">
                        <h4 class="text-center">@lang('Please Pay') {{showAmount($deposit->final_amo)}} {{__($deposit->method_currency)}}</h4>
                        <h4 class="my-3 text-center">@lang('To Get') {{showAmount($deposit->amount)}}  {{__(config('settings')->cur_text)}}</h4>
                        <script src="{{$data->src}}"
                            class="stripe-button"
                            @foreach($data->val as $key=> $value)
                            data-{{$key}}="{{$value}}"
                            @endforeach
                        >
                        </script>
                    </form>
                </div>
            </div>
        </div>

    </div>
</div>
@endsection
@push('script')
    <script src="https://js.stripe.com/v3/"></script>
    <script>
        (function ($) {
            "use strict";
            $('.stripe-button-el').addClass("btn btn--base").removeClass('stripe-button-el');
        })(jQuery);
    </script>
@endpush
