@extends($activeTemplate.'layouts.dash')

@push('style-lib')
    <link rel="stylesheet" href="{{ asset('assets/app/payment.css') }}">
    <style>* {color: black;} .payment-container>div>div.one>div>div{margin-bottom: 10px; border-bottom: 1px solid #e4e4e4;padding-bottom: 3px;}</style>
@endpush

@section('content')
<header>
	<div class="header h5MaxWidth clear display alignCenter">
		<a class="back iconfont icon-arrow-left-2"
		onclick="jumpLink('{{ route('user.deposit.history') }}');"></a>
		<h2>Channel payment</h2>
	</div>
</header>
<div class="main" style="padding:0px;">
	<div style="width: 100%; margin: 0 auto; text-align: center;  position: relative; height: auto; overflow: hidden;  ">
		<img src="{{ asset('assets/images/flutterwave.jpg') }}" style=" width:100%;">
	</div>
	<div class="about" style="padding:10px;">

	</div>

	<div class="payment-container" style="min-height:auto;">
		<div>
			<div class="step one">
				<!-- Payment info -->
				<p>Kindly preview your deposit request</p>
				<div>
					<!-- detail -->
					<div>
						<p>Get amount</p>
						<p> {{ config('settings')->cur_sym }}{{showAmount($deposit->amount,0)}} </p>
					</div>

					<!-- detail -->
					<div>
						<p>Charges</p>
						<p> {{ showAmount($deposit->charge) }} </p>
					</div>

					<!-- detail -->
					<div>
						<p>Currency</p>
						<p> {{ $deposit->currency }} </p>
					</div>

					<!-- detail -->
					<div style="margin-bottom:0px;border-bottom:0px">
						<p>Pay amount</p>
						<div>
							<span style="font-weight:700;">{{ number_format($deposit->final_amo, 0, '', '') }}</span>
							<button type="button" role="copy">Copy</button>
						</div>
					</div>

				</div>
			</div>
			
			<?php if( $deposit->detail ){ ?>
			<div class="title" style="padding:5px;">
				<div>
					<img src="{{ asset('assets/app/img/hourglass.svg') }}" alt="hourglass">

					<!-- countdown container -->
					<span data-v-385ac480="" id="count-down"><span class="minutes">23</span>:<span class="seconds">53</span></span>
				</div>
			</div>
			<div class="step one accountInfo" data-v-c35495fc="" >
				<!-- Payment info -->
				<p>Payment details: copy bank info </p>
				<div>
					<div>
						<p>Bank name</p>
						<p id="bankname"> {{$deposit->detail->bank_name}} </p>
					</div>

					<!-- detail -->
					<div>
						<p>Recepient</p>
						<p id="recepient"> {{ str_replace('Please make a bank transfer to','', $deposit->detail->note) }} </p>
					</div>

					<!-- detail -->
					<div>
						<p>Account</p>
						<div>
							<span id="account_number">{{$deposit->detail->account_number}}</span>
							<button type="button" role="copy">Copy</button>
						</div>
					</div>

				</div>
			</div>
			<?php }else{ ?>
			<div class="step one accountInfo" data-v-c35495fc="" style="display: none;">
				<!-- Payment info -->
				<p>Payment details: copy bank info </p>
				<div>
					<div>
						<p>Bank name</p>
						<p id="bankname"> loading...</p>
					</div>

					<!-- detail -->
					<div>
						<p>Recepient</p>
						<p id="recepient"> loading... </p>
					</div>

					<!-- detail -->
					<div>
						<p>Account</p>
						<div>
							<span id="account_number"> loading... </span>
							<button type="button" role="copy">Copy</button>
						</div>
					</div>

				</div>
			</div>
			<?php } ?>
			
			<!-- step 2 -->
			<div class="step two">
				<p>Step two: Copy transfer narration</p>
				<div>
					<div>
						<p>Narration</p>
						<div>
							<p>{{ $deposit->trx }}</p>
							<button type="button" role="copy">Copy</button>
						</div>
					</div>
				</div>
			</div>

			<!-- submit button -->
			<div>
				@if( $data->virtual_account == 1)
				<?php if( $deposit->detail ){ ?>
					<button type="button" class="submit-btn confirmPay" onclick="confirmBox('CONFIRM PAYMENT','Are you sure you have made the payment of {{number_format($deposit->final_amo,2)}} {{ $deposit->currency}} to the generated account?, click go ahead to verify payment.','{{ route('user.home') }}');" > I'VE PAID NOW</button>
				<?php }else{ ?>
					<button type="button" id="btn-confirm" class="submit-btn apiLink" data-href="{{ route('user.payment.flutterwave',[@$deposit->id]) }}" data-name="{{ $data->txref }}">Generate bank details</button>
					<button type="button" class="submit-btn confirmPay" style="display:none" onclick="confirmBox('CONFIRM PAYMENT','Are you sure you have made the payment of {{number_format($deposit->final_amo,2)}} {{ $deposit->currency}} to the generated account?, click go ahead to verify payment.','{{ route('user.home') }}');" > I'VE PAID NOW</button>
				<?php } ?>
				@else
					<button class="btn submit-btn" id="btn-confirm" onClick="payWithRave()" type="button" data-v-385ac480="">@lang('PAY NOW')</button>
				@endif
			</div>
			
		</div>
	</div>
</div>

@endsection

@push('script')
	<script src="{{ asset('assets/app/js/copypaste.js') }}{{ $catch}}"></script>
	<script src="{{ asset('assets/app/js/pageTimeOut.js') }}{{ $catch}}"></script>
	@if( $data->virtual_account == 0)
    <script src="https://api.ravepay.co/flwv3-pug/getpaidx/api/flwpbf-inline.js"></script>
	@endif

	<script>
		var reactModal = $('.accountInfo');
		<?php if( $data->virtual_account == 0){ ?>
        "use strict"
        const API_publicKey = "{{$data->API_publicKey}}";
        function payWithRave() {
            var x = getpaidSetup({
                PBFPubKey: API_publicKey,
                customer_email: "{{$data->customer_email}}",
                amount: "{{$data->amount }}",
                customer_phone: "{{$data->customer_phone}}",
                currency: "{{$data->currency}}",
                txref: "{{$data->txref}}",
                onclose: function () {
                },
                callback: function (response) {
                    var txref = response.tx.txRef;
                    var status = response.tx.status;
                    var chargeResponse = response.tx.chargeResponseCode;
                    if (chargeResponse == "00" || chargeResponse == "0") {
                        window.location = '{{ url('ipn/flutterwave') }}/' + txref + '/' + status;
                    } else {
                        window.location = '{{ url('ipn/flutterwave') }}/' + txref + '/' + status;
                    }
                        // x.close(); // use this to close the modal immediately after payment.
                 }
            });
        }
		<?php } ?>
		
		$(document).on("click", ".apiLink", function() {
			<?php if( $deposit->detail ){ ?>
			reactModal.show();
			<?php }else{ ?>
			var name = $(this).data('name');
			var link = $(this).data('href');

            toast("", "LOADING...", "loading", 5000, 4);

			var a = $.get(link);
			a.done(function(b) {
				console.log(b);
				if( b.status == 'success'){
					$('#bankname').html(b.data.bankname);
					$('#recepient').html(b.data.recepient);
					$('#account_number').html(b.data.account_number);
					reactModal.show();
					toast('', 'Now procced to pay', '', 3000, 1);
					$('.apiLink').hide();
					$('.confirmPay').show();
				}else{
					toast('', b.message.success, '', 3000, 1);
				}
			}), a.fail(function(x) {
				console.log(x);
				toast('', 'Request not completed, try again','',3000,1);
			});
			<?php } ?>
		});

		initializeClock({
			redirectTo: "{{ route('user.home') }}",
			container: 'count-down',
			deadline: new Date(Date.parse('{{$data->initiate}}'))
		});
    </script>
@endpush
