@extends($activeTemplate.'layouts.dash')

@push('style')
    <style type="text/css">
        input::placeholder {color: #333;}
        .payitem {border: 1px solid #fff !important;border-radius: 25px;background: rgb(53,82,255);color:#FFF;}
		.payitem:before {content: '';position: absolute;right: 0;bottom: 0;}
		.payitem:after {
			content: '';width: 5px;height: 12px;position: absolute;right: 6px;bottom: 6px;background: rgb(53,82,255); 
			border: 5px solid #fff;border-top-color: transparent;border-left-color: transparent;transform: rotate(45deg);border-bottom-right-radius: 2px;
		}
        .inputdiv {border:0px !important;border-bottom: 1px solid #888 !important;background: none;padding: 0px 0px;border-radius: 0px;}
        .layui-input {border-style: none;background-color: none;}
    </style>
@endpush

@section('content')
    <div class="top" style="background: none; border: 0px !important;">
        <div data-href="{{ route('user.home') }}" style="float:left; line-height:46px;width:50%; height:46px;cursor:pointer;" class="linkBTN">
			<img src="/assets/images/arrow-back-up-white.png" style="margin-left:12px;width:32px;" />
        </div>
        <div class="topname " id="topname1" style="line-height: 50px; font-weight: bold; color: #fff;">&nbsp;</div>
        <div class=" linkBTN" data-href="{{ route('user.transaction.type', ['type' => 'withdraw']) }}" style="float:right; text-align:right; line-height:46px;width:50%;" id="log">
            <img src="/assets/images/iconlog.png" style="height: 27px;  margin-right: 10px; margin-bottom: 2px; border-radius: 50px;">
        </div>
    </div>
	@php
		$accountNumber = ($user->bankAccount) ? $user->bankAccount->account_number : 'CRYPTO';
		$accountName = ($user->bankAccount) ? explode(' ', $user->bankAccount->account_name)[0] : $user->withdrawal_usdt_address;
		$bankName = ($user->bankAccount) ? $user->bankAccount->bank_name : 'USDT';
	@endphp

	<div style="height:auto; overflow:hidden; ">
		<div style="width: 100%; margin: 0 auto; background: none; height: auto; overflow: hidden; ">
			<div style="background: url(/assets/images/withdrawal.webp) no-repeat; background-size: 100% 100%; width: 100%; margin: 0 auto; height: 280px;">
				<div style="color: #fff; padding-left: 80px; padding-top: 208px; font-size: 22px; ">
					{{ $currency['cur_sym'] }}<font id="useramount" style="padding-left: 5px; font-weight: bold; font-size: 22px; padding-top: 15px; font-family: HarmonyOS Sans SC;">{{ showAmount($userBalance['income']) }}</font>
				</div>
				<div style="padding-left: 80px; padding-top: 5px; font-weight: bold; color: #888; font-size: 12px;">Withdrawable funds</div>
			</div>
		</div>
		
		<div style="width: 100%; margin: 0 auto; background: #fff; padding-bottom: 3px; padding-top:10px; ">
			<div style="width:95%; margin:0 auto;  padding-bottom:3px;border-radius:2px; overflow:hidden;">

				<div style="width:100%; margin:0 auto;  margin-top:10px; padding-top:10px; padding-bottom:20px;border-radius:5px;height:auto; overflow:hidden; display:block;">
					<div style="padding-left:10px; padding-bottom:10px;font-weight:bold; color:#000;">Withdrawal method &nbsp;&nbsp;&nbsp;</div>
					<div id="paylist">
						<div style="width:46%;border: 1px solid #000;cursor:pointer; float:left;margin-left:2%; margin-top:10px; text-align:center;position: relative;border-radius: 25px;" class="payitem channelitem" value="1">
							<div style="padding:10px; padding-left:0px; font-size:14px; padding-right:0px;">Bank Card</div>
						</div>
						<div style="width:46%;border: 1px solid #000;cursor:pointer; float:left;margin-left:2%; margin-top:10px; text-align:center;position: relative;border-radius: 25px;" class="payitem1 channelitem" value="2">
							<div style="padding:10px; padding-left:0px; font-size:12px; padding-right:0px;">USDT</div>
						</div>
					</div>
				</div>
				<div>
					<div class="layui-form-item">
						<div style="width:98%; margin:0 auto;" id="amountlist">
						</div>
					</div>
					
					<div style="text-align: center; width: 98%; margin: 0 auto; margin-bottom: 15px; margin-top:15px; height: auto; overflow: hidden;">
						<button class="inputdiv" style="line-height: 38px; width: 100%; height: 45px; border: 0px; background-color: #fff; padding: 0 0px; z-index: 500;" id="selectcard">
							<img src="/assets/images/1.png" style="height:22px; margin-top:7px;" id="imgurl"> 
							<font style="margin-left: 10px; height: 38px; width: 100%; color: #000; text-align: left;" id="select_card">{{ $accountNumber }}</font>
							<div style="float: left; width: 10%; text-align: right; height: 35px; line-height: 38px; color: #000; ">
								<i class="layui-icon layui-icon-right"></i>
							</div>
						</button>

						<div style="width: 98%; margin: 0 auto; text-align: left; margin-top: 20px; color: #000; font-weight: bold;">
							Withdrawal amount &nbsp;&nbsp;&nbsp;
						</div>
						<div class="inputdiv">
							<div style="width:30px;color:#000;">{{ $currency['cur_sym'] }}</div>
							<input type="number" name="amount" id="amount" oninput="if(value.length&gt;10)value=value.slice(0,10)" style="font-size: 12px; color: #000; background-color: #fff; padding-left: 10px; " placeholder="Please enter the withdrawal amount" class="layui-input" autocomplete="off" />
						</div>
						
						<div style="width:100%; height:25px;  line-height:25px; text-align:left;margin-top:10px; display:block;">
							<span style="float: left; color: #ff6a00; margin-left:10px; font-size:12px;"><font id="_withdrawal_t11">Minimum</font> {{ $currency['cur_sym'] }}<font id="wi_min">{{ showAmount($withdrawMethod[0]->min_limit) }}</font> </span>
							<font style="float:right;color: #ff6a00; font-size:12px;"><font id="_withdrawal_t12">Maximum</font> {{ $currency['cur_sym'] }}<font id="wi_max">{{ showAmount($withdrawMethod[0]->max_limit) }}</font> </font>
						</div>

						@if( $user->withdrawal_password )
						<div style="width: 98%; margin: 0 auto; text-align: left; margin-top: 20px; color: #000; font-weight: bold; display:block;">
							Transaction Password
						</div>
						<div class="inputdiv passwordIn">
							<img src="/assets/images/i2.png" style="height:22px; margin-top:7px;" /> 
							<input type="password" id="paypassword" maxlength="20" name="password" style="color: #fff; padding-left: 15px;" placeholder="Please enter transaction password" autocomplete="off" class="layui-input" />
							<div class="viewPass" style="float: left; width: 10%; text-align: right; height: 35px; ">
								<img src="/assets/images/eye-fill.png" style="margin-right:5px;color:#000; height:21px; ">
							</div>
						</div>
						@endif

						@csrf
						<input type="hidden" id="method" value="{{ $withdrawMethod[0]->id}}">
						<input type="hidden" id="debit_with" value="2">
						<input id="bankid" type="hidden" value="29772">
						<input id="channel" type="hidden" value="{{ $withdrawMethod[0]->id}}">
						<input id="uhuilv" type="hidden" value="742.0000">
						<input id="bank_free" type="hidden" value="{{ ($withdrawMethod[0]->percent_charge/100) }}">
						
						<div style="width: 100%; height: 25px; line-height: 30px; margin-top:10px;border-width: 0px; border-style: solid; border-radius: 2px 2px 2px 2px; text-align: left;">
							<span style=" float:left;font-size:12px; color:#000;  ">
								<font>Amount received</font>:
								<font id="jieguo1"></font>
							</span>
							<span style="color: #000; float: right; font-size: 12px; "><font>Tax</font>: <font id="free">{{ $withdrawMethod[0]->percent_charge}}</font>%</span>
						</div>
					</div>
				</div>

			</div>
		</div>

		<div style="width:100%; margin:0 auto; background:#fff; margin-top:5px;">
			<div style="height: 35px; line-height: 35px; text-align: left;"><span style="margin-left:3%; color:#000; font-weight:bold; ">Withdrawal instructions</span></div>
			<div style="text-align: justify; padding:20px; padding-top:0px; height:auto; overflow:hidden;color:#999; " id="wiinfo">
				{!! $withdrawMethod[0]->description !!}
			</div>
		</div>
		<div style=" background:#fff; text-align: center;width:100%; margin:0 auto; padding-bottom:20px; margin-top:5px; margin-bottom:85px;">
			<input class="layui-btn recharge-btn" id="Submit" value="Withdraw money now" style="width: 60%; margin-top: 25px; height: 45px; line-height: 45px; font-weight: bold; color: #fff; font-size: 14px; border-radius: 25px; border: 0px; background:#000; " type="button">
		</div>
		
	</div>
@endsection

@push('script')

<script>
	var currency = "{{ $currency['cur_sym'] }}";
	$("#amount").keydown(function () {
		var channel = $("#channel").val();
		var a = $("#amount").val();
		if (a == null || a == "")
			a = 1;
		var free = $("#bank_free").val();
		var freeamount = a * free * 1;
		var sjamount = a - freeamount;
		sjamount = Number(sjamount.toString().match(/^\d+(?:\.\d{0,0})?/))
		$("#jieguo1").html(currency + sjamount.toFixed(2));
	});

	$("#amount").keyup(function () {
		var channel = $("#channel").val();
		var a = $("#amount").val();
		if (a == null || a == "")
			a = 1;
		var free = $("#bank_free").val();
		var freeamount = a * free * 1;
		var sjamount = a - freeamount;
		sjamount = Number(sjamount.toString().match(/^\d+(?:\.\d{0,0})?/))
		$("#jieguo1").html(currency + sjamount.toFixed(2));
	});

	$(document).on("click", '#amount', function () {
		var channel = $("#channel").val();
		var a = $("#amount").val();
		if (a == null || a == "")
			a = 1;
		var free = $("#bank_free").val();
		var freeamount = a * free * 1;
		var sjamount = a - freeamount;
		sjamount = Number(sjamount.toString().match(/^\d+(?:\.\d{0,0})?/))

		$("#jieguo1").html(currency + sjamount.toFixed(2));
	});

	$(document).on("click", '.channelitem', function () {
		$(".channelitem").each(function () {
			$(this).addClass("payitem1");
			$(this).removeClass("payitem");
		});
		$(this).addClass("payitem");
		$(this).removeClass("payitem1");
		var id = $(this).attr("value");
		$("#channel").val(id);

		if (id == "1") {
			$("#imgurl").attr("src", "/assets/images/1.png");
			$("#imgurl").attr("style", "height:22px; margin-top:7px;");
		}
		if (id == "2") {
			$("#imgurl").attr("src", "/assets/images/bt9.png");
			$("#imgurl").attr("style", "height:25px; margin-top:5px;");
		}

		var channel = $("#channel").val();
		var a = $("#amount").val();
		if (a == null || a == "")
			a = 1;
		var free = $("#bank_free").val();
		var freeamount = a * free * 1;
		var sjamount = a - freeamount;
		sjamount = Number(sjamount.toString().match(/^\d+(?:\.\d{0,0})?/))
		$("#jieguo1").html(currency + sjamount.toFixed(2));
	});

	<?php if(config('settings')->debit_with == "balance"){ ?> 
	var inNg = {{$user->balance}}; var inUS = {{$user->usdt_balance}};
	<?php }elseif( config('settings')->debit_with == "income" ){ ?>
	var inNg = {{$user->income}}; var inUS = {{$user->usdt_income}};
	<?php }else{?>
	var inNg = {{$user->balance + $user->income}}; var inUS = {{ $user->usdt_balance + $user->usdt_income }};
	<?php }?>

    $(".recharge-btn").click(function() {
        // Form input Value
        var amount = $('#amount').val();
        var method = $('#method').val();
        var debit_from = $('#debit_with').val();
        var password = ''; var currency = '';
		var channel = $("#channel").val();
        var token = document.querySelector('input[name="_token"]').value;
        var is_status = true;

        if (!amount) {
            modalMessage("Please enter withdrawal amount 請輸入提款金額");
            is_status = false; return false;
        }

        if (!debit_from) {
            modalMessage("Please select debit wallet");
            is_status = false; return false;
        }

		<?php if( $user->withdrawal_password ){ ?>
        password = $('#paypassword').val();
        if (!password) {
            modalMessage("Please enter transaction password 交易密碼");
            is_status = false; return false;
        }
		<?php } ?>

		if( channel == 1){
			if (amount > inNg) {
				modalMessage("[餘額不足] Insufficient Naira. Balance ₦"+inNg);
				is_status = false;
			}
			currency = 'NGN';
		}

		if( channel == 2){
			if (amount > inUS) {
				modalMessage("[餘額不足] Insufficient USDT. Balance $"+inUS);
				is_status = false;
			}
			currency = 'USDT';
		}


        if (is_status) {

            $.ajax({
                type: "POST",
                url: "{{ route('user.withdraw.money') }}",
                data: {
                    amount: amount,
                    method: method,
                    debit_from: debit_from,
                    currency: currency,
                    password: password,
                    _token: token
                },
                beforeSend: function() {
					loading.showLoading({type: 2,tip: "Wait 等待.."});
                },
                success: function(data) {
                    loading.hideLoading();
                    modalMessage(data.message, 200, data.link);
                },
                error: function(xhr, status, error) {
                    var responseText = JSON.parse(xhr.responseText);

                    loading.hideLoading();
                    modalMessage(responseText.message);
                },
                fail: function() {
                    loading.hideLoading();
                    modalMessage("Request Failed");
                }
            });
        }


        return false;
    })
</script>
@endpush