<!-- meta tags and other links -->
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  @include('partials.seo')

  <title>@if(View::hasSection('pageTitle')) @yield('pageTitle') @else {{ config('settings')->sitename(__($pageTitle)) }} @endif</title>
  <link rel="shortcut icon" type="image/x-icon" href="{{ asset('users/assets/trade/img/favicon.png') }}" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/tiny-slider/2.9.4/tiny-slider.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css"/>
  <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
  <link rel="stylesheet" href="{{ asset('users/assets/trade/css/style.css') }}{{$catch}}" >
  <link rel="stylesheet" href="{{ asset('users/assets/trade/css/extra.css') }}{{$catch}}" >
  <link rel="stylesheet" href="{{ asset('users/assets/trade/css/loading.css') }}{{$catch}}" >
  <script src="https://code.iconify.design/iconify-icon/1.0.7/iconify-icon.min.js"></script>
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

  @stack('style-lib')

  @stack('style')

</head>
  <body>

  @if(View::hasSection('container')) @yield('container') @else <div class="main-container"> @endif
        @if(View::hasSection('wrapper')) @yield('wrapper') @else <div class="wrapper"> @endif
        
        @if(View::hasSection('header')) @yield('header') @endif
          
        @yield('content')
        @include($activeTemplate. 'layouts.home_footer')
        </div>
  </div>

  @stack('script')

  <script src="{{ asset('users/assets/trade/js/loading.js') }}?ver={{ time() }}"></script>
  <script src="{{ asset('users/assets/trade/js/app.js') }}?ver={{ time() }}"></script>
  
  @include($activeTemplate. 'partials.notify')
  </body>
</html>
