@extends("layouts.auth")

@push("page_title") Login @endpush

@push('style')
<style>
    .appHeader {
        background: none;
    }

    .long img {
        width: 170px;
        display: block;
        margin: auto;
    }

    .longbane img {
        width: 100%;
        position: absolute;
        bottom: 0;
    }

    .weui_hearder {
        position: inherit;
    }

    .poho {
        display: flex;
        background-color: #f9f9f9;
        border: 1px solid #dcdcdc;
        border-radius: 8px;
    }

    .poho span {
        padding: 0 10px;
        height: 45px;
        line-height: 45px;
    }

    .poho input {
        border: none;
    }

    .bne h2 {
        color: #fff;
    }
</style>
@endpush

@section('content')
	<div class="login" data-v-8e930492="">
		<div class="nav-top" data-v-8e930492="">
			<div class="nav-left" data-v-8e930492="">
				<p class="titlehe" data-v-8e930492="">Reset Password!</p>
				<p class="welour" data-v-8e930492="">Provide mobile phone details</p>
			</div>
			
			<img class="nav-right" src="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}" alt="" data-v-8e930492="">
		</div>
		
		<div class="content-enter" data-v-8e930492="" style="margin-top:15rem">

			<div action="" method="POST" class="form verify-gcaptcha account-form">

				<div class="input-layer" data-v-8e930492="">
					<div class="van-cell van-field input-box" data-v-8e930492="">
						<div class="van-field__left-icon">
							<div class="moblieui" data-v-8e930492="">
								<p data-v-8e930492="">Mobile</p><span data-v-8e930492="">+234</span>
							</div>
						</div>
						<div class="van-cell__value van-cell__value--alone van-field__value">
							<div class="van-field__body">
								<input type="number" name="username" inputmode="numeric" id="username" class="van-field__control" placeholder="Enter phone number" />
							</div>
						</div>
					</div>
				</div>
				@csrf

				<a data-href="{{ route('user.register') }}" class="inkBTN forget-psw">JUST REGISTER</a>

				<button type="submit" class="btnlog" id="btn-submit" data-v-8e930492="">REQUEST</button>
			</div>
			
			<p class="orbix" data-v-8e930492="">Or</p>

			<button type="button" class="btnregi inkBTN" data-href="{{ route('user.login') }}" data-v-8e930492="">LOGIN, I REMEMBER</button>

		</div>

		<a href="#" class="whatappbox" data-v-8e930492=""><img src="{{ asset('users/assets/trade/img/help.png') }}" alt="" data-v-8e930492=""></a>
	</div>

@endsection

@push('script')
<script>
    $('#username').on('keyup', function() {
        
        // Get value
        var inputValue = $(this).val();

        // Remove non-digit characters
        var numericValue = inputValue.replace(/\D/g, '');

        // Keep value to 10 digits
        var truncatedValue = numericValue.slice(0, 10);

        // Update the input value
        $(this).val(truncatedValue);
    });
    
    $('#btn-submit').on('click', function() {
        
        // Form input Value
        var username = $('#username');
        var token = document.querySelector('input[name="_token"]').value;

        // Enable form submit
        var is_status = true;

        // Verify input
        if (!username.val()) {
            modalMessage('Please enter your mobile');
            is_status = false;
            return true;
        }
        // End Verify

        if (is_status) {
            $.ajax({
                url: "{{ route('user.password.email') }}",
                type: 'POST',
                data: {
                    username: username.val(),
                    _token: token
                },
                beforeSend: function() {
                    // Handle before sending the request
                    mui.showLoading("Please wait...", "div");
                },
                success: function(data) {
                    
                    // Redirect
                    modalMessage(data.message, 200, data.link);
                },
                error: function(xhr, status, error) {
                    var data = JSON.parse(xhr.responseText);
                    var responseMessage = data.message

                    // Validator message
                    if (data.errors) {
                        var errorMessages = [];
                        for (var key in data.errors) {
                            if (data.errors.hasOwnProperty(key)) {
                                errorMessages.push(data.errors[key][0]);
                            }
                        }

                        responseMessage = errorMessages.join(", ")
                    }

                    // Redirect
                    if(data.link) {
                        modalMessage(data.message, 400, data.link);
                        return true;
                    }

                    mui.hideLoading();
                    modalMessage(responseMessage);
                }
            });
        }
    })
</script>
@endpush