@extends("layouts.auth")

@section('pageTitle') Register @endsection

@push('style')
@endpush


@section('content')
	<div class="login" data-v-8e930492="">
		<div class="nav-top" data-v-8e930492="">
			<div class="nav-left" data-v-8e930492="">
				<p class="titlehe" data-v-8e930492="">Hello!</p>
				<p class="welour" data-v-8e930492="">Create a new account</p>
				<p class="welour" data-v-8e930492="">Register to get <span>@if(config('settings')->register_bonus) {{ config('settings')->cur_sym . config('settings')->register_bonus }} @endif</span> bonus</p>
			</div>
			
			<img class="nav-right" src="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}" alt="" data-v-8e930492="">
		</div>
		
		<div class="content-enter" data-v-8e930492="">

			<div action="" method="POST" class="form verify-gcaptcha account-form">

				<div class="input-layer" data-v-8e930492="">
					<div class="van-cell van-field input-box" data-v-8e930492="">
						<div class="van-field__left-icon">
							<div class="moblieui" data-v-8e930492="">
								<p data-v-8e930492="">Invite Code</p>
							</div>
						</div>
						<div class="van-cell__value van-cell__value--alone van-field__value">
							<div class="van-field__body">
								<input type="text" name="invite" inputmode="numeric" value="{{ Session::get('reference') }}" id="invite" class="van-field__control" placeholder="Invite code [optional]" />
							</div>
						</div>
					</div>
				</div>

				<div class="input-layer" data-v-8e930492="">
					<div class="van-cell van-field input-box" data-v-8e930492="">
						<div class="van-field__left-icon">
							<div class="moblieui" data-v-8e930492="">
								<p data-v-8e930492="">Phone</p><span data-v-8e930492="">+234</span>
							</div>
						</div>
						<div class="van-cell__value van-cell__value--alone van-field__value">
							<div class="van-field__body">
								<input type="number" name="username" inputmode="numeric" id="username" class="van-field__control" placeholder="Enter phone number" />
							</div>
						</div>
					</div>
				</div>


				<div class="input-layer" data-v-8e930492="">
					<div class="van-cell van-field input-box" data-v-8e930492="">
						<div class="van-field__left-icon">
							<div class="moblieui" data-v-8e930492="">
								<p data-v-8e930492="">Password</p>
							</div>
						</div>
						<div class="van-cell__value van-cell__value--alone van-field__value">
							<div class="van-field__body passwordIn">
								<input type="password" id="password" class="van-field__control" name="password" placeholder="Enter password">
								<div class="van-field__right-icon viewPass">
									<img src="data:image/png;base64,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" alt="" data-v-8e930492="">
								</div>
							</div>
						</div>
					</div>
				</div>
				

				<div class="input-layer" data-v-8e930492="">
					<div class="van-cell van-field input-box" data-v-8e930492="" style="padding: 1px;">
						<img class="van-field__left-icon" id="security_image" style='width:85px;height: 100%; border-radius: 5%;' data-v-8e930492="" src="{!! generateCaptchaImage() !!}" onclick="refreshCaptcha()" />
						<div class="van-cell__value van-cell__value--alone van-field__value">
							<div class="van-field__body">
								<input type="number" id="captcha" max="4" class="van-field__control" name="captcha" placeholder="Captcha code">
							</div>
						</div>
					</div>
				</div>

				@csrf

				<button type="submit" class="btnlog" id="btn-submit" data-v-8e930492="">REGISTER</button>
			</div>
			
			<p class="orbix" data-v-8e930492="">Or</p>

			<button type="button" class="btnregi inkBTN" data-href="{{ route('user.login') }}" data-v-8e930492="">LOGIN</button>

		</div>

		<a href="#" class="whatappbox" data-v-8e930492=""><img src="{{ asset('users/assets/trade/img/help.png') }}" alt="" data-v-8e930492=""></a>
	</div>
@endsection

@push('script')
<script>
    function refreshCaptcha() {
        // Reload the CAPTCHA image
        document.querySelector('#security_image').src = "{{ route('security.image') }}?" + new Date().getTime();
    }

    $('#username').on('keyup', function() {
        
        // Get value
        var inputValue = $(this).val();

        // Remove non-digit characters
        var numericValue = inputValue.replace(/\D/g, '');

        // Keep value to 10 digits
        var truncatedValue = numericValue.slice(0, 10);

        // Update the input value
        $(this).val(truncatedValue);
    });

    $('#btn-submit').on('click', function() {
        
        // Form input Value
        var username = $('#username');
        var password = $('#password');
        var password_confirmation = $('#password');
        var invite = $('#invite');
        var captcha = $('#captcha');
        var token = document.querySelector('input[name="_token"]').value;

        // Enable form submit
        var is_status = true;

        // Verify input
        if (!username.val()) {
            modalMessage('Please enter your Mobile Number');
            is_status = false;
            return true;
        }

        if (!password.val()) {
            modalMessage('Please enter your password');
            is_status = false;
            return true;
        }

        if (!password_confirmation.val()) {
            modalMessage('Please confirm your password');
            is_status = false;
            return false;
        }

        if (!captcha.val()) {
            modalMessage('Please enter security code');
            is_status = false;
            return true;
        }
        // End Verify

        if (is_status) {
            $.ajax({
                url: "",
                type: 'POST',
                data: {
                    username: username.val(),
                    mobile: username.val(),
                    password: password.val(),
                    password_confirmation: password_confirmation.val(),
                    referBy: invite.val(),
                    captcha: captcha.val(),
                    _token: token
                },
                beforeSend: function() {
                    // Handle before sending the request
                    mui.showLoading("Please wait...", "div");
                },
                success: function(data) {
                    
                    // Redirect
                    modalMessage('Registered Successfully', 200, "{{ url(route('user.home')) }}");
                },
                error: function(xhr, status, error) {
                    var data = JSON.parse(xhr.responseText);
                    var responseMessage = data.message

                    // Validator message
                    if (data.errors) {
                        var errorMessages = [];
                        for (var key in data.errors) {
                            if (data.errors.hasOwnProperty(key)) {
                                errorMessages.push(data.errors[key][0]);
                            }
                        }

                        responseMessage = errorMessages.join(", ")
                    }

                    // Redirect
                    if(data.link) {
                        modalMessage(data.message, 400, data.link);
                        return true;
                    }

                    mui.hideLoading();
                    modalMessage(responseMessage);
                }
            });
        }
    })
</script>
@endpush