@extends($activeTemplate.'layouts.home')

@push('style')
  <link rel="stylesheet" href="{{ asset('users/assets/trade/css/recharge.css') }}?ver={{ time() }}" >
@endpush

@section('wrapper')<div class="wrapper zero-padding">@endsection

@section('header')
<div class="recharge-heading">
    <!-- top nav -->
    <div class="transparent">
        <a class="linkBTN" data-href="{{ route('user.home') }}">
            <iconify-icon icon="pepicons-pop:angle-left" width="20" height="20"></iconify-icon>
        </a>

        <div>
            <p>BANK SETUP</p>
        </div>

        <a class="linkBTN" data-href="{{ route('user.home') }}">
            <iconify-icon icon="pepicons-pop:angle-left" width="30" height="30"></iconify-icon>
        </a>
    </div>
    <!-- end top nav -->

    <div style="width: 75%; margin-top: -20px;">
        <p><sup></sup></p>
        <p>Fill the form below to set up your account details for withdrawal</p>
    </div>
</div>
@endsection

@php
	$accountNumber = (auth()->user()->bankAccount) ? auth()->user()->bankAccount->account_number : '';
	$accountName = (auth()->user()->bankAccount) ? auth()->user()->bankAccount->account_name : '';
	$bankName = (auth()->user()->bankAccount) ? auth()->user()->bankAccount->bank_name : '';
	$bankCode = (auth()->user()->bankAccount) ? auth()->user()->bankAccount->bank_code : '';
@endphp

@section('content')
<!-- package container -->
<div class="message-box">
	<div class="u-popup popView" id="accountModel" style="display:block;bottom: 4.6rem;">
		<form class="guize_html formPost" form action="" method="post" role="form" style="width:100%">
			<div class="Ikdcls linkBTN" data-href="{{ route('user.home') }}"><iconify-icon class="beautiful-text" width="45" height="45" icon="carbon:close-filled"></iconify-icon></div>
			<span class="guize_html_nei">

				<div class="team-container !p-0 flex flex-col gap-y-2 !bg-transparent" style="margin-top:0px;margin-bottom:0px;">
					<div class="recharge-input" style="margin-top: 15px;">
						<div>
							<select name="bank_code" id="bank_name">
								<option class="text-black" value="">Select bank name</option>
								@foreach($banks as $bank)
									<option class="text-black" value="{{ $bank['bank_code'] }}" @if($bankCode == $bank['bank_code']) selected @endif >{{ $bank['name'] }}</option>
								@endforeach
							</select>
						</div>
					</div>

					<div class="recharge-input" style="margin-top: -5px;background: none;">
						<div>
							<iconify-icon class="beautiful-text" width="25" height="25" icon="carbon:account"></iconify-icon>
							<input type="number" name="account_number" id="account" class="" value="{{ $accountNumber }}" placeholder="Account number">
						</div>
					</div>

					<div class="recharge-input" style="margin-top: -5px;background: none;">
						<div>
							<iconify-icon class="beautiful-text" width="25" height="25" icon="hugeicons:user-account"></iconify-icon>
							<input type="text" name="account_name" id="account_name" class="" value="{{ $accountName }}" placeholder="Account name">
						</div>
					</div>
					<input value="{{ $bankName }}" type="hidden" name="bank_name" id="bank_code">
					@csrf
				</div>
			</span>

			<div class="btnyu" style="width:100%;border-radius:0px;margin:10px auto 0px;height:50px;">
				<div class="nav" data-v-1ae6f7fb="" data-v-70859265="" style="border-radius: 0;height:100%">
					<button type="submit" id="reg" class="item usdt" data-v-1ae6f7fb=""><span data-v-1ae6f7fb="">SAVE ACCOUNT</span></button>
				</div>
			</div>
		</form>
	</div>
</div>

@endsection

@push('script')
<textarea style="display: none;" id="all_banks">{!! $all_banks !!}</textarea>

<script>
    let all_banks = JSON.parse($("#all_banks").val());

    (function ($) {
        "use strict";

        function getByValue(value) {
            let arr = all_banks;
            for (var i = 0, iLen = arr.length; i < iLen; i++) {
                //console.log(arr[i]);
                if (arr[i].bank_code == value) return arr[i].name;
            }
        }

        $("#bank_name").change(function (e) {
            let code = $("#bank_name").val(); //getByValue().bank_code;
            let account = $("#account").val();

            let t = getByValue(code);

            $("#bank_code").val(t);
            if (account != "" && code != "" && account > 7) {
                get_account_info(code, account);
            }

        });

        $("#account").change(function () {
            let code = $("#bank_name").val();
            let account = $("#account").val();

            if (account == "" || code == "" || account.length < 8) {
                return;
            }
            get_account_info(code, account);
        });

        function get_account_info(code, account) {
			//loading.showLoading({type: 2,tip: "Fetching ..."});

            /*$.ajax({
                url: "{{ route('account.fetch') }}",
                type: 'get',
                dataType: 'json',
                data: {
                    'bank-verification': '',
                    'code': code,
                    'account': account
                },
                success: function (response) {
					loading.hideLoading();
                    if (response.status == "error") {
                        $("#account_name").val("");
						modalMsg("Could not fetch account details. please check your account number or bank name and try again");
                        $("#reg").prop('disabled', false);
                        return;
                    }

                    $("#reg").removeAttr('disabled');
                    console.log(response.data);
                    $("#account_name").val(response.data.account_name);
					modalMsg("Account name found ["+response.data.account_name+"]" );
                },

                error: function (err) {
                    console.log(err.responseText);
					loading.hideLoading();
                }
            });*/
        }

    })(jQuery);
</script>
@endpush