@extends($activeTemplate.'layouts.home')
<?php $amountList = [20,50,100,150,200,500,1000,2000,2500,5000,7500,10000]; ?>

@push('style')
@endpush

@section('wrapper')<div class="wrapper zero-padding">@endsection

@section('header')
<div class="recharge-heading">
    <!-- top nav -->
    <div class="transparent">
        <a href="{{ route('user.home') }}">
            <iconify-icon icon="pepicons-pop:angle-left" width="20" height="20"></iconify-icon>
        </a>

        <div>
            <p>Recharge</p>
        </div>

        <a href="{{ route('user.home') }}">
            <iconify-icon icon="pepicons-pop:angle-left" width="30" height="30"></iconify-icon>
        </a>
    </div>
    <!-- end top nav -->

    <div>
        <p><sup>{{ $currency['cur_text'] }}</sup>{{ showAmount($userBalance) }}</p>
        <p>Deposit balance</p>
    </div>
</div>
@endsection

@section('content')
<div class="inner-wrapper-with-header general-wrapper">

    <div class="team-container !p-0 flex flex-col gap-y-2 !bg-transparent">

        <!-- input -->
        <div class="recharge-input">
            <p class="label">Amount</p>
            <div>
                <iconify-icon class="beautiful-text" width="25" height="25" icon="uil:atm-card"></iconify-icon>
                <input type="text" name="amount" class="amount" id="recharge-input" placeholder="Amount"/>
            </div>
        </div>

        <!-- select amount -->
        <div class="label-container">
            <p class="label">Quick Amount</p>
        </div>
        <div class="select-amount">
			@foreach($amountList as $amount )
            <div data-role="amount-tip">{{$amount}}</div>
            @endforeach
        </div>

        <!-- select bank -->
        <div class="recharge-input">
            
            <div>
                <p class="label">Pay Channel</p>
                <select name="method" id="method">
                    @foreach($gatewayCurrency as $gateway)
                    <option value="{{ $gateway->code }}" @if($gateway->code == 101) selected @endif>{{ $gateway->name }}</option>
                    @endforeach
                </select>
            </div>
        </div>

        <input type="hidden" name="recharge_currency" value="{{ $currency['cur_text'] }}">

        @csrf

        <!-- pay method -->
        <div class="label-container ">
            <button type="button" class="recharge-btn">Recharge <span id="current-value">0.00</span> <iconify-icon icon="pepicons-pop:angle-right" width="15" height="15"></iconify-icon></button>
        </div>

        <!-- summit button -->
        
    </div>

</div>
@endsection

@push('script')
<script src="{{ asset('users/assets/trade/js/recharge-amount.js') }}"></script>

<script>
    $(".recharge-btn").click(function() {

        // Form input Value
        var method = $('#method');
        var amount = $('.amount');
        var token = document.querySelector('input[name="_token"]').value;

        // Enable form submit
        var is_status = true;

        // Verify input
        if (!amount.val()) {
            modalMessage("Please enter or select amount");
            is_status = false;
        }

        if (amount < 3000 || amount > 500000) {
            modalMessage("Sorry, The amount of recharge ranges from ₦3000 - ₦500000");
            is_status = false;
        }
        // End Verify

        // Send Data
        if (is_status) {

            // AJAX POST
            $.ajax({
                type: "POST",
                url: "{{ route('user.deposit.insert') }}",
                data: {
                    amount: amount.val(),
                    method: method.val(),
                    _token: token
                },
                beforeSend: function() {
                    // Handle before sending the request
					loading.showLoading({type: 2,tip: "Loading ..."});
                },
                success: function(data) {
                    // Handle successful request
					loading.hideLoading();
                    modalMessage(data.message);
                    //window.location.href = data.link;
                    modalMessage(data.message, 200, data.link);
                },
                error: function(xhr, status, error) {
                    var responseText = JSON.parse(xhr.responseText);

                    // Handle errors
                    loading.hideLoading();
                    modalMessage(responseText.message);
                },
                fail: function() {
                    // Handle failed requests
                    loading.hideLoading();
                    modalMessage("Request Failed");
                }
            });
        }


        return false;
    })
</script>
@endpush