@extends($activeTemplate.'layouts.home')

@push('style')
  <link rel="stylesheet" href="{{ asset('users/assets/trade/css/recharge.css') }}?ver={{ time() }}" >
@endpush

@section('content')
<div class="homepage" data-v-5400101e="">
    <div class="welcomei" data-v-5400101e="">
        <div class="toplogo flex" data-v-5400101e="margin-bottom: 1.5rem;">
            <div class="bergele" data-v-5400101e="" style="margin-top: 0px;">
                <p class="julius" data-v-5400101e="">{{ greetings() }}</p>
				<span class="amuist" data-v-5400101e="">{{ config('settings')->cur_sym }}{{ showAmount($userBalance['main']) }}</span>
			</div>
			<img class="imgi" src="{{getImage(imagePath()['logoIcon']['path'] .'/logo.png')}}{{$catch}}" alt="" data-v-5400101e="" style="margin-top:-2.5rem" />
		</div>

        <div class="currenti flex" data-v-5400101e="" style="padding-top: 0px;">
            <div class="left" data-v-5400101e="">
                <p class="current" data-v-5400101e="">Current balance</p>

                <div class="waiui" data-v-5400101e="">
                    <div class="todayi" data-v-5400101e="">
						<span data-v-5400101e="">Profit:</span>
                        <p data-v-5400101e="">{{ config('settings')->cur_sym }}{{ showAmount($userBalance['income']) }}</p>
                    </div>
                </div>
            </div>

			@if( config('settings')->reward_login > 0 )
				@if($today == 0)
				<form action="" method="post" class="right flex" data-v-5400101e="">
					<img src="data:image/png;base64,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" alt="" data-v-5400101e="" />
					<button data-v-5400101e="">Check in</button>
				</form>
				@else
				<a class="right flex" data-v-5400101e="" style="position:relative;">
					<img src="data:image/png;base64,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" alt="" data-v-5400101e="" />
					<p data-v-5400101e="">Check in <iconify-icon width="10" height="10" style="position: relative;top: 15px;right: 15px;" icon="ep:d-arrow-right"></iconify-icon></p>
					<span class="circle">{{$today}}</span>
				</a>
				@endif
			@endif
        </div>
		
        <div class="recharbox flex" data-v-5400101e="" style="margin-top:10px;">

            <a onclick="recharge()" class="cmdBTN leftto" data-v-5400101e="">
				<img class="imggo" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGAAAABoCAYAAAAOy/VVAAAAAXNSR0IArs4c6QAAFGlJREFUeF7tXXmYVEWS/0W+qj5oB7nkXgSHS5BD5FZEpT9xZQBRG68WFFpAEdxxnFW/2Z3lm29cR9ZrOGzkBsHBRpRDnMHPC3A4BQRp5BKFUfEAVOTo6novY8m6uq53VHVVdbfy/lG6MiIj4pcRGZmRLx/h/FOlFqAq7f185zgPQBUPgvMAnAegii1Qxd1XXw9Yg7zcWriMGZ0YaCMkWgFozkADAuoByAWQ5bMfoRyMswycIOAYgC+kwGcEHCDCx2fPYDcG4nQV2zpu99UHgJ3Iyz6OAUIgH8CVADqD4fJLHS0mJ2ZLIh3gXQD+KSXe9tTHO+hSPQCpWgDeRO2cHNxERMMZyCcgOzHLJteaAQ8BbzNzSVkZluNGnEyOU+WpqgSAWu+jh4QYB4nbCMirvBrJc2D4POEVIeSMM9dga/KckqPMKADZ72qDBONREPeLDC3BkOJEnPDwE2yfInqm9ZLwlOc6Y3Vy5kycyonGiXONosh51zWAGE8wuFfwJ6uobiZUPNMH+Vn95qRNJD1tZsIfyq7T36m08jYM0gpA9j/QGm7XM8QYEppL4wxWJQSbWTD67xmkJ2Cl9Oq/89yAg+kCIj0AvAdXju56hAl/JJBKF2vww2fB+FOZS38a10JPtSIpByD7LbQh4V4MoAfMssVQr1Ex3Nfe5w+h/1gnzxmkJ2xl6b3Lcz0OpBKElAKQ83ZWITOKCbgglUJWF14MnCLC/WX55YtSJVNqAHgPrmw9+zkCxoN/5ht85Juupntcnt+mIiRVHoA3UTvblb2UQNfHjgq73KTm/s7Mb3kMT0FlF3GVA2ANGmZT7hpi7poql6xJfJj4Iw97BmIgvk1W7uQBWJXbLDuL3yZQ+2Q7/znQMXivp5zyMfjsl8nokxwAay5omA1jLbGd8e1CjJ3INYOeifd6oPXHwFMJe0LiAKiYr9VaS4yuTs3jdI1lBkdNoAfwkUee6Z/onJAYACrbKctT+yRxJly70fyL+P0tT87pQYlkRwkBkP3mBVMBPBizrRBtW6ebObYLtSjGZtsS1av/aZ4bT01wOtwcA5D197xCAi2MzfMrWSypbLGlutETM4NHlP/7aUeLNUcAZK+q3YY1bCfmn+UK1+loddqOiU6RgW6ewSdtty3sAXgPrqyztTcQo4dTAc63A5iwtTz3ZF+7+cAWgKzVFz5GjCcjjeqkJmvF+pdBz4THywf9+BerAWkJQPaK2q1ZE7sIXMO3lKvGJxl0lgzZ2TP0pGk9wRqAVXVWAIFiStXo8HPodaVn8A9DzRQxBSBn1YUDGOJtZxtsKarJOtpITWNNOE39E2R+2eAf45Y3TQHIWllvEwI13OjStwIlUDaJC2z0b790eoA2lw850TueseICkP1G3UEs6Q0fgYOabNx2wd7O0/vXrRr/xvOb72NOW8QFwL2i3joCBY6OpC8Mk+DfkRQ7zHpQBVhBPPDcscNHKyMFaXwDGaI8yCO8sKuO3jHJecx0cWX6sKMl8HrP0BNX2y7a3Svr9yBJW/wxxiRdtK3pBmOUNb2QyC8bdtz66EcJsrKyG+wGc5uQ8An2X37h8VxcizIzI2WtqF8KoIPf2wPM06A/C/T0DjkecfgrxgPcK+rPIaZRdoim4nfJnK/bAaBO4K6sPxSSlifbZ/mFx6wBWN7AD0CaHyae6x16fHR4N5EALKpX232B9hVxZo4LSkhHACiB3SsavEOSrkvGRuV1vrMHgCkDAOC095TRFIUnQmdRIwBwL284ghgLklEyGRoJyteHfePo9Jn7tYZdiHibms4S7au8Tq1cXPu5eQh6vWFGPMCX0xBGem/6dmFQhwgAsl6/aDWYbnSuoFUyas9FknMAfF6wvOFMkrivgrOz/svr2gHQqBTMSXiAs/4jLEH8Zvmw7wbFArCmUZ77NI5n6oi4EkAayNcLnHmAT+CXGzZy52A/gWrbw1vRorxuro0HKADSPwf4PADwePNQHwO/8b0wEvIAbVmjIRpIbT1k7JGSEwMAgOu1xo8KhuUGV7QC5fVyrAF4rXHGAFCyGeChxi3frIwAwL2s8RQCJlgt9MMJohNMs9VuAPWQTcLbcRIA4E1kZ51tvIeBS+JlE/HkTwSATOjPwFTvLV9PjAKgyTYwumVs+PuWGTJhD1Dyacsa3yqYljqV1Vs/29ID3K82ydgk7JOZsN17y9ErKgBY2CjPXUv8ACb/O1kZqukyU75e8KWjLCja2K5Xm6hjMTEry3jye+tn2QDQNDIEpVt/Yt17RtbBiG9O+7pyv9qoF9i1ya+kk0q501cl4gWJij5YpaFJAuBe1qQbDNoKIhEJTqz83gY2ACxtWgoE1wEZ0p+M3t5bv9nsB+CVJveBxEynLp2qdkwqC7LwgJKmLTD8qyNm/bmXNp0Lpnvt5PFe5Lb2AAVABhZiEXKSvM9bcHS2DwBXSfPJBPzeTpHK/C7BBUKTh8J5eF3eAxh67CdTviWNL8Lwr78z/V2t3HOzW9vJ5b356A6QqWsDJY07uDXKCfExRGeA5tnxrczvTJisF3zxqN8DSpqXgKkgdu/ZrIvEz6oRUcfy4Uf2VEboTNG6lzTrDRIbzftLXP+YMElY6h3+xfBACGqxAeA+6VTw5wVAKixFG723HenrB2DJv+0HqGK7NxX8o3iQQM3yAGgWHpASAx3w3n6krX8OeOXiY8SonxK2JkxIcA0CoGVvgNMKABOO67cdVvdeAK4lF58Go1bQdmmp6ZLo6hW5n0TgU7DHaz05QgM6VOx+Dt/jtciTgRfhRt0OsVn88D2haljc8RFF5zJ+6gWIdeH2UP+fyNFU2xU14Yz39sN5AQBaeSE5cDFG1EIsrTVdma/fccR0IaYtuXgWSSoKGU3Qf+m3f/aEmadqL188h0CjIhaSDOge5OJe8+1o15KWpZBhm3HhEKZLf0H6OV3cfgD+1spbcTNJOgNRFG9p5OuFFgC83GoWARUAAKd00tvhjn99FVfKkpaNXTrtB/Cr8N91D1sD8HLLsIVYxvTX9TuDACxudRqEWumuiYZUC44wSfl64SFzD1gcA4AScaFx12cjzczkernVH85tqfw5vKatl9sBcEkpwGmvCUfqT6f0Ow/9yu8Bi399DOC0TsIADoDhCTccabLIe8fnm02NufiSSWDcEvE7QerQh+GuIxGLulCbZ5vnuhpnrYFE3eDf9BOHumNiZN/hPF2LWy0H06+Df2OBXGKE/p0en6Bj+l2fXhQEYD8YsWloEgWfKGOFZi4d1BGFB2vGQmxR696ssqAU6h8DIuGAftengTR0UesNANK6ENOBGgYA0pqGgvkD/e5P+/k8QFvUuoQYBYm7WrwyTHwuOtUwANgJAM71j7YKE141Cg8W+EPQojZPgfGfiQPgnEInrlkewJReDwA/pd998DG/B7zUtogYs+KZ0+mrqGZQBOkNIWsWANK/GZcq/RWviOUFy9HGyINz/X9b2KaXBgoUZKxHdbJOx8D/EHA0nLvhpdUYvS9+Tq8886W2/Zhh8yY+/WCM2GdenlxwSQvkHvoSw2GYaaYtaHcriENZEzEuYcJj8donq3+QV5BeZ9kXIw9uDADQKE9DnR8yvRgjdTTxnv3m64AF7ZRXhi/EYm1CYCK6Tr977/txDTyvZQ7yPvdaAeBa2L703A2KSZwLch6Co1p6jeOnL8TDX5wNeYWY337buSu6/EX5dNdEA32QKsrbAhC2FWGyLaAuzZCf7bsCkyCTMYlY2L6UzLYiAC+Yz0CQ5tsvY/hLoFYpqo39GNgu79kbVpRXx8AXtJ9CTBOc1YSt1HRSU/XTk6oJ37PH3APmKw8IAmCmlZ8Xg8fKe/YmVVYV8y8tJd/hXDbA+IAF/V0SbwK8n2DEp6oi51eqpEMWPJ4WGtxdWEd/CBpCjKhj7fb6M3iKvGfvQ5FjfX67IRqL5A5mJblgIXU00RKAS2eBbUJQQAsGfys95W0x9tCPiXqBNv/SjUz8rtT0YhQe/CIBesLcdtdqQjwM4EbHl1UxDzZG7fW9AFMxrBZ2ztMM/TgydHutr3NVlLcFICwE2ViGGc/IUXseScCA/qbPNs9V8ThhunCCOR2uEoJfIFAnGz4e4wwaYPyeUzHRXpvX8Q0wQgdHzRmlJjkjYQPA3I4mk7BJ/4Ryw2t0wpi9akc02Ycw+9J+QohBBO7DoDYE/74Sg79XF4IzaKOUcjWKPlkfkamWdMgSp2gyESZaeMMbxqjSwUHhIgKrNqfjCFDmjqeTOppYZDEHmAJgadtVxqhS/z2liTyTILQWnUYy5OOEOPticXixup0d/KRxZM+C8ARAm9uxCKAZAMc5Sk93G6N2h+6RiJzZprSuLfJyvsrUfc6+LMgKgNmXzQI5mAOijGMAAzF691uO7T+zfVtNcymjJHsdw1bD0AvDPU+bd9ndkJiv8pswOU4bp8uaYuLB+C9oqIZibqc5xMjIK0qkjiYW7TLPgnwAOJ8DgooyoVQe+bgrJjm4aHVmx4FCI3XpYEQRxzF4gYYM/kkaXIAxpWuCtGJOp/8m4E8hucBz5OjdEeua2NxuXscemiG2mN/mYJ/yWLeo+FW9IQMLAIQCIJSGhkdN67smAj1MkEUfT7M0pDK+EOqYuP9DEIHHqfyxvKlcSmNIGAikzen8FjOrbyJAEvfA6N0fRvcVw4dmdV5HBP9rqumqiZ4bGgKw9AAxu3NkGhpumeihEy0n4bhkoy2KSk/EBWFml7ZCsDKGf+Sb5hU0WRJv8QVzSeouoBcBNDC9pojwk5TUHWN2+hOB4vYthStrDxG2GkW7+kfLEn91M7vrIMHsf1E7jY80OB/jzEOQmNU5jgckIBBjmhyzM/b2qkkQ1KzLJnIQ8yXRMBR9FHpDU8zqfBigFlZSMLCVv9zZOzgxi9ld/iLB76No1z+cAaBy9NldNpGk0HXzFYSBe519f4jamop5zzaemBX0wuB83RKArnEWYgn0D3ilRl0xakdkJW5Wl3sFMNeJ/CQwzIgAoOthgAMAmOsviUfhvp3+86VTWtcOn3htQ5CvwezLBwjJcS7rSGAEVpOmEnwDxuwMTo5EM7vuc5pqSsYwjA3zgJmXhwFgrqBKUXnMR+0szzFZbLv5x/fMy1eE7v5Pxpj287U119TQH5dHdzQOZUQzLr9aENY6UocAyRwJwIsKAFiGoCBvyeiPcTtCB7zi9Wm9wzW9W2uhYRfI98moGvkw43Uet/3moPDixa5PAcJx9U+ChmHstoo54MVujgEA5GQ59iPLey6sAVDrguLLHwNR1JVlQXXilScSGbYZoCd6XI7dFnqrkmZ0W0cIZHjRc1hoXqtIiXyTcDQAHPQAa/kZWM/jtsd/jSpgQlsAMAkuatJ9AzEnu0qsUs+RLG/F/TuWhYbMjCuOEtA4UiiaDrBvcyz6kbr+Eh7cqV7i8z2i+IrHQKgTry0DNxGg4r7vYeBrHretiZUB7AFQ1DO6tiHWtgMUurbSLg0PEyJu/5mil0zX4IGtoZhPxVeUAZQd3r/UjWaYsMO0NOp0BFFx91cB3FLBmz3y/m0Vb97EYeQMAB8IPQrP1UrVHQek3vaJXYvGc8foHv1tMknPknpi/NbQFTFU3L1M3QYQLj+nGIAwrT18/4cpAkBxnd5zKhH7ry6uIQ8TX4X7P/xnUFx6oYc6GBARgtjQU+QBPZeC+dYw03zND2xNQQgKcpx0jQsXnVlN6vJuq7nWzK8SOWBvEmRDf3bYPwPD8MCWUBZDL/RcB0a/cPmZsEp9DDTEO3z/UvLT4R6E4l7TIbmBb48zqgJNQF/1wdGwbYr1/MCWSk7C0YaY0qs2NF5LIAdfzUhN4cYvgvNoWSGyCpX0e4zf/HTob9N7PkUgh2koq+tlogE8DLbeiqiY/3gyxm+pXBoaN9IU921IhlwLsP/MTiKZZzyGaaRnwt8wfvOdoW6n9biaICIXYhb9s+BIAKb1jl0Jm9AzZH88uLUSCzGrOF/cpxkM9QkTu4NTVT5ZfM3HNjULq1gRTe+9L+5p8DiispBxALBfCTPjACZsqtxWhK3pfJ7Aa8BwEI5suaWtAZMeORKn9rqXIOY66dA3h0zYWDGHTO3jaCXMkKMwYbPty97JBNZIudWcAG0pEVfbr2ow0Ut4cMOIkOBqO7pen00g+xJkLAB9bTfjGNiC4xv7ODkoVnkAlFYqO6rveY5A1fVDbl42ZFv8dtPnFXNBz7YkXRUFGRN3YOJID5iiALAIQYSTLI3ueGiz7bcDkk0tzD13at9CMBUDuCB6XnKCtFWWWll6EC/BhA13RAj/fJ+BRLQSRL6SpEn/8wHaHaQj8B8QOKYSbQhmLgdhMCZucHwgwIleTkJlRZu/9mqj3jqLPGFgtfHghH0K6NXyW2II/uODyErf830GgoQ6XW1RlHfU/0kQFyRi/NR7QNCWKiTV8T4Coj+Cw7ayw90imc2gytN/ByF6YcK6zyJgn3ZVWxi8CEz+Dcdw2ZzVxLcAohAPrXMUdsL7Tr0HhHN/tk9rCNcz1eobBIT98J65Eo9sOxYBwiQI1L1qJJgeh8ODWVC8CE/ixPqFTiZcsyWQkxhQuTZ/7TcAjCfAqsZsVdMNGw+mi6NU0NMuCDEIE9+PdxCX8PzV/cA8CKA+IN8pueDLG98DrC422QhJq/Hw2g/sSo52hkuvB0T3/lw/pZRamqf9ZnY7xQH6Epq8GRPXb7Fvm74WmQUgqMfz/dXXtseBcRtgcU91GrcoAqKoyz8m4eG1/5s+E1tzrhoAgjKpRZzMvgmSbgNoQAaPxpeB+V0QlyBbLMP49+NWwzIBStUCEK7h/12fB1E2ANDyQbgSzJ3Ve3rOxo/tPrcOwm6A10GId+Dmd6vS6JnLgiozhBQg8F4GQZ0Bbg1wKxCaQ6KB2kgIpLdqAaUGkVoAnQHz9wCpey/+BeAwGPugcSlqndqJsdvOVEacdNFWHw9Il4bVnO95AKoYoPMAnAegii1Qxd2f94AqBuD/AYHG/dJngDQ3AAAAAElFTkSuQmCC" alt="" data-v-5400101e="" />
				<div class="goarrow" data-v-5400101e="">
					<p data-v-5400101e="">Recharge</p>
					<div class="iconto" data-v-5400101e="">
						<span data-v-5400101e="">Go to</span>
					</div>
				</div>
			</a>

            <a onclick="withdraw()" class="cmdBTN leftto" data-v-5400101e="">
				<img class="imggo" src="data:image/png;base64,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" alt="" data-v-5400101e="" />
				<div class="goarrow lastiy" data-v-5400101e="">
					<p data-v-5400101e="">Withdraw</p>
					<div class="iconto" data-v-5400101e="">
						<span data-v-5400101e="">Go to</span>
					</div>
				</div>
			</a>

        </div>
    </div>
</div>
@include($activeTemplate.'user.home.slider')

<!-- main links container -->
<div class="main-links">

    <a data-href="{{ route('user.agents') }}" class="link link2 linkBTN">
        <div>
            <!-- icon -->
            <iconify-icon width="25" height="25" icon="mynaui:users-group"></iconify-icon>
        </div>
        <p>Invite</p>
    </a>

    <a data-href="{{ route('user.games') }}" class="linkBTN link link1">
        <div>
            <!-- icon -->
            <iconify-icon width="25" height="25" icon="solar:gamepad-outline"></iconify-icon>
        </div>
        <p>Games</p>
    </a>

    <!-- nav4 -->
    <a data-href="{{ route('user.investment') }}" class="link link3 linkBTN">
        <div>
            <!-- icon -->
            <iconify-icon width="25" height="25" icon="bi:hdd-stack"></iconify-icon>
        </div>
        <p>Product</p>
    </a>

    <!-- nav3 -->
    <a data-href="{{ route('user.transaction') }}" class="link link4 linkBTN">
        <div>
            <!-- icon -->
            <iconify-icon width="25" height="25" icon="octicon:log-16"></iconify-icon>
        </div>
        <p>Records</p>
    </a>

</div>
<!-- end main links containerg -->

<!-- home pachage tabs links -->
<div class="home-package-tabs">
    <div data-href="{{ route('user.about') }}" class="linkBTN">
        <div>
            <p>About Us</p>
        </div>
        <iconify-icon width="40" height="40" icon="flat-color-icons:about"></iconify-icon>
    </div>

    <div onclick="giftCard()" class="cmdBTN">
        <div>
            <p>Gift Cards</p>
        </div>
        <iconify-icon width="40" height="40" style="color: #2196F3;" icon="nimbus:gift-card"></iconify-icon>
    </div>
</div>
<!-- end home pachage tabs links -->

@if( config('settings')->app_link )
<!-- download the app -->
<div class="download-app" data-href="{{ config('settings')->app_link }}">
    <div>
        <iconify-icon width="50" icon="openmoji:android"></iconify-icon>
        <div>
            <p>Download the App</p>
        </div>
    </div>
    <button>Download</button>
</div>
<!-- end download the app -->
@endif

@if( config('settings')->reward_login > 0 )
	@if($today == 0)
	<div class="homenew mb-1">
		<a href="{{ route('user.home') }}?claim=1">
			<img src="{{ asset('users/assets/trade') }}/img/earn-share.png" alt="">
		</a>
	</div>
	@endif
@endif

@include($activeTemplate.'user.home.blog')

@include($activeTemplate.'partials.recharge')
@include($activeTemplate.'partials.withdraw')
@include($activeTemplate.'partials.giftcard')

<div class="overfloat popView" id="noticeBoard">
    <div class="guize_html">

        <span class="guize_html_nei">
            <center style="margin-top: 10px;">
                <img width="32" height="32" src="https://img.icons8.com/pastel-glyph/64/loudspeaker--v2.png" alt="external-46-business-and-investment-outline-design-circle"/>
            </center>
            <h5 style="margin-bottom: 20px;"><br>Notification</h5>

            {!! config('settings')->home_message !!}


        </span>
        <a href="{{ config('settings')->telegram_url }}" class="social-channel telegram-bg text-white">
            Join our Official Telegram Group
        </a>
        <a href="{{ config('settings')->whatsapp_url }}" class="social-channel whatsapp-bg text-white">
            Join our Official WhatsApp Group
        </a>

        <div class="btnyu g_close">
            Ok
        </div>
    </div>
</div>
@endsection

@push('script')
<script type="text/javascript">
	var lastUpdate = "{{ strtotime(config('settings')->updated_at); }}";
	var lastView = localStorage.getItem('noticeDate');

	if( lastUpdate != lastView ){
        $("#noticeBoard").show();
		localStorage.setItem('noticeDate', lastUpdate);
	}

    const swiper = new Swiper('.swiper', {
        // Optional parameters
        direction: 'horizontal',
        loop: true,
        speed: 2000,
        autoplay: {
            delay: 1000,
        },
    });
</script>
@endpush