@extends($activeTemplate.'layouts.home')

@push('style')
<style>
    .fileinput .thumbnail {
        max-height: 300px;
        width: 100%;
    }
</style>
@endpush


@section('content')
@include($activeTemplate. 'layouts.home_navprev')
<div class="inner-wrapper-with-header">

    <div class="team-container !p-0 flex flex-col gap-y-2 !bg-transparent">

        <!-- withdraw details section -->
        <div class="withdraw-details">

            <!-- detail -->
            <div>
                <div>TRC20 Address</div>
                <div>
                    <span id="account_number">{{ $user->wallet->wallet_address }}</span> 
                    <button class="btn btn-sm btn-primary btn-copy-account" data-clipboard-target="#account_number">Copy </button>
                </div>
            </div>

            <!-- detail -->
            <div>
                <div>Amount to Pay</div>
                <div>
                    {{ Session::get('currency_sym') }}<span id="final_amount">{{ number_format($usdt_amount,2,".","") }}</span> 
                    <button class="btn btn-sm btn-primary btn-copy-amount" data-clipboard-target="#final_amount">Copy </button>
                </div>
            </div>

        </div>
        <!-- input -->
      <div class="recharge-input">
            <p>Payment Guide</p>
        </div>

        <!-- input -->
        <div class="withdraw-details">
            Send USDT TRC20(Tron Network) to the address provided, your payment will be confirmed automatically
        </div>

        <!-- summit button -->
        <button class="bg-primary text-white rounded-md py-3" onclick="location.href='{{ route('user.deposit.history') }}';">I've made a payment</span></button>
        
    </div>
</div>
@endsection

@push('script')
    <script>

        (function ($) {

            "use strict";

            $('.withdraw-thumbnail').hide();

            $('.clickBtn').on('click', function () {

                var classNmae = $('.fileinput').attr('class');

                if (classNmae != 'fileinput fileinput-exists') {
                    $('.withdraw-thumbnail').hide();
                } else {

                    $('.fileinput-preview img').css({"width": "100%", "height": "300px", "object-fit": "contain"});

                    $('.withdraw-thumbnail').show();

                }

            });

        })(jQuery);

    </script>

    <script type="text/javascript">


        $(document).ready(function () {

            $(".btn-copy-amount").on("click", function () {
                copy_value("final_amount", "Amount copied ");
            });

            $(".btn-copy-account").on("click", function () {
                copy_value("account_number", " Account copied ");
            });


            $(".btn-copy-narration").on("click", function () {
                copy_value("narration", "Narration copied ");
            });

            function copy_value(id, text) {
                var copyText = document.getElementById(id);
                var textArea = document.createElement("textarea");
                textArea.value = copyText.textContent;
                document.body.appendChild(textArea);
                textArea.select();
                document.execCommand("Copy");
                textArea.remove();

                //notify("", text + ": " + copyText.textContent);

                iziToast.success({message: text + ": " + copyText.textContent, position: "topRight"});
            }


        });
    </script>

@endpush
