@extends($activeTemplate.'layouts.app')

@push('style')
<style type="text/css">

    .txt-green {
        background-color: #51BE7A;
        color: #fff;
        padding: 5px 8px;
        border-radius: 4px;
    }

    .txt-red {
        background-color: #F34954;
        color: #fff;
        padding: 5px 8px;
        border-radius: 4px;

    }

    .transaction-list li {
        background: #304256;
        color: #fff !important;
        box-shadow: 0 1px 3px 0 #304256;
        border-radius: 10px;
        padding: 16px 10px;
        margin-bottom: 10px;
        align-items: center;
        justify-content: space-between;


    }

    .d-flex {
        padding: 0 3px 0 0;
    }

    .list-unstyled h5 {
        color: #fff;
        text-align: right;
    }

    .list-unstyled p {
        font-size: 12px;
        color: #fff !important;
        margin-bottom: 0;
    }

    small {
        color: #fff;
    }

    #tit span.select {
        border-radius: 0;
        color: #fff;

        height: 36px;
        line-height: 36px;
        border-radius: 5px;
    }

    #tit span {
        width: 50% !important;
        display: inline-block !important;
    }

    #tit {
        border-radius: 5px;
    }

    .dropload-down {
        width: 100%;
        padding-top: 50px;
        margin: 0 auto;
        line-height: 1.6em;
        font-size: 14px;
        text-align: center;
        color: #fff;


    }

    .progress-container {
        display: inline-block;
        width: 180px;
        height: 20px;
        position: relative;
        margin-top: 10px;
        background: #6a737b;
        border-radius: 5px;
        color: #fff;
    }

    .progress-container .progress-bar {
        display: inline-block;
        height: 100%;
        width: 0;
        background-color: #279b37;
        border-radius: 5px;
    }

    .progress-container .progress-text-left,
    .progress-container .progress-text-right {
        position: absolute;
        top: 50%;
        font-size: 13px;
        font-weight: 500;
        color: #fff;
    }

    .progress-container .progress-text-left {
        left: 5px;
        transform: translateY(-50%);
    }

    .progress-container .progress-text-right {
        right: 5px;
        transform: translateY(-50%);
    }

    .progress-container .eligible {
        background-color: #0abf53;
    }



</style>
@endpush


@section('container') <div id="appCapsule" class="pb-2"> @endsection
@section('content')
@include($activeTemplate. 'layouts.app_navprev')

<div class="weui_container_cn ">
    <img src="{{ asset('users/assets/app') }}/img/slider/1.jpg" class="img-fluid bg-img" height="250px" alt="">
</div>
<div class="appContent pb-0 mt-1">
    <div id="wrap" class="mt-1">
        <p class="text-muted">*Salary for life: cumulatively invite 50 and earn N5000 forever</p>
        <p class="text-muted">*Payout should be in current level you're. System should issue your next payout on <b>{{ $nextSunday->format('l, F j, Y \a\t h:i A') }}</b></p>

        <div id="tit">
            <span class="select">Schedule [Team {{ $referrals }}]</span>
            <span onclick="location.href='{{ route('user.transaction.type', ['type' => 'salary']) }}';">Transaction</span>
        </div>

        <ul class="transaction-list list-unstyled pt-2">

            @php
                $levelNumber = 0;
                $currentLevel = 0;
            @endphp
            @foreach($rewards as $key => $reward)

            @php
                $status = '';
                $activeNumber = 0;

                if ($referrals >= $reward->number) {
                    $activeNumber = $reward->number;
                    $levelNumber = $reward->number;
                    $currentLevel = $reward->id;
                }

                if($activeNumber >= $reward->number) {
                    $status = "<span class='text text-primary'>Eligible</span>";
                }else{
                    $status = '<span class="text text-warning">Not yet eligible</span>';
                }

                // Last loop
                if(!$loop->first) {
                    /*$status = $rewards[$key - 1];*/
                    $levelNumber = $referrals - $rewards[$key - 1]->number;
                    $activeNumber = max(0, $levelNumber);
                    $levelNumber = $activeNumber;
                    $referrals = $levelNumber;
                    $activeNumber = ($activeNumber >= $reward->number) ? $reward->number : $activeNumber - $reward->number;
                    $activeNumber = max(0, $activeNumber);
                }
            @endphp
            <li>
                <div class="d-flex align-items-center justify-content-between">
                    <div class="d-flex align-items-center">
                        <div class="ml-10">

                            <h4 class="coin-name">{{ $reward->summary }}</h4>
                            <small class="text-muted">{!! $status !!}</small></br>
                            
                            <span class="progress-container" data-completed-items="{{ $levelNumber }}" data-total-items="{{ $reward->number }}">
                                <span class="progress-bar"></span>
                                <span class="progress-text-left"></span>
                                <span class="progress-text-right"></span>
                            </span>

                        </div>
                    </div>
                    <div class="d-flex align-items-center">
                        <div class="ml-10">
                            <h4 class="coin-name">{{ Session::get('currency_sym') }}{{ amount_format($reward->amount) }}</h4>
                        </div>
                    </div>
                </div>
            </li>
            @endforeach
        </ul>

        <p class="text-warning">*It’s forbidden to open false accounts once found all accounts involved will be permanently banned.</p>
    </div>
    <div class="dropload-down">
        <div class="dropload-noData"></div>
    </div>
</div>
@endsection

@push('script')
<script>

$(document).ready(function() {
    $('.progress-container').each(function() {
    var container = $(this);
    var progressBar = container.find('.progress-bar');
    var progressTextLeft = container.find('.progress-text-left');
    var progressTextRight = container.find('.progress-text-right');
    var completedItems = container.data('completed-items');
    var totalItems = container.data('total-items');

    if(completedItems >= totalItems) {
        completedItems = totalItems;
        totalItems = totalItems;
    }

    var progress = (completedItems / totalItems) * 100;
    progressBar.css('width', progress + '%');

    if (completedItems === totalItems) {
        progressBar.addClass('eligible');
        progressTextLeft.text('100%');
        progressTextRight.text(completedItems + '/' + totalItems);
    } else {
        progressBar.removeClass('eligible');
        progressTextLeft.text(progress.toFixed(0) + '%');
        progressTextRight.text(completedItems + '/' + totalItems);
    }
    });
});

</script>
@endpush