@extends($activeTemplate.'layouts.home')

@push('style')
	<link rel="stylesheet" href="{{ asset('users/assets/trade/css/team.css') }}" >
@endpush

@section('wrapper')<div class="wrapper uesYhs">@endsection

@section('content')

@php
$link = route('invite', ['code' => auth()->user()->ref_code]);
$code = auth()->user()->ref_code;
@endphp

<div data-v-af01384a="" class="" style="">
	<div id="home" data-v-c35495fc="" data-v-af01384a="" style="background:#FFF;">
		<div class="bg" data-v-c35495fc="" style="height:18vmin"></div>
		<div class="main" data-v-c35495fc="">
			<div class="titleBar" data-v-c35495fc="">
				<div class="left" data-v-c35495fc="">
					<a data-href="{{ route('user.home')}}" data-v-c35495fc="" class="linkBTN text-white">←</a>
				</div>
				<div class="right" data-v-c35495fc="">
					<a data-href="{{ route('user.logout')}}" class="linkBTN right" data-v-c35495fc="" style="background: #e0e0e0;border-radius: 50%;"><img src="{{ asset('users/assets/trade/img/logout.png') }}" alt="" data-v-c35495fc=""></a>
				</div>
			</div>
			<div data-v-af01384a="">
				<div id="team" data-v-c6f9d966="" data-v-af01384a="" class="">
					<div class="containerh" data-v-c6f9d966="">
						<div class="part2" data-v-385ac480="" data-v-c6f9d966="">
							<div class="top_lv_VIEw" data-v-385ac480=""><i class="left_icon" data-v-385ac480=""></i><span data-v-385ac480="">My Team</span></div>
						</div>
					</div>
				</div>
			</div>

			<!-- balance -->
			<div class="team-summary">
				<div>
					<p><span><iconify-icon icon="heroicons-solid:cube"></iconify-icon></span>Team Invested</p>
					<p>{{ config('settings')->cur_sym }}{{ showAmount($totalInvest) }}</p>
				</div>
				<div>
					<p><span><iconify-icon icon="streamline:graph-arrow-increase"></iconify-icon></span>Team Count</p>
					<p>{{ $totalTeamMember }}</p>
				</div>
			</div>

			<div class="invitation-link">
				<p>Invitation Link</p>
				<div>
					<a href="{{ $link }}">{{ $link }}</a>
					<button onclick="copyText('{{ $link }}');"><span><iconify-icon icon="mingcute:copy-fill"></iconify-icon>&nbsp;&nbsp;COPY</span></button>
				</div>
			</div>

			<!-- tabs -->
			<div class="team-tabs" style="border-radius: 10px">
				<button @if($lev_id == 1) class="active" style="border-radius: 10px 0 0 10px" @endif onclick="location.href='{{ route('user.agents', ['id' => 1]) }}';">Level 1</button>
				<button @if($lev_id == 2) class="active" style="border-radius: 0px" @endif onclick="location.href='{{ route('user.agents', ['id' => 2]) }}';">Level 2</button>
				<button @if($lev_id == 3) class="active" style="border-radius: 0 10px 10px 0" @endif onclick="location.href='{{ route('user.agents', ['id' => 3]) }}';">Level 3</button>
			</div>

			<!-- summary -->
			<div class="other-summary">
				<div>
					<p>{{ $ActiveMemberstotal }}</p>
					<p>Total valid</p>
				</div>

				<div>
					<p>{{ config('settings')->cur_sym }}{{ showAmount($totalCommission) }}</p>
					<p>Total income</p>
				</div>

				<div>
					@foreach($levels as $level)
					@if($level->level == $lev_id) <p>{{ $level->percent }}%</p>@endif
					@endforeach
					<p>Total profit</p>
				</div>
			</div>

			<table class="team-members">
				<thead>
					<tr><th>Phone number</th> <th>Invitation</th> <th>Assets</th></tr>
				</thead>
				<tbody>
					@php
						$lastUsers = collect($levelUsers)->reverse()->take(10)->reverse();
					@endphp

					@foreach($lastUsers as $user)
						@php
							$team_size = DB::table('users')->where('ref_by', $user->id)->count();
							$total_assets = DB::table('investments')->where('user_id', $user->id)->sum('amount');
						@endphp    
						<tr><td>{{ substr_replace($user->mobile, str_repeat("*", 3), 3, 3) }}</td> <td>{{ $team_size }}</td> <td>{{ config('settings')->cur_sym }}{{ showAmount($total_assets) }}</td></tr>
					@endforeach
				</tbody>
			</table>
		</div>
	</div>
</div>
@endsection

@push('script')
<script>
    function copyText(textToCopy) {
		var $temp = $("<input>");
		$("body").append($temp);
		$temp.val(textToCopy).select();
		document.execCommand("copy");
		$temp.remove();
		modalMsg("Copied!");
    }
</script>
@endpush