@extends($activeTemplate.'layouts.home')

@push('style')
@endpush


@section('content')
@include($activeTemplate. 'layouts.home_navprev')
<div class="inner-wrapper-with-header">

<div class="team-container transaction-detail">

    <!-- details -->
    <div class="flex flex-col gap-y-3">

        @foreach($withdraws as $transaction)
        <!-- Recharge detail -->
        <div class="recharge-detail">

            <!-- heading -->
            <div class="heading">
                <iconify-icon icon="noto:spiral-notepad"></iconify-icon>
                <p>{{ $transaction->trx }}</p>
            </div>

            <!-- title -->
            <div class="title">Withdraw</div>

            <!-- description -->
            <div class="description">
                <div>
                    <p>Amount</p>
                    <p>{{ Session::get('currency_sym') }}{{ amount_format($transaction->amount) }}</p> 
                </div>

                <div>
                    <p>Order time</p>
                    <p>{{ diffForHumans($transaction->created_at) }}</p> 
                </div>
            </div>

            <div class="footer">
                <p>Status</p>
                @if($transaction->status == 1)
                    <p class="text text-success">@lang('Approved')</p>
                @elseif($transaction->status == 2)
                    <p class="text text-secondary">@lang('Pending')</p>
                @elseif($transaction->status == 3)
                    <p class="text text-secondary">@lang('Rejected')</p>
                @endif
            </div>
        </div>
        @endforeach
    </div>
    <!-- end details -->
    
</div>

</div>
@endsection

@push('script')
@endpush
