<!doctype html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <title>{{ $pageTitle }} - {{ config('settings')->sitename }}</title>
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta content="width=device-width,initial-scale=1,maximum-scale=1,user-scalable=0,viewport-fit=cover"
        name="viewport" />
    <meta http-equiv="X-UA-Compatible" content="ie=edge">

    <link href="{{ asset('users/css/master.css') }}{{$catch}}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('users/css/layout.css') }}{{$catch}}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('users/fonts/iconfont.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('users/css/forms.css') }}{{$catch}}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('users/css/animation.css') }}{{$catch}}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('users/css/actciles.css') }}{{$catch}}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('users/css/swiper.min.css') }}{{$catch}}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('users/css/tagNav.css') }}{{$catch}}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('users/css/footer-nav.css') }}{{$catch}}" rel="stylesheet" type="text/css" />

    <link href="{{ asset('users/css/inputPlate.css') }}{{$catch}}" rel="stylesheet" type="text/css" />
    @stack('style-lib')
</head>

<body class="homePage invitePage taskhallPage accountPage depositPage withdrawPage resetPasswordPage">
	<div class="app h5MaxWidth">
		@yield('content')


        <footer class="footer h5MaxWidth" id="footer">
            <div class="footer-nav">
                <div>
                    <ul class="display alignCenter">

                        <li class="flex1 homeNav active">
                            <div onclick="jumpLink( '{{ route('user.home') }}',1)">
                                <div class="icon display alignCenter justifyCenter">
                                    <i class="iconfont icon-trend-up"></i>
                                </div>
                                <p>Home</p>
                            </div>
                        </li>
                        <li class="flex1 homeNav">
                            <div onclick="jumpLink( '{{ route('user.investment.log') }}',1)">
                                <div class="icon display alignCenter justifyCenter">
                                    <i class="iconfont icon-medal"></i>
                                </div>
                                <p>Order</p>
                            </div>
                        </li>
                        <li class="flex1 inviteNav">
                            <div onclick="jumpLink( '{{ route('user.referrals') }}',1)">
                                <div class="icon display alignCenter justifyCenter">
                                    <i class="iconfont icon-ticket"></i>
                                </div>
                                <p>Team</p>
                            </div>
                        </li>
                        <li class="flex1 homeNav">
                            <div onclick="jumpLink( '{{ route('user.profile.setting') }}',1)">
                                <div class="icon display alignCenter justifyCenter">
                                    <i class="iconfont icon-money-safe"></i>
                                </div>
                                <p>Account</p>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </footer>
	</div>

	<script src="{{ asset('users/js/jquery-2.1.1.js') }}{{$catch}}" type="text/javascript"></script>
	<script src="{{ asset('users/js/common.js') }}{{$catch}}" type="text/javascript"></script>
	<script src="{{ asset('users/js/modal.js') }}{{$catch}}" type="text/javascript"></script>

	@stack('script-lib')

	@stack('script')

	@include('partials.plugins')

	@include('partials.notify')

		<a href="" target="_blank" style="display:none;"><span id="jump"></span></a>
	</body>
</html>
