@php $loginContent = getContent(config('settings')->active_template, 'login.content', true); @endphp

@extends($activeTemplate.'layouts.auth')

@push('seo-lib')
	<?php $pageTitle = @$loginContent->data_values->title; ?>
	<title>{{ config('settings')->sitename }} - {{$pageTitle}}</title>
	<link rel="shortcut icon" href="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}" type="image/x-icon">
	<meta name="keywords" content="{!! @$loginContent->data_values->keyword !!}">

	<meta name="description" content="{!! @$loginContent->data_values->description !!}">
	<meta itemprop="name" content="{{$pageTitle}}">
	<meta itemprop="description" content="{!! @$loginContent->data_values->description !!}">
	<meta itemprop="image" content="{{ asset( 'assets/images/frontend/login/' .@$loginContent->data_values->seo_image) }}">

	<meta property="og:title" content="{{$pageTitle}}">
	<meta property="og:description" content="{!! @$loginContent->data_values->description !!}">
	<meta property="og:image" content="{{ asset( 'assets/images/frontend/login/' .@$loginContent->data_values->seo_image) }}"/>

	<meta name="apple-mobile-web-app-title" content="{{ $pageTitle }}">
@endpush


@section('content')
<div class="motif h5MaxWidth">
	<img src="{{ asset( 'assets/images/frontend/login/' .@$loginContent->data_values->backgroud) }}{{$catch}}" alt="" style="opacity: 0.3;" />
</div>
<div class="loginBox h5MaxWidth display alignCenter">

	<div class="login forms">
		<div class="topArea">
			<div class="logo"><img src="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}" alt /></div>
			<div class="greetings">{{ @$loginContent->data_values->title }}</div>
			<div class="greetings">{{ @$loginContent->data_values->caption }}</div>
		</div>
		<form id="login" action="" method="post" onsubmit >
			@csrf
			<ul>
				<li class="areaCode">
					<div class="inputArea display alignCenter">
						<div class="trueInpt display alignCenter flex1">
							<p id="areaCode"></p>
							<input type="text" name="username" id="mobile"
								class="mobile fillArea flex1" placeholder="Mobile number" maxlength="11"
								size="11" />
						</div>
					</div>
				</li>
				<li>
					<div class="inputArea display alignCenter">
						<div class="trueInpt display alignCenter flex1">
							<input type="password" name="password" id="login_password"
								placeholder="Login password" class="password fillArea eyeClose flex1" />
							<div id="eye" class="eye secret rightSideBox display alignCenter">
								<i class="r iconfont icon-eye"></i>
								<i class="s iconfont icon-eye-slash"></i>
							</div>
						</div>
					</div>
				</li>
			</ul>
			<div class="actionBar display alignCenter justifyDetween">

				<div class="goSignup" onclick="jumpLink('{{ route('user.register')}}')">SIGN UP</div>

				<button type="button" style="background: transparent; border:none;">
					<div class="loginBtn clickBtn radius50P display alignCenter justifyCenter"
						onclick="login()">
						<i class="iconfont icon-arrow-right-3"></i>
					</div>
				</button>
			</div>
			<div class="fPassword"><a href="{{ route('user.password.request') }}">I forgot my
					password</a></div>
		</form>
	</div>
</div><!-- justifyAround -->
@endsection


@push('script')
    <script type="text/javascript">
        $(document).ready(function() {
            $('#login_password').togglePassword({
                el: '#eye'
            });
        })

        function login() {
            var account = $('#mobile').val();
            var passWord = $('#login_password').val();

            if (account === "") {
                toast('', 'Mobile phone can not be empty.', 'login', 2000, 1);
                $('#mobile').focus();
                return false;
            }

            if (passWord === "") {
                toast('', 'Password can not be empty.', 'login', 2000, 1);
                $('#login_password').focus();
                return false;
            }

            toast("", "LOADING...", "loading", 10000, 4);
			
			$( "#login" ).trigger( "submit" );

        }

        $("body").keyup(function(event) {
            if (event.keyCode == 13) {
                login();
            }
        });
    </script>
@endpush
