@php $loginContent = getContent(config('settings')->active_template, 'register.content', true); @endphp

@extends($activeTemplate.'layouts.auth')

@push('seo-lib')
	<?php $pageTitle = @$loginContent->data_values->title; ?>
	<title>{{ config('settings')->sitename }} - {{$pageTitle}}</title>
	<link rel="shortcut icon" href="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}" type="image/x-icon">
	<meta name="keywords" content="{!! @$loginContent->data_values->keyword !!}">

	<meta name="description" content="{!! @$loginContent->data_values->description !!}">
	<meta itemprop="name" content="{{$pageTitle}}">
	<meta itemprop="description" content="{!! @$loginContent->data_values->description !!}">
	<meta itemprop="image" content="{{ asset( 'assets/images/frontend/register/' .@$loginContent->data_values->seo_image) }}">

	<meta property="og:title" content="{{$pageTitle}}">
	<meta property="og:description" content="{!! @$loginContent->data_values->description !!}">
	<meta property="og:image" content="{{ asset( 'assets/images/frontend/register/' .@$loginContent->data_values->seo_image) }}"/>

	<meta name="apple-mobile-web-app-title" content="{{ $pageTitle }}">
@endpush


@section('content')
<div class="motif h5MaxWidth">
	<img src="{{ asset( 'assets/images/frontend/register/' .@$loginContent->data_values->backgroud) }}{{$catch}}" alt="" style="opacity: 0.3;" />
</div>

<div class="signupBox h5MaxWidth display alignCenter">
	<div class="signup forms">
		<div class="topArea">
			<div class="logo"><img src="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}" alt /></div>
			<div class="greetings">{{ @$loginContent->data_values->title }}</div>
			<div class="greetings">{{ @$loginContent->data_values->caption }}</div>
		</div>
		<form id="signup" action="{{ route('user.register')}}" method="post" onsubmit="" >
			@csrf
			<ul>
				<li class="areaCode">
					<div class="inputArea display alignCenter">
						<div class="trueInpt display alignCenter flex1">
							<p id="areaCode"></p>
							<input type="number" name="mobile" id="mobile"
								class="mobile fillArea flex1" placeholder="Mobile number" maxlength="11"
								size="11" />
						</div>
					</div>
				</li>
				<li>
					<div class="inputArea display alignCenter">
						<div class="trueInpt display alignCenter flex1">
							<input type="password" name="password" id="login_password"
								placeholder="Login password" class="password fillArea eyeClose flex1" />
							<div id="eye" class="eye secret rightSideBox display alignCenter">
								<i class="r iconfont icon-eye"></i>
								<i class="s iconfont icon-eye-slash"></i>
							</div>
						</div>
					</div>
				</li>
				<li id="invitationCodeBox">
					<div class="inputArea display alignCenter">
						<div class="trueInpt display alignCenter flex1">
							<input type="text" name="referBy" value="{{ session()->get('reference') }}"
								id="invitationCode" class="invitationCode fillArea flex1"
								placeholder="Invitation code" maxlength="5" size="5" />
						</div>
					</div>
				</li>
				<input name="password_confirmation" id="passConfirm" type="hidden" />
				{{--  <li>
					<div class="inputArea display alignCenter">
						<div class="trueInpt display alignCenter flex1">
							<input type="text" name="verificationCode " id="verificationCode"
								class="checkCode fillArea flex1" placeholder="Verification code (OTP)"
								maxlength="5" size="5" />
							<div id="getCode" class="getCode rightSideBox display alignCenter"
								onclick="getCode()">
								<p>Send</p>
							</div>
						</div>
					</div>
				</li>  --}}
			</ul>

			<div class="actionBar display alignCenter justifyDetween">
				<div class="goLogin" onclick="jumpLink('{{ route('user.login')}}')">SIGN
					IN</div>
				<button type="button" style="background: transparent; border:none;">
					<div class="signInBtn radius50P display alignCenter justifyCenter" onclick="register()">
						<i class="iconfont icon-arrow-right-3"></i>
					</div>
				</button>
			</div>
		</form>
	</div>
</div>
@endsection

@push('script')
    <script type="text/javascript">
        $(document).ready(function() {
            var invitation_code = GetQueryString("invitationCode");

            if (invitation_code == null) {
                invitation_code = localStorage.getItem("invitation_code");
            }

            if (invitation_code != null && invitation_code.length >= 5) {
                localStorage.setItem("invitation_code", invitation_code);
                $("#invitationCode").val(invitation_code);
                $("#invitationCode").prop("readonly", true);
            }

            $('#login_password').togglePassword({
                el: '#eye'
            });
        })

        function register() {
            var mobile = $('#mobile').val();
            var passWord = $('#login_password').val();
            var invitationCode = $('#invitationCode').val();
			//var verificationCode = $('#verificationCode').val();


            if (mobile == "" || mobile.length < 10 ) {
                toast('', mobile + ' Not a valid phone number.', 'mobile', 2000, 1);
                $('#mobile').focus();
                return false;
            }

            if (passWord == "") {
                toast('', 'password can not be empty.', 'password', 2000, 1);
                $('#login_password').focus();
                return false;
            }
			$('#passConfirm').val(passWord);

            if (invitationCode == "") {
                toast('', 'Please enter the invitation code.', 'invitationCode', 2000, 1);
                $('#invitationCode').focus();
                return false;
            }

            toast("", "LOADING...", "loading", 10000, 4);
        }
    </script>
@endpush

