@extends($activeTemplate.'layouts.users')

@section('content')

<header>
	<div class="header h5MaxWidth clear display alignCenter">
		<div class="back iconfont icon-arrow-left" onclick="history.go(-1)">
		</div>
		<h2 class="flex1">Add BankCard</h2>
	</div>
</header>

<div style="padding-top:30px;">
	<div style="float: left; width: 100%; text-align: center; color: #fff;">
		<div style="height: 100px; line-height: 100px; margin:0 auto; width:100px; border-radius: 100px; background:#fff;">
			<img src="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}" style="height: auto; border-radius: 100px;width: 100%;padding: 20px;">
		</div>
		<div style="padding:5px; padding-top:10px;color:#000; font-weight:bold; font-size:20px; margin-top:10px;" id="uid">Modify Password</div>
		<div style="padding:5px; padding-top:5px;color:#000; font-size:12px;">Update account login password here</div>
	</div>
</div>

@if (auth()->user()->bankAccount)

<div class="main">
	<div class="addbankcard forms ">
		<form>
			<ul>
				<li>
					<div class="inputArea radius7PX display alignCenter">
						<div class="leftSideBox display alignCenter">
							<i class="i_inputIcon iconfont icon-bank1"></i>
						</div>
						<div class="trueInpt display alignCenter flex1">
							<input type="text" class="cardNo fillArea flex1"
								placeholder="Bank"  value="{{ auth()->user()->bankAccount->bank_name }}" readonly/>
						</div>
					</div>
				</li>

				<li>
					<div class="inputArea radius7PX display alignCenter">
						<div class="leftSideBox display alignCenter">
							<i class="i_inputIcon iconfont icon-card-add"></i>
						</div>
						<div class="trueInpt display alignCenter flex1">
							<input type="number" class="cardNo fillArea flex1"
								placeholder="Bank Account No." maxlength="30" size="30" value="{{ auth()->user()->bankAccount->account_number }}" readonly/>
						</div>
					</div>
				</li>
				<li>
					<span style="color: red;" class="text-danger text-error block"></span>
					<div class="inputArea radius7PX display alignCenter">
						<div class="leftSideBox display alignCenter">
							<i class="i_inputIcon iconfont icon-user"></i>
						</div>
						<div class="trueInpt display alignCenter flex1">
							<input type="text" class="userName fillArea flex1"
								placeholder="Card Holder" maxlength="40" size="40" required readonly value="{{ auth()->user()->bankAccount->account_name }}"/>
						</div>
					</div>
				</li>
			</ul>
		</form>
	</div>
</div>
@else
	<div class="main">
		<div class="addbankcard forms ">
			<form action="" method="post">
				@csrf
				<ul>
					<li id="bankCodeArea">
						<div class="inputArea radius7PX display alignCenter">
							<div class="leftSideBox display alignCenter">
								<i class="i_inputIcon iconfont icon-bank1"></i>
							</div>
							<div class="trueInpt display alignCenter flex1">
								<select class="bank fillArea flex1" name="bank_code" id="bank_name"
									style="line-height: 18px;">
									<option>Choose Bank</option>
									@foreach ($banks as $bank)
										<option value="{{ $bank['bank_code'] }}">{{ $bank['name'] }}</option>
									@endforeach
								</select>
							</div>
						</div>
					</li>
					<li style="display: none;">
						<div class="inputArea radius7PX display alignCenter">
							<div class="leftSideBox display alignCenter">
								<i class="i_inputIcon iconfont icon-bank1"></i>
							</div>
							<div class="trueInpt display alignCenter flex1">
								<input type="text" name="cardBankName" id="cardBankName"
									class="userName fillArea flex1" placeholder="Bank IFSC" maxlength="40"
									size="40"/>
							</div>
						</div>
					</li>

					<li>
						<div class="inputArea radius7PX display alignCenter">
							<div class="leftSideBox display alignCenter">
								<i class="i_inputIcon iconfont icon-card-add"></i>
							</div>
							<div class="trueInpt display alignCenter flex1">
								<input type="number" name="account_number" id="account"
									class="cardNo fillArea flex1" placeholder="Bank Account No." maxlength="30"
									size="30" />
							</div>
						</div>
					</li>
					<input type="hidden" name="bank_name" id="bank_code">
					<li>
						<span style="color: red;" class="text-danger text-error block"></span>
						<div class="inputArea radius7PX display alignCenter">
							<div class="leftSideBox display alignCenter">
								<i class="i_inputIcon iconfont icon-user"></i>
							</div>
							<div class="trueInpt display alignCenter flex1">
								<input type="text" name="account_name" id="account_name"
									class="userName fillArea flex1" placeholder="Card Holder" maxlength="40"
									size="40" required readonly />
							</div>
						</div>
					</li>
				</ul>
				<div class="actionBar display alignCenter alignStretch justifyEnd">

					<button id="reg" disabled type="submit"
						class="submitBinding clickBtn display alignCenter justifyCenter">
						<p><i class="iconfont icon-arrow-right-3"></i></p>
					</button>

				</div>
			</form>
		</div>
	</div>
@endif

@endsection

@push('script-lib')
    <textarea style="display: none;" id="all_banks">{!! $all_banks !!}</textarea>

    <script>
        let all_banks = JSON.parse($("#all_banks").val());
        //console.info(all_banks);
        (function($) {
            "use strict";

            function getByValue(value) {

                let arr = all_banks;
                for (var i = 0, iLen = arr.length; i < iLen; i++) {
                    //console.log(arr[i]);
                    if (arr[i].bank_code == value) return arr[i].name;
                }
            }


            $("#bank_name").change(function(e) {
                let code = $("#bank_name").val(); //getByValue().bank_code;
                let account = $("#account").val();

                let t = getByValue(code);

                $("#bank_code").val(t);
				if (account != "" && code != "" && account == 10) {
					get_account_info(code, account);
				}
            });

            $("#account").change(function() {
                let code = $("#bank_name").val(); // getByValue($("#bank_name").val()).bank_code;
                let account = $("#account").val();

				if (account == "" || code == "" || account.length < 10) {
                    $("#reg").prop('disabled', true);
                    $("#account_name").val("");
                    $(".text-error").text("Your bank name and account number are required, please try again");
                    return;
                }

                get_account_info(code, account);
            });

            function get_account_info(code, account) {

                $(".preloaders").show();
                $(".text-error").text("Fetching account details");

                $.ajax({
                    url: "{{ route('account.fetch') }}",
                    type: 'get',
                    dataType: 'json',
                    data: {
                        'bank-verification': '',
                        'code': code,
                        'account': account
                    },
                    success: function(response) {
                        if (response.status == "error") {
                            $("#account_name").val("");
                            $(".preloaders").hide();
                            $(".text-error").text(
                                "Could not resolve account name, please check your account number or bank name and try again"
                            );
                            $("#reg").prop('disabled', true);
                            return;
                        }

                        $(".text-error").text("");
                        $("#reg").removeAttr('disabled');
                        $(".preloaders").hide();
                        console.log(response.data);
                        $("#account_name").val(response.data.account_name);
                    },

                    error: function(err) {
                        console.log(err.responseText);
                        $(".preloaders").hide();
                    }
                });
            }

            $('.withdraw-thumbnail').hide();
            $('.clickBtn').on('click', function() {
                var classNmae = $('.fileinput').attr('class');
                if (classNmae != 'fileinput fileinput-exists') {
                    $('.withdraw-thumbnail').hide();
                } else {
                    $('.fileinput-preview img').css({
                        "width": "100%",
                        "height": "300px",
                        "object-fit": "contain"
                    });

                    $('.withdraw-thumbnail').show();
                }

            });

        })(jQuery);
    </script>
@endpush
