@extends($activeTemplate.'layouts.users')

@push('style-lib')
    <link href="{{ asset('users/css/account.css') }}" rel="stylesheet" type="text/css" />
@endpush


@section('content')
<header class="isScrollTo noColor">
	<div class="header h5MaxWidth clear display alignCenter">
		<a class="back iconfont icon-arrow-left-2" onclick="window.history.go(-1); return false;"></a>
		<h2 class="flex1">Deposit</h2>
		<a class="back iconfont icon-Activity" onclick="jumpLink('{{ route('user.deposit.history') }}',1);"></a>
	</div>
</header>
<div class="topRegion radius003030PX">
	<div class="statistics">
		<ul class="display alignCenter">
			<li class="balance">
				<p><em class='currency'>{{ config('settings')->cur_sym}}</em> {{ showAmount($userBalance) }}</p>
				<span>Deposit balance</span>
			</li>
		</ul>
	</div>
</div>
<div class="main">
	<div class="deposit forms">
		<form id="deposit" action="{{ route('user.deposit.insert') }}" method="post">

			@csrf

			<ul>
				<li>
					<div class="titleBar display alignCenter justifyDetween">
						<div>
							<h3>Deposit amount</h3>
						</div>
					</div>
					<div class="inputArea radius7PX display alignCenter">
						<div class="leftSideBox display alignCenter">
							<i class="i_inputIcon iconfont icon-money-receive-01"></i>
						</div>
						<div class="trueInpt display alignCenter flex1">
							<input type="number" name="amount" id="itemPrice" class="amount fillArea flex1"
								placeholder="Deposit Amount" maxlength="10" oninput="oninputVal(event)" required />
						</div>
					</div>
				</li>

				<li>
					<div class="titleBar display alignCenter justifyDetween">
						<div>
							<h3>Quick amount</h3>
						</div>
					</div>
					<div class="quickAmount" id="quickAmount">
						<ol class="display alignCenter">
							@foreach ($plans as $key => $plan)
								<li class="item" data-amount="{{ getAmount($plan->min_amount) }}">
									<div class="radius7PX"><em class='currency'>{{ $plan->cur_sym }}</em>{{ getAmount($plan->min_amount) }}
									</div>
								</li>
								<?php if( $key > 7 ) break; ?>
							@endforeach
						</ol>
					</div>
				</li>

				<li>
					<div class="titleBar display alignCenter justifyDetween">
						<div>
							<h3>Deposit method</h3>
						</div>
					</div>
					<div class="inputArea radius7PX display alignCenter">
						<div class="leftSideBox display alignCenter">
							<i class="i_inputIcon iconfont icon-bank1"></i>
						</div>
						<div class="trueInpt display alignCenter flex1">
							<select class="bank fillArea flex1" name="method" id="method" style="line-height: 18px;">
								@foreach($gatewayCurrency as $gateway)
								<option value="{{ $gateway->method_code }}" @if($gateway->method_code == 102) selected @endif>{{ $gateway->name }}</option>
								@endforeach
							</select>
						</div>
					</div>
				</li>
			</ul>
			
			<div class="actionBar display alignCenter alignStretch justifyEnd">
				<button type="submit" id="submitBtn" style="background: transparent; border:none;">
					<div class="drawmoneyBtn clickBtn radius50P display alignCenter justifyCenter">
						<p>To Deposit <i class="iconfont icon-arrow-right-3"></i></p>
					</div>
				</button>
			</div>
		</form>
	</div>

	<div class="tipsBox">
		<div id="tips" class="tips">
			<div class="title">
				<h3>Explain</h3>
			</div>
			<div class="explain">
				<p style="color: red;"><strong>1. Please do not modify the deposit amount. Unauthorized modification of the deposit amount will result in the deposit not being credited</strong></p>
				<p>2. Minimum deposit: NGN 2000</p>
				<p>3. Deposit received within 5 minutes, if not received within 5 minutes, please contact online customer service for processing</p>
			</div>
		</div>
	</div>
</div>
@endsection

@push('script')
	<script type="text/javascript">
		$('.item').click(function() {
			var itemPrice = $(this).data('amount');
			$('#itemPrice').val(itemPrice);
		});

		$(document.body).on("click", "#submitBtn", function() {
            toast("", "LOADING...", "loding", 10000, 4);
		});
		
		$(document.body).on("click", "#quickAmount>ol li", function() {
			$("#amount").val($(this).data('amount'));
			$(this).addClass('activate')
			$(this).addClass('activate').siblings().removeClass('activate');
		})
	</script>
@endpush
