@extends($activeTemplate.'layouts.users')

@push('style-lib')
    <link href="{{ asset('users/css/home.css') }}" rel="stylesheet" type="text/css" />
@endpush

@section('content')
	<div class="main" style="padding: 0px;">
		<div class="logoBar h5MaxWidth">
			<div class="display alignCenter justifyDetween">
				<div class="logo flex1"><img src="{{getImage(imagePath()['logoIcon']['path'] .'/logo.png')}}{{$catch}}" alt /></div>
			</div>
		</div>

		<div class="balanceCard display alignCenter">
			<div class="balance flex5">
				<h3 id="balance">{{ showAmount($userBalance['main']+ $userBalance['income']) }}</h3>
				<span>Balance</span>
			</div>
			<div class="actionBar flex2">
				<div class="depositBtn clickBtn_S radius500PX display alignCenter justifyCenter"
					onclick="jumpLink( '{{ route('user.deposit') }}',1)">
					Deposit
				</div>
			</div>
		</div>

		<div class="financialList radius15PX">
			<div class="ivestList">
				<div class="swiper-container tagNav radius151500PX" id="tagNav">
					<div class="swiper-wrapper tagNav-list radius151500PX">

						<div class="swiper-slide tagNav-a" navid="2">
							<div class="radius0077PX">
								<p>Daily</p>
							</div>
						</div>
					</div>
				</div>
				<!-- / -->
				<div id="typeList">
					<!-- LIST BOX -->

					<div class="productList" id="typeList2" style="display:block">
						<div class="productPicture">
							<img src="{{ asset('users/images/sketch/002.png') }}" alt class="radius001515PX" />
							<div class="categoryDescription">
								<div class="title">
									<h3>Daily</h3>
								</div>
							</div>
						</div>
						<div class="list">
							<ul>
								@foreach ($plans as $plan)
									<li>
										<div class="radius15PX">
											<div class="eachPrice gongGeNAV">
												<ol class="display alignEnd alignEnd">
													<li>
														<div class="radius7PX">
															<h3><em class="currency">₦</em>{{ number_format($plan->min_amount) }}</h3>
															<span>Each
																Price</span>
														</div>
													</li>

													<li class="flex1">
														<div class="radius7PX">
															<p>{{ $plan->total_return }} days</p>
															<span>Revenue</span>
														</div>
													</li>

													<li class="flex1">
														<div class="radius7PX">
															<p><em class="currency">₦</em>{{ number_format($plan->interest_amount) }}</p>
															<span>Daily
																Income</span>
														</div>
													</li>

													<li class="flex1">
														<div class="radius7PX">
															<p><em class="currency">₦</em>{{ number_format($plan->interest_amount * $plan->total_return) }}</p>
															<span>Total
																Revenue</span>
														</div>
													</li>
												</ol>
											</div>


											<form action="{{ route('user.investment.post') }}" method="post">
												@csrf
												<input name="id" type="hidden" value="{{ $plan->id }}">
												<input type="hidden" name="pay_with" id="pay_with" value="NGN">

												<div class="investBuy display alignCenter justifyEnd">
													<button style="border: none; background: transparent;" class="investBuy display alignCenter justifyEnd">
														<div class="display alignCenter justifyCenter radius500PX">
															<p>INVEST NOW <i class="iconfont icon-arrow-right-3"></i></p>
														</div>
													</button>
												</div>
											</form>
										</div>
									</li>
								@endforeach
							</ul>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="onlineService radius500PX">
		<div class="likeness">
			<a href="{{ config('settings')->telegram_url}}">
				<img src="{{ asset('users/images/ThirdParty/telegram.svg') }}" alt>
			</a>
		</div>
	</div>
@endsection


@push('scripts')
@endpush
