@extends($activeTemplate.'layouts.users')

@push('style-lib')
    <link href="{{ asset('users/css/taskHall.css') }}" rel="stylesheet" type="text/css" />
@endpush




@section('content')
    <script>
        "use strict"
        function createCountDown(elementId, sec) {
            var tms = sec;
            var x = setInterval(function() {
                var distance = tms * 1000;
                var days = Math.floor(distance / (1000 * 60 * 60 * 24));
                var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                var seconds = Math.floor((distance % (1000 * 60)) / 1000);
                document.getElementById(elementId).innerHTML = days + "d: " + hours + "h " + minutes + "m " +
                    seconds + "s ";
                if (distance < 0) {
                    clearInterval(x);
                    document.getElementById(elementId).innerHTML = "COMPLETE";
                }
                tms--;
            }, 1000);
        }
    </script>


	<div class="main" style="padding: 0px;">
		<div class="invitationCard radius001515PX">
			<div class="explain">
				<h4>My Order</h4>
			</div>
			<div class="actionBar display alignCenter alignStretch justifyEnd">
				<div class="buttonControl radius500PX" id="invitationActivationBtn">
				</div>
			</div>
			<div class="shade">
				<img src="{{ asset('users/images/invite/02.png') }}" alt />
			</div>
		</div>

		<div class="taskList radius7PX" id="taskList">
			<ul>



				@foreach ($logs as $plan)
					<li class="radius7PX" id="1">
						<div class="display alignCenter">
							<div class="gongGeNAV flex1">
								<ol class="display alignEnd alignStretch">
									<li class="flex1">
										<div>
											<p class="gradient">{{ number_format($plan->amount) }}</p>
											<p><span>Income Cycle : </span><em
													class="currency">₦</em>{{ $plan->total_return }} days
											</p>
											<p><span>Daily Income : </span><em
													class="currency">₦</em>{{ number_format($plan->interest_amount) }}
											</p>
											<p><span>Gross Return :
												</span><em
													class="currency">₦</em>{{ number_format($plan->interest_amount * $plan->total_return, 2) }}
											</p>
											<p><span>Total Paid :
												</span><em
													class="currency">₦</em>{{ number_format($plan->total_paid * $plan->interest_amount, 2) }}
											</p>
											<p><span>Next Date : </span><span>
													@php
														$nextTime = \Carbon\Carbon::parse($plan->next_return_date);
													@endphp

													<script>
														createCountDown('counter<?php echo $plan->id; ?>', {{ $nextTime->diffInSeconds() }});
													</script>

													<span class="text m-0" id="counter{{ $plan->id }}"></span>
												</span></p>
										</div>
									</li>
								</ol>
							</div>
						</div>

					</li>
				@endforeach

			</ul>
		</div>
	</div>
@endsection
