@extends($activeTemplate.'layouts.users')

@push('style-lib')
@endpush

@section('content')
<header>
	<div class="header h5MaxWidth clear display alignCenter" style="background:transparent;">
		<a class="back iconfont icon-arrow-left-2" style="color:#000"
		onclick="window.history.go(-1); return false;"></a>
		<h2 class="flex1"></h2>
	</div>
</header>
<div class="main">
	<div style="padding-top:30px;">
		<div style="float: left; width: 100%; text-align: center; color: #fff;">
			<div style="height: 100px; line-height: 100px; margin:0 auto; width:100px; border-radius: 100px; background:#fff;">
				<img src="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}" style="height: auto; border-radius: 100px;width: 100%;padding: 20px;">
			</div>
			<div style="padding:5px; padding-top:10px;color:#000; font-weight:bold; font-size:20px; margin-top:10px;" id="uid">Modify Password</div>
			<div style="padding:5px; padding-top:5px;color:#000; font-size:12px;">Update account login password here</div>
		</div>
	</div>
	<div class="resetPassword forms">
		<form id="resetPassword" action="" method="post">
        @csrf
			<ul>
				<li class="oldPasswordBox">
					<div
						class="inputArea display alignCenter radius7PX">
						<div
							class="leftSideBox display alignCenter">
							<i
								class="i_inputIcon iconfont icon-lock-2"></i>
						</div>
						<div
							class="trueInpt display alignCenter flex1">
							<input type="password"
								name="current_password"
								id="login_OldPassword"
								placeholder="Old Password"
								class="password fillArea eyeClose flex1" />
							<div id="eye"
								class="eye secret rightSideBox display alignCenter">
								<i class="r iconfont icon-eye"></i>
								<i
									class="s iconfont icon-eye-slash"></i>
							</div>
						</div>
					</div>
				</li>
				<li>
					<div
						class="inputArea display alignCenter radius7PX">
						<div
							class="leftSideBox display alignCenter">
							<i
								class="i_inputIcon iconfont icon-lock"></i>
						</div>
						<div
							class="trueInpt display alignCenter flex1">
							<input type="password"
								name="password"
								id="login_NewPassword"
								placeholder="New Password"
								class="password fillArea eyeClose flex1" />
						</div>
					</div>
				</li>
				<li>
					<div
						class="inputArea display alignCenter radius7PX">
						<div
							class="leftSideBox display alignCenter">
							<i
								class="i_inputIcon iconfont icon-lock"></i>
						</div>
						<div
							class="trueInpt display alignCenter flex1">
							<input type="password"
								name="password_confirmation"
								id="login_NewPassword"
								placeholder="Confirm New Password"
								class="password fillArea eyeClose flex1" />
						</div>
					</div>
				</li>
			</ul>
			<div class="actionBar display alignCenter alignStretch">
				<input
					class="changeBtn clickBtn radius7PX flex1 display alignCenter justifyCenter"
					type="submit" value="Change Login Password"
					>
			</div>
		</form>
	</div>
</div>
@endsection

@push('script')
    <script src="/users/js/togglepassword.js" type="text/javascript"></script>

    <script type="text/javascript">
    $(document).ready(function () {
        $('#login_NewPassword,#login_OldPassword').togglePassword({
            el: '#eye'
        });
    });

    function resetPassword(t) {
        var password_O = $('#login_OldPassword').val();
        if (password_O === "") {
            toast('', 'Old Password can not be empty.', 'login', 2000, 1);
            $('#login_NewPassword').focus();
            return;
        }

        var password_N = $("#login_NewPassword").val();
        if (password_N === "") {
            toast('', 'New Password can not be empty.', 'login', 2000, 1);
            $('#login_NewPassword').focus();
            return;
        }

        _api.changeLoginPassword({
            "old_password": password_O,
            "new_password": password_N,
        }, (res) => {
            if (res.code === 0) {
                toast('', res.msg, 'changePassword', 2000, 2);
                setTimeout(function () {
                    window.location.href = './login.html';
                }, 2000);
            } else {
                toast('', res.msg, 'changePassword', 2000, 1);
            }
        });
    }
</script>
@endpush
