{{--@extends($activeTemplate.'layouts.master')--}}
@extends('layouts.users')


@section('content')





<body class="huiBg">
    <div class="top">
        <a onclick="window.history.go(-1); return false;" class="topLeft">
            <i class="layui-icon layui-icon-left" style="font-size: 22px; color: #fff;"></i>
        </a>
        <div class="topTit">Product</div>
    </div>
    <div class="home-device">
        <div class="inline-tab product-tab">
            <a href="{{ route('user.investment') }}" class="active">General <i></i></a>
        </div>
        <div class="home-product">
            <div class="home-product-list">
                @foreach ($plans as $plan)

                <div class="home-product-info">
                    <div class="home-product-con">
                        <div class="product-text">
                            <div class="home-product-name">{{ $plan->name }}</div>
                            <p>Rental Amount : <span>{{ number_format($plan->min_amount) }} NGN</span></p>
                            <p>Income Cycle : <span>{{ $plan->total_return }} days</span></p>
                            <p>Daily Income : <span>{{ number_format($plan->interest_amount) }} NGN</span></p>
                            <p>Estima Income: <span>{{ number_format($plan->interest_amount * $plan->total_return) }} NGN</span></p>
                        </div>
                        <div class="product-img">
                            <img src="{{ asset('users/static/home/images/plan.jpeg') }}"
                                alt />
                        </div>
                    </div>
                    <div class="product-btm">
                        <span>{{ number_format($plan->min_amount) }} NGN</span>
                        <form action="{{ route('user.investment') }}" method="post">
                            @csrf
                            <input name="id" type="hidden" value="{{ $plan->id }}">
                            <button style="border: none; background: transparent;" class="buy-btn" type="submit"><a class="buy-btn">Invest</a></button>
                        </form>


                    </div>
                </div>

                @endforeach

            </div>
        </div>
    </div>

</body>



@endsection



@push('style')
    <style type="text/css">
        #copyBoard {
            cursor: pointer;
            height: 100%;
        }

        .input-group-text {
            background-color: #0a1227;
            border: 1px solid #373768;
            color: #fff;
        }

        #referralURL {
            background: #20204e;
            border-color: #20204e;
            color: #fff;
        }

        #social-links ul li {
            list-style: none !important;
            display: inline-block;
        }

        #social-links ul a {
            display: block;
            padding: 4px 10px;
        }


    </style>
@endpush

@push('script')

    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        $(document).ready(function() {
            $('.js-example-basic-single').select2({
                theme: "classic"
            });
        });
        (function ($) {

            "use strict";
            $('.planModal').on('click', function () {
                var modal = $('#planModal');
                modal.find('input[name=id]').val($(this).data('id'));
                modal.find($('#planModalLabel').text($(this).data('name')));
            });
            $('.copyBoard').click(function () {
                "use strict";
                var copyText = document.getElementById("referralURL");
                copyText.select();
                copyText.setSelectionRange(0, 99999);
                /*For mobile devices*/
                document.execCommand("copy");
                iziToast.success({message: "Copied: " + copyText.value, position: "topRight"});
            });
        })(jQuery);
    </script>
@endpush
