@extends($activeTemplate.'layouts.users')

@push('style-lib')
    <link href="{{ asset('users/css/account.css') }}" rel="stylesheet" type="text/css" />
@endpush

@section('content')
<div class="main" style="padding: 0px;">
	<div class="accountCard h5MaxWidth">
		<div class="userCard display alignCenter">
			<div class="userinfo display alignCenter justifyDetween flex1">
				<div class="useName flex1" >
					<span id="accountTel">{{ substr($user->mobile, 0, 3) . str_repeat('*', 4) . substr($user->mobile, 7) }}<br/>({{ $user->ref_code }})</span>
				</div>
			</div>
			<div class="portrait">
				<div class="frame radius500PX display alignCenter justifyCenter">
					<i class="iconfont icon-user"></i>
				</div>
			</div>
		</div>
	</div>

	<div class="balanceCard radius15PX">
		<div class="bankCardHolder">
			<div id="bankCard" class="radius151500PX">
				<div class="addBank display alignStart radius7PX" onclick="jumpLink('{{ route('user.account-setup') }}',1)">
					<div class="text flex1">
						@if (auth()->user()->bankAccount)
							<p>{{ auth()->user()->bankAccount->bank_name }}</p>
							<span>{{ substr(auth()->user()->bankAccount->account_number, 0, 3) . str_repeat('*', 4) . substr(auth()->user()->bankAccount->account_number, 7) }}</span>
						@else
							<p>No bank card</p>
							<span>Please add bank card</span>
						@endif

					</div>
					<div class="icon">
						<i class="iconfont icon-credit-card-add"></i>
					</div>
				</div>
			</div>
			<div class="splitClip">
				<img src="{{ asset('users/images/SplitClip.png') }}" alt />
			</div>
		</div>
		<div class="capitalItem flex5">
			<div class="gongGeNAV">
				<ul class="display alignEnd alignEnd">
					<li class="balance flex1">
						<div class="radius7PX">
							<h3 id="balance">{{ number_format($user->balance + $user->bonus_balance) }}</h3>
							<span>Balance</span>
						</div>
					</li>
					<li class="flex1" onclick="jumpLink('{{ route('user.deposit') }}',1)">
						<div class="radius7PX">
							<p id="depositBalance">{{ number_format($user->balance) }}</p>
							<span>Deposit</span>
						</div>
					</li>
					<li class="flex1" onclick="jumpLink('{{ route('user.withdraw') }}',1)">
						<div class="radius7PX">
							<p id="withdrawBalance">{{ number_format($user->income) }}</p>
							<span>Withdrawable</span>
						</div>
					</li>
				</ul>
				<ul class="display alignEnd alignEnd">
					<li class="balance flex1" >
						<div class="radius7PX">
							<p id="sumReward">{{ showAmount($user->points) }}</p>
							<span>Reward</span>
						</div>
					</li>
					<li class="flex1"
						onclick="jumpLink('{{ route('user.transaction.type', ['type' => 'commission']) }}',1)">
						<div class="radius7PX">
							<p id="sumCommission">{{ number_format($user->referral) }}</p>
							<span>Commission</span>
						</div>
					</li>
					<li class="flex1"
						onclick="jumpLink('{{route('user.investment.log')}}',1)">
						<div class="radius7PX">
							<p id="order">+1</p>
							<span>MyOrder</span>
						</div>
					</li>
				</ul> 

			</div>
		</div>
	</div>

	<div class="functionMenu">
		<div class="gongGeNAV">
			<ul class="display alignEnd alignStretch">
				<li onclick="jumpLink('{{ route('user.deposit') }}',1)">
					<div class="radius7PX">
						<div class="icon"><i class="iconfont icon-Deposit"></i></div>
						<p>Deposit</p>
					</div>
				</li>
				<li onclick="jumpLink('{{ route('user.withdraw') }}',1)">
					<div class="radius7PX">
						<div class="icon"><i class="iconfont icon-takeOut"></i></div>
						<p>Withdraw</p>
					</div>
				</li>
				<li onclick="jumpLink('{{ route('user.withdraw.history') }}',1)">
					<div class="radius7PX">
						<div class="icon"><i class="iconfont icon-sms-tracking"></i></div>
						<p>History</p>
					</div>
				</li>
				<li onclick="jumpLink('{{ route('user.change.password') }}',1)">
					<div class="radius7PX">
						<div class="icon"><i class="iconfont icon-key"></i></div>
						<p>Password</p>
					</div>
				</li>
				<li onclick="jumpLink('{{ route('user.company') }}',1)">
					<div class="radius7PX">
						<div class="icon"><i class="iconfont icon-aboutus"></i></div>
						<p>About</p>
					</div>
				</li>
				<li class="logout" onclick="jumpLink('{{ route('user.logout') }}',0)">
					<div class="radius7PX">
						<div class="icon"><i class="iconfont icon-logout"></i></div>
						<p>Logout</p>
					</div>
				</li>
			</ul>
		</div>
	</div>

	<div class="serviceMenu">
		<div class="">
			<div class="title">
				<h3>{{ config('settings')->sitename}} Channel</h3>
			</div>
			@if( config('settings')->telegram_url )
			<ul class="cell" id="service">
				<li class="socialHandle radius7PX display alignCenter" data-href="{{ config('settings')->telegram_url }}">
					<div class="icon display alignCenter justifyCenter">
						<img src="{{ asset('users/images/ThirdParty/telegram.svg') }}" alt style="width: 40px;" />
					</div>
					<div class="infoBar display alignCenter flex1">
						<div class="titleLabel flex1">
							<p>Telegram</p>
							<span>Follow our official channel to get info</span>
						</div>
						<div class="more"><i class="iconfont icon-arrow-right-3"></i></div>
					</div>
				</li>
			</ul>
			@endif

			@if( config('settings')->whatsapp_url )
			<ul class="cell" id="service">
				<li class="socialHandle radius7PX display alignCenter" data-href="{{ config('settings')->whatsapp_url }}">
					<div class="icon display alignCenter justifyCenter">
						<img src="{{ asset('users/images/ThirdParty/whatsapp.svg') }}" alt style="width: 34px;" />
					</div>
					<div class="infoBar display alignCenter flex1">
						<div class="titleLabel flex1">
							<p>Whatsapp</p>
							<span>Follow our official channel and get latest information</span>
						</div>
						<div class="more"><i class="iconfont icon-arrow-right-3"></i></div>
					</div>
				</li>
			</ul>
			@endif

			@if( config('settings')->x_handle )
			<ul class="cell" id="service">
				<li class="socialHandle radius7PX display alignCenter" data-href="{{ config('settings')->x_handle }}">
					<div class="icon display alignCenter justifyCenter">
						<img src="{{ asset('users/images/ThirdParty/twitter.svg') }}" alt style="width: 40px;" />
					</div>
					<div class="infoBar display alignCenter flex1">
						<div class="titleLabel flex1">
							<p>X [Twitter]</p>
							<span>Follow our official handle to get updates</span>
						</div>
						<div class="more"><i class="iconfont icon-arrow-right-3"></i></div>
					</div>
				</li>
			</ul>
			@endif
			
		</div>

		@if( config('settings')->whatsapp_number )
		<div class="onlineServiceList">
			<div class="title">
				<h3>Whatsapp Support</h3>
			</div>
			<ul class="cell" id="service">
				<li class="socialHandle radius7PX display alignCenter" data-href="{{ config('settings')->whatsapp_number }}">
					<div class="icon display alignCenter justifyCenter">
						<img src="{{ asset('users/images/ThirdParty/whatsapp.svg') }}" style="width:32px;" alt />
					</div>
					<div class="infoBar display alignCenter flex1">
						<div class="titleLabel flex1">
							<p>WhatsApp Customer Support</p>
							<span>10:00 AM to 20:00 PM</span>
						</div>
						<div class="more"><i class="iconfont icon-arrow-right-3"></i></div>
					</div>
				</li>
			</ul>
		</div>
		@endif
		
		@if( config('settings')->telegram_number )
		<div class="onlineServiceList">
			<div class="title">
				<h3>Telegram Support</h3>
			</div>
			<ul class="cell" id="service">
				<li class="radius7PX socialHandle display alignCenter" data-href="{{ config('settings')->telegram_number }}">
					<div class="icon display alignCenter justifyCenter">
						<img src="{{ asset('users/images/ThirdParty/telegram.svg') }}" style="width:32px;" alt />
					</div>
					<div class="infoBar display alignCenter flex1">
						<div class="titleLabel flex1">
							<p>Telegram Customer Support</p>
							<span>9:00 AM to 22:00 PM</span>
						</div>
						<div class="more"><i class="iconfont icon-arrow-right-3"></i></div>
					</div>
				</li>
			</ul>
		</div>
		@endif
		
	</div>
</div>
@endsection

@push('script')
<script type="text/javascript">
	$(document).ready(function() {

		$(".socialHandle ").click(function () {
			var androidurl = $(this).data('href');

			if (window.android) {
				window.android.callAndroid("open," + androidurl)
				return;
			}
			if (window.webkit && window.webkit.messageHandlers) {
				window.webkit.messageHandlers.nativeExt.postMessage({ msg: 'open,' + androidurl });
				return;
			}
			$("#jump").parent().attr("href", androidurl), $("#jump").trigger("click");
		});

	});
</script>
@endpush