<!DOCTYPE html>
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
		<?php $pageTitle = 'welcome page'; ?>
		<title>{{ $pageTitle }}</title>
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
		
		<link rel="shortcut icon" href="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}" type="image/x-icon">

		{{--<!-- Apple Stuff -->--}}
		<link rel="apple-touch-icon" href="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}">
		<meta name="apple-mobile-web-app-capable" content="yes">
		<meta name="apple-mobile-web-app-status-bar-style" content="black">
		<meta name="apple-mobile-web-app-title" content="{{ $pageTitle }}">

		{{--<!-- Facebook Meta Tags -->--}}
		<meta property="og:type" content="website">
		<meta property="og:image:type" content="jpg" />
		<meta property="og:image:width" content="1080" />
		<meta property="og:image:height" content="840" />
		<meta property="og:url" content="{{ url()->current() }}">
		
		{{--<!-- Twitter Meta Tags -->--}}
		<meta name="twitter:card" content="summary_large_image">

		<meta itemprop="name" content="{{$pageTitle}}">
		<meta itemprop="image" content="/assets/images/welcome.jpg">

		<meta property="og:title" content="{{$pageTitle}}">
		<meta property="og:image" content="/assets/images/welcome.jpg"/>

		<link rel="stylesheet" href="/assets/css/layui.css{{$catch}}">
		<link href="/assets/css/auth.css{{$catch}}" rel="stylesheet">
		<link rel="stylesheet" href="{{ asset('users/jasper/css/loading.css') }}{{$catch}}">
		<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
		<script src="/assets/js/layui.js{{$catch}}"></script>
	</head>

	<body style="background: url('/assets/images/welcome.jpg') no-repeat; background-size: 100% 115%; ">
		<input type="hidden" id="telegram" value="{{ config('settings')->whatsapp_url }}">
		<input type="hidden" id="whatsapp" value="{{ config('settings')->telegram_url }}">

		<div style=" max-width:450px; margin:0 auto;">
			<div style="padding-top:120px;">
				<div style="width: 95%; margin: 0 auto; background: #00000098; border-radius: 10px; ">
					<div style="text-align: center; ">
						<img src="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}" style="height:60px; padding-top:25px;padding-bottom:25px;">
					</div>
					<div class="layui-form" style="margin:0 auto; width:95%;">
						<div style="color:#fff; text-align:center; margin-top:15px; height:75px;">
							<div style="color: #0C95B3; font-size: 14px; width: 100%; margin: 0 auto; margin-top: 30px; ">
								@if( config('settings')->whatsapp_url )
								<div style="float:left;width:50%;">
									<img src="/assets/images/t1.png" style="height:40px;" id="service">
								</div>
								@endif

								@if( config('settings')->telegram_url )
								<div style="float:left;width:50%;">
									<img src="/assets/images/t2.png" style="height: 40px;" id="service1">
								</div>
								@endif
							</div>
						</div>
					</div>
				</div>

				<div style="width: 100%; margin: 0 auto; background: #00000098; border-radius: 10px 10px 0 0; bottom: 0px; position: absolute;">
					<div style="text-align: center; ">
						<p style="height:60px; padding-top:25px;padding-bottom:25px;color:#FFF;font-size:26px;">Congratulations!</p>
					</div>

					<div class="layui-form" style="margin:0 auto; width:95%;">
						<p align="center" style="font-size:18px;color:#fff">You have received {{config('settings')->cur_sym . config('settings')->welcome_bonus}} as your welcome bonus</p>

						<div class="layui-form-item linkBTN" data-href="{{ route('user.home') }}" style="margin-top:20px; text-align:center;">
							<input class="layui-btn" id="login" value="Continue 繼續" style="width: 85%; font-weight: 600; height: 40px; line-height: 40px; font-size: 16px; display: inline-block; background: #000; color: #fff; border: 1px groove #c0c0c0; border-radius: 25px;" type="button">
						</div>

						<div style="color:#fff; text-align:center; margin-top:15px; height:35px;"></div>
					</div>
				</div>
			</div>
		</div>

		<script type="text/javascript">
            $().ready(function () {

                $("#service").click(function () {
					console.log('ss');
                    var androidurl = $("#whatsapp").val();
                    if (window.android) {
                        window.android.callAndroid("open," + androidurl)
                        return;
                    }
                    if (window.webkit && window.webkit.messageHandlers) {
                        window.webkit.messageHandlers.nativeExt.postMessage({ msg: 'open,' + androidurl });
                        return;
                    }
                    $("#jump").parent().attr("href", androidurl), $("#jump").trigger("click");
                });

                $("#service1").click(function () {
					console.log('ss');
                    var androidurl = $("#telegram").val();
                    if (window.android) {
                        window.android.callAndroid("open," + androidurl)
                        return;
                    }
                    if (window.webkit && window.webkit.messageHandlers) {
                        window.webkit.messageHandlers.nativeExt.postMessage({ msg: 'open,' + androidurl });
                        return;
                    }
                    $("#jump").parent().attr("href", androidurl), $("#jump").trigger("click");
                });

            });
    </script>
	
	</body>
</html>
