@extends($activeTemplate.'layouts.users')

@push('style-lib')
@endpush


@section('content')

<header class="isScrollTo noColor">
	<div class="header h5MaxWidth clear display alignCenter">
		<a class="back iconfont icon-arrow-left-2" onclick="window.history.go(-1); return false;"></a>
		<h2 class="flex1">Withdraw</h2>
		<a class="back iconfont icon-Activity" onclick="jumpLink('{{ route('user.withdraw.history') }}',1);"></a>
	</div>
</header>
<div class="topRegion radius003030PX">
	<div class="statistics">
		<ul class="display alignCenter">
			<li class="balance">
				<p><em class='currency'>{{config('settings')->cur_sym}}</em> {{ number_format(auth()->user()->bonus_balance) }}</p>
				<span>Withdrawable</span>
			</li>
		</ul>
	</div>

</div>
<div class="main">

	<div class="drawmoney forms">
		<form id="drawmoney" action="" method="post">

            <input type="hidden" id="method" value="{{ $withdrawMethod[0]->id}}">
            <input type="hidden" id="debit_with" value="2">
            @csrf

			<ul>

				@if (auth()->user()->bankAccount)
					<li>
						<div class="thisBankCard" id="thisBankCard">
							<div class="skeleton radius15PX">
								<div class="bankCardInfor">
									<h3>{{ substr(auth()->user()->bankAccount->account_number, 0, 3) . str_repeat('*', 4) . substr(auth()->user()->bankAccount->account_number, 7) }}</h3>
									<p>Bank: {{ auth()->user()->bankAccount->bank_name }}</p>
								</div>
							</div>
						</div>
					</li>
				@endif


				<li>
					<div class="inputArea radius7PX display alignCenter">
						<div class="leftSideBox display alignCenter">
							<i class="i_inputIcon iconfont icon-money-01"></i>
						</div>
						<div class="trueInpt display alignCenter flex1">
							<input type="number" name="amount" id="withdrawalAmount"
								class="withdrawalAmount fillArea inrICO inputIcon flex1"
								placeholder="Withdrawal Amount" maxlength="11" size="11" required />
						</div>
					</div>
				</li>
			</ul>
			<button type="button" id="withdrawBTN" style="border:none; background:transparent" class="actionBar display alignCenter justifyEnd">
				<div class="drawmoneyBtn clickBtn radius50P display alignCenter justifyCenter">
					<p>Submit withdraw <i class="iconfont icon-arrow-right-3"></i></p>
				</div>
			</button>
		</form>
	</div>

	<div class="tipsBox">
		<div id="tips" class="tips">
			<div class="title">
				<h3>Explaination</h3>
			</div>
			<div class="explain">
                {!! $withdrawMethod[0]->description !!}
			</div>
		</div>
	</div>
</div>
@endsection

@push('script')
<script>
    $("#withdrawBTN").click(function() {

        var amount = $('#withdrawalAmount');
        var method = $('#method');
        var debit_from = $('#debit_with');
        var token = document.querySelector('input[name="_token"]').value;

        var is_status = true;

        if (!amount.val()) {
			toast('', 'Withdrawing amount needed', 'noCode', 2000, 1);
            is_status = false; return false;
        }

        if (is_status) {
            $.ajax({
                type: "POST",
                url: "{{ route('user.withdraw.money') }}",
                data: {
                    amount: amount.val(),
                    method: method.val(),
                    debit_from: debit_from.val(),
                    password: '',
                    _token: token
                },
                beforeSend: function() {
					toast("", "LOADING...", "loding", 10000, 4);
                },
                success: function(data) {
					toast('', data.message, 'withdraw', 3000, 2);
					setTimeout(function() {
						jumpLink(data.link, 3);
					}, 2000);
                },
                error: function(xhr, status, error) {
                    var responseText = JSON.parse(xhr.responseText);

					toast('', responseText.message, 'withdraw', 3000, 1);
                },
                fail: function() {
					toast('', 'Request Failed', 'withdraw', 3000, 1);
                }
            });
        }


        return false;
    })
</script>
@endpush
