<!DOCTYPE html>
<html class="web" lang="en" style="font-size:47.3866px;">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no">

		@stack('seo-lib')

		{{--<!-- Apple Stuff -->--}}
		<link rel="apple-touch-icon" href="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}">
		<meta name="apple-mobile-web-app-capable" content="yes">
		<meta name="apple-mobile-web-app-status-bar-style" content="black">

		<link rel="stylesheet" type="text/css" href="{{ asset($activeTemplateTrue.'css/reset.css') }}{{$catch}}">
		<link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/common.css') }}{{$catch}}">
		<link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/signin.css') }}{{$catch}}">
		<script src="{{ asset($activeTemplateTrue.'script/common.js') }}{{$catch}}"></script>
		<script src="{{ asset($activeTemplateTrue.'script/jquery-2.1.4.min.js') }}{{$catch}}"></script>
	</head>

	<body style="visibility: visible;">

		@yield('content')

		<div class="actionBar display alignCenter justifyAround" style="position:absolute;bottom:0px;display:none">

			<div class="socialHandle display alignCenter justifyCenter" data-href="{{config('settings')->whatsapp_url}}" style="cursor: pointer;" >
				<img src="/assets/images/cs_t2.png" style="width:30px" />
			</div>

			<div class="socialHandle display alignCenter justifyCenter" data-href="{{config('settings')->telegram_url}}" style="cursor: pointer;" >
				<img src="/assets/images/telegram.png" style="width:34px" />
			</div>

			<div class="socialHandle display alignCenter justifyCenter" data-href="{{config('settings')->x_handle}}" style="cursor: pointer;" >
				<i class="iconfont icon-twitter_X" style="font-size:28px"></i>
			</div>
		</div>

		@stack('script-lib')

		@stack('script')

		@include($activeTemplate.'partials.notify')

		@include('partials.plugins')

		<script type="text/javascript">
			$(document).ready(function() {

                $(".socialHandle ").click(function () {
                    var androidurl = $(this).data('href');

                    if (window.android) {
                        window.android.callAndroid("open," + androidurl)
                        return;
                    }
                    if (window.webkit && window.webkit.messageHandlers) {
                        window.webkit.messageHandlers.nativeExt.postMessage({ msg: 'open,' + androidurl });
                        return;
                    }
                    $("#jump").parent().attr("href", androidurl), $("#jump").trigger("click");
                });

			});
		</script>
		
		<a href="" target="_blank" style="display:none;"><span id="jump"></span></a>
	</body>
</html>