@php $loginContent = getContent(config('settings')->active_template, 'login.content', true); @endphp

@extends($activeTemplate.'layouts.auth')

@push('seo-lib')
	<?php $pageTitle = @$loginContent->data_values->title; ?>
	<title>{{ config('settings')->sitename }} - {{$pageTitle}}</title>
	<link rel="shortcut icon" href="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}" type="image/x-icon">
	<meta name="keywords" content="{!! @$loginContent->data_values->keyword !!}">

	<meta name="description" content="{!! @$loginContent->data_values->description !!}">
	<meta itemprop="name" content="{{$pageTitle}}">
	<meta itemprop="description" content="{!! @$loginContent->data_values->description !!}">
	<meta itemprop="image" content="{{ asset( 'assets/images/frontend/login/' .@$loginContent->data_values->seo_image) }}">

	<meta property="og:title" content="{{$pageTitle}}">
	<meta property="og:description" content="{!! @$loginContent->data_values->description !!}">
	<meta property="og:image" content="{{ asset( 'assets/images/frontend/login/' .@$loginContent->data_values->seo_image) }}"/>

	<meta name="apple-mobile-web-app-title" content="{{ $pageTitle }}">
@endpush


@section('content')

@if( @$loginContent->data_values->background == '2')
<div id="app" class="signin-wrap forgot-password" style="background-image: linear-gradient(to bottom, #{{ config('settings')->secondary_color}}10, #{{ config('settings')->base_color}});">
@elseif( @$loginContent->data_values->background  == '1')
<div id="app" class="signin-wrap forgot-password" style="background-image: linear-gradient(to bottom, #{{ config('settings')->secondary_color}}10, #{{ config('settings')->base_color}}), url({{ asset( 'assets/images/frontend/login/' .@$loginContent->data_values->seo_image) }});">
@else
<div id="app" class="signin-wrap forgot-password">
@endif
	<div class="navbar" style="background:none;"><span onclic="onBack()"></span> <span></span> <span style="cursor: pointer;user-select: none;" onclick="onJump(&#39;{{route('user.register')}}&#39;)">
				Register
			</span>
	</div>
	
	<form name="loginForm" method="post" action="{{ route('user.login')}}" id="loginForm" >
		@csrf
		<h2 class="title" style="margin-top: 2.2rem;">Login
			<div class="favicon" style="left:4px;"><img src="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}" alt /></div>
		</h2>
		<div class="text">
			<ul>
				<li class="form-title" style="margin-top: 0px;">Phone</li>
				<li class="li one"><em>+234</em>
					<input type="tel" name="username" id="phdk" placeholder="phone number" autocomplete="off" value="{{ old('username') }}" class="van-field__control">
					<p></p> <b class="close"></b></li>
				<li class="form-title">password</li>
				<li class="li"><input id="pwd" name="password" type="password" placeholder="Login password" autocomplete="off" maxlength="20">
					<p></p> <b class="close right90"></b> <b class="eye"></b>
				</li>
				<li class="form-title">Captcha</li>
				<li class="li"><input id="captcha" type="number" 
					maxlength="4" oninput="if(value.length>4)value=value.slice(0,4)" name="captcha"
					placeholder="Verification code" autocomplete="off" />
					<p></p> <b class="close right290"></b>
					<div><img class="verifyImg" id="verifyImg" src="{{ route('security.image') }}" onclick="refreshCaptcha()" style="width: 100%;height:46px;border-radius: 5px;"></div>

				</li>
			</ul>

			<label for="remember" class="alignCenter">
				<span class="text-xs tracking-normal text-white font-semibold">Remember Me</span>
				<input class="text-c-blue-400" id="remember" name="remember" type="checkbox" value="y" />
			</label>
		</div>
		<div onclick="onSign()" class="btn" style="cursor: pointer;user-select: none;" >
			Login
		</div> <br> <br> <br>
	</form>
</div>
@endsection


@push('script')
	<script>
		$('.close').click(function() {
			$($(this).siblings('input')[0]).val('')
			$(this).removeClass('active')
		})

		$('.eye').click(function() {
			if ($($(this).siblings('input')[0]).attr('type') == 'password') {
				$($(this).siblings('input')[0]).attr('type', 'text')
				$(this).addClass('active')
			} else {
				$($(this).siblings('input')[0]).attr('type', 'password')
				$(this).removeClass('active')
			}
		})
		$('input').on('input', function($event) {
			if ($($event.target).siblings('.close')[0]) {
				if (!($($($event.target)[0]).val())) {
					$($($event.target).siblings('.close')[0]).removeClass('active')
				} else {
					$($($event.target).siblings('.close')[0]).addClass('active')
				}
			}
		})
		$('input').on('blur', function($event) {
			$($($event.target).siblings('.close')[0]).removeClass('active')
		})
		$('input').on('focus', function($event) {
			if ($($event.target).siblings('.close')[0]) {
				if (($($($event.target)[0]).val())) {
					$($($event.target).siblings('.close')[0]).addClass('active')
				}
			}
		})
		
		function onSign() {
			let flag = true;
			let li = document.querySelectorAll('.li');
			var phone = $("#phdk").val();
			var password = $("#pwd").val();

			li.forEach((dom, index) => {
				dom.querySelector('p').innerText = '';
				let input = dom.querySelector('input');
				let p = dom.querySelector('p');
				//console.log(input.name);
				if (input.name == 'username') {
					if (!phone) {
						p.innerText = 'Please enter your mobile phone number to login.';
						flag = false
					}else if (phone.length != 10) {
						p.innerText = 'Please enter a valid mobile phone number with 10 digits.';
						flag = false
					}
				} else if(input.name == 'password') {
					if (!password) {
						p.innerText = 'Please enter password for your account.'
						flag = false
					}else
					if (password.length < 5) {
						p.innerText = 'Your password must be longer than 6 characters.';
						flag = false
					}
				}else if(input.name == 'captcha'){
					var captcha = input.value;
					if (!captcha) {
						p.innerText = 'Please enter captcha show below.'
						flag = false
					}else
					if (captcha.length < 4) {
						p.innerText = 'Captcha must be 4 characters.';
						flag = false
					}
				}
			})

			if (!flag) return
				hsycms.loading('loading.');
				$("#loginForm").submit();
				rememberMe();
		}
		
		var username = document.getElementById('phdk'),
			password = document.getElementById('pwd');

		function rememberMe(){
			var isChecked = document.getElementById('remember');
			if( isChecked.checked ){
				localStorage.setItem('username', username.value);
				localStorage.setItem('password', password.value);
				localStorage.setItem('remember', 'true');
			}else{
				localStorage.setItem('username', '');
				localStorage.setItem('password', '');
				localStorage.setItem('remember', '');
			}
		}
	
		var remember = document.getElementById('remember'),
			localUser = localStorage.getItem('username') || '', //获取user的值并保存
			localPass = localStorage.getItem('password') || '', //获取user的值并保存
			localReme = localStorage.getItem('remember') || ''; //获取password的值并保存
			username.value = localUser; password.value = localPass; if(localReme){remember.checked=true}; 
		
	</script>
@endpush
