@php $loginContent = getContent(config('settings')->active_template, 'login.content', true); @endphp

@extends($activeTemplate.'layouts.auth')

@push('seo-lib')
	<?php $pageTitle = 'Reset Password'; ?>
	<title>{{ config('settings')->sitename }} - {{$pageTitle}}</title>
	<link rel="shortcut icon" href="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}" type="image/x-icon">
	<meta name="keywords" content="{!! @$loginContent->data_values->keyword !!}">

	<meta name="description" content="{!! @$loginContent->data_values->description !!}">
	<meta itemprop="name" content="{{$pageTitle}}">
	<meta itemprop="description" content="{!! @$loginContent->data_values->description !!}">
	<meta itemprop="image" content="{{ asset( 'assets/images/frontend/login/' .@$loginContent->data_values->seo_image) }}">

	<meta property="og:title" content="{{$pageTitle}}">
	<meta property="og:description" content="{!! @$loginContent->data_values->description !!}">
	<meta property="og:image" content="{{ asset( 'assets/images/frontend/login/' .@$loginContent->data_values->seo_image) }}"/>

	<meta name="apple-mobile-web-app-title" content="{{ $pageTitle }}">
@endpush


@section('content')
<div class="motif h5MaxWidth">
	<img src="{{ asset( 'assets/images/frontend/login/' .@$loginContent->data_values->backgroud) }}{{$catch}}" alt="" style="opacity: 0.3;" />
</div>

<div class="loginBox h5MaxWidth display alignCenter">

	<div class="login forms">
		<div class="topArea">
			<div class="logo"><img src="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}" alt /></div>
			<div class="greetings">{{ @$pageTitle }}</div>
			<div class="greetings">輸入您的憑證以重設您的帳戶</div>
		</div>

		<form id="resetPassword" action="#" method="post" onsubmit >
			@csrf
			<ul>
				<li class="areaCode">
					<div class="inputArea display alignCenter radius7PX">
						<div class="leftSideBox display alignCenter">
							<i class="i_inputIcon iconfont icon-mobile"></i>
						</div>
						<div class="trueInpt display alignCenter flex1">
							<p id="areaCode"></p>
							<input type="mobile" name="mobile" id="mobile" class="mobile fillArea flex1"
								placeholder="Mobile number" maxlength="11" size="11" required/>
						</div>
					</div>
				</li>

				{{--  <li class="oldPasswordBox">
					<div class="inputArea display alignCenter radius7PX">
						<div class="leftSideBox display alignCenter">
							<i class="i_inputIcon iconfont icon-lock-2"></i>
						</div>
						<div class="trueInpt display alignCenter flex1">
							<input type="password" name="login_OldPassword" id="login_OldPassword"
								placeholder="Old Password" class="password fillArea eyeClose flex1" />
							<div id="eye" class="eye secret rightSideBox display alignCenter">
								<i class="r iconfont icon-eye"></i>
								<i class="s iconfont icon-eye-slash"></i>
							</div>
						</div>
					</div>
				</li>
				<li>
					<div class="inputArea display alignCenter radius7PX">
						<div class="leftSideBox display alignCenter">
							<i class="i_inputIcon iconfont icon-lock"></i>
						</div>
						<div class="trueInpt display alignCenter flex1">
							<input type="password" name="login_NewPassword" id="login_NewPassword"
								placeholder="New Password" class="password fillArea eyeClose flex1" />
						</div>
					</div>
				</li>
				<li class="verificationCodeBox">
					<div class="inputArea display alignCenter radius7PX">
						<div class="leftSideBox display alignCenter">
							<i class="i_inputIcon iconfont icon-password-check"></i>
						</div>
						<div class="trueInpt display alignCenter flex1">
							<input type="text" name="verificationCode " id="verificationCode"
								class="checkCode fillArea flex1" placeholder="Verification code (OTP)"
								maxlength="5" size="5" />
							<div id="getCode" class="getCode rightSideBox display alignCenter"
								onclick="getCode()">
								<p>Send</p>
							</div>
						</div>
					</div>
				</li>  --}}
			</ul>
			<div class="actionBar display alignCenter alignStretch">

				<input class="changeBtn clickBtn radius7PX flex1 display alignCenter justifyCenter"
					type="submit" value="Reset password" onclick="resetPassword()">
			</div>

			<div class="fPassword"><a href="{{ route('user.login') }}">Login instead</a></div>
			
		</form>
	</div>
</div>
@endsection

@push('script')
@endpush
