@php $loginContent = getContent(config('settings')->active_template, 'register.content', true); @endphp

@extends($activeTemplate.'layouts.auth')

@push('seo-lib')
	<?php $pageTitle = @$loginContent->data_values->title; ?>
	<title>{{ config('settings')->sitename }} - {{$pageTitle}}</title>
	<link rel="shortcut icon" href="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}" type="image/x-icon">
	<meta name="keywords" content="{!! @$loginContent->data_values->keyword !!}">

	<meta name="description" content="{!! @$loginContent->data_values->description !!}">
	<meta itemprop="name" content="{{$pageTitle}}">
	<meta itemprop="description" content="{!! @$loginContent->data_values->description !!}">
	<meta itemprop="image" content="{{ asset( 'assets/images/frontend/register/' .@$loginContent->data_values->seo_image) }}">

	<meta property="og:title" content="{{$pageTitle}}">
	<meta property="og:description" content="{!! @$loginContent->data_values->description !!}">
	<meta property="og:image" content="{{ asset( 'assets/images/frontend/register/' .@$loginContent->data_values->seo_image) }}"/>

	<meta name="apple-mobile-web-app-title" content="{{ $pageTitle }}">
@endpush

@section('content')

@if( @$loginContent->data_values->background == '2')
<form method="post" action="{{ route('user.register')}}" id="registerForm" class="signin-wrap forgot-password" style="background-image: linear-gradient(to bottom, #{{ config('settings')->secondary_color}}10, #{{ config('settings')->base_color}});">
@elseif( @$loginContent->data_values->background  == '1')
<form method="post" action="{{ route('user.register')}}" id="registerForm" class="signin-wrap forgot-password" style="background-image: linear-gradient(to bottom, #{{ config('settings')->secondary_color}}10, #{{ config('settings')->base_color}}), url({{ asset( 'assets/images/frontend/register/' .@$loginContent->data_values->seo_image) }});">
@else
<form method="post" action="{{ route('user.register')}}" id="registerForm" class="signin-wrap forgot-password">
@endif

	<div class="navbar" style="background:none;">
		<span onclick="onBack()" style="cursor: pointer;user-select: none;"><i></i></span><span></span><span></span>
	</div>
	@csrf
	<h2 class="title">Register
		<div class="favicon"><img src="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}" alt /></div>
	</h2>
	<div id="app" class="text">
		<ul>
			@if(session()->get('reference') != null)
			<li class="li" style="border-bottom: none">
				<input class="block text-center" type="text" value="REFERRED BY {{session()->get('reference')}}" readonly style="flex:1;background: rgba(255, 255, 255, 0.2);border-radius: 4px;padding: 15px;margin-bottom: 30px;" />
				<input name="referBy" type="hidden" value="{{session()->get('reference')}}"/>
				<p></p> <b class="close"></b>
			</li>
			@endif

			<li class="form-title" style="margin-top: 0px;">Phone</li>
			<li class="li one"><em>+234</em>
				<input type="tel" name="mobile" id="phdk" placeholder="phone number" autocomplete="off" value="{{ old('mobile') }}" class="van-field__control">
				<p></p> <b class="close"></b>
			</li>
			<li class="form-title">Login password</li>
			<li class="li"><input id="pwd" name="password" type="password" placeholder="Login password" maxlength="20">
				<p></p> <b class="close right90"></b> <b class="eye"></b></li>

			@if(session()->get('reference') == null)
			<li class="form-title">Confirm Login Password</li>
			<li class="li"><input id="passConfirm" type="password" name="password_confirmation" placeholder="Confirm Login Password" maxlength="20">
				<p></p> <b class="close right90"></b> <b class="eye"></b>
			</li>
			@else
			<input name="password_confirmation" id="passConfirm" type="hidden" />
			@endif
			<li class="form-title">Captcha</li>
			<li class="li"><input id="captcha" type="number" 
				maxlength="4" oninput="if(value.length>4)value=value.slice(0,4)" name="captcha"
				placeholder="Verification code" autocomplete="off" />
				<p></p> <b class="close right290"></b>
				<div><img class="verifyImg" id="verifyImg" src="{{ route('security.image') }}" onclick="refreshCaptcha()" style="width: 100%;height:46px;border-radius: 5px;"></div>
			</li>

		</ul>
	</div>

	<br/><br/>
	<div onclick="onSign()" class="btn" style="cursor: pointer;user-select: none;" >
		Register
	</div>
	<p class="retrieve text-right" style="cursor: pointer;user-select: none;" onclick="onJump('{{ route('user.login')}}')">Login</p>
	<br><br>
</form>
@endsection

@push('script')
	<script>
		$('.close').click(function() {
			$($(this).siblings('input')[0]).val('')
			$(this).removeClass('active')
		})

		$('.eye').click(function() {
			if ($($(this).siblings('input')[0]).attr('type') == 'password') {
				$($(this).siblings('input')[0]).attr('type', 'text')
				$(this).addClass('active')
			} else {
				$($(this).siblings('input')[0]).attr('type', 'password')
				$(this).removeClass('active')
			}
		})
		$('input').on('input', function($event) {
			if ($($event.target).siblings('.close')[0]) {
				if (!($($($event.target)[0]).val())) {
					$($($event.target).siblings('.close')[0]).removeClass('active')
				} else {
					$($($event.target).siblings('.close')[0]).addClass('active')
				}
			}
		})
		$('input').on('blur', function($event) {
			$($($event.target).siblings('.close')[0]).removeClass('active')
		})
		$('input').on('focus', function($event) {
			if ($($event.target).siblings('.close')[0]) {
				if (($($($event.target)[0]).val())) {
					$($($event.target).siblings('.close')[0]).addClass('active')
				}
			}
		})
		
		function onSign() {
			let flag = true;
			let li = document.querySelectorAll('.li');
			var phone = $("#phdk").val();
			var password = $("#pwd").val();
			$('#passConfirm').val(password);

			li.forEach((dom, index) => {
				dom.querySelector('p').innerText = '';
				let input = dom.querySelector('input');
				let p = dom.querySelector('p');
				//console.log(input.name);
				if (input.name == 'mobile') {
					if (!phone) {
						p.innerText = 'Please enter your mobile phone to register.';
						flag = false
					}else if (phone.length != 10) {
						p.innerText = 'Please enter a valid mobile number with 10 digits.';
						flag = false
					}
				} else if(input.name == 'password') {
					if (!password) {
						p.innerText = 'Please enter password for your account.'
						flag = false
					}else
					if (password.length < 5) {
						p.innerText = 'Your password must be longer than 6 characters.';
						flag = false
					}
				}else if(input.name == 'captcha'){
					var captcha = input.value;
					if (!captcha) {
						p.innerText = 'Please enter captcha show below.'
						flag = false
					}else
					if (captcha.length < 4) {
						p.innerText = 'Captcha must be 4 characters.';
						flag = false
					}
				}
			})

			if (!flag) return
				hsycms.loading('loading.');
				$("#registerForm").submit();
		}
	</script>
@endpush