@extends($activeTemplate.'layouts.users')

@push('style-lib')
	<link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/bank.css') }}{{$catch}}">
@endpush

@section('content')
	<script>
		var canSend = false;
		function submit() {
			let flag = true;
			let li = document.querySelectorAll('li');
			li.forEach((dom, index) => {
				dom.querySelector('p').innerText = '';
				if (index == 0) {
					let input = dom.querySelector('input');
					let p = dom.querySelector('p');
					if (!input.value) {
						p.innerText = 'Please select your bank'
						flag = false
					}
				} else if (index == 1) {
					let input = dom.querySelector('input');
					let p = dom.querySelector('p');
					if (!input.value) {
						p.innerText = 'Please enter the bank number'
						flag = false
					}
				} else if (index == 2) {
					let input = dom.querySelector('input');
					let p = dom.querySelector('p');
					if (!input.value) {
						p.innerText = 'Please type in your name'
						flag = false
					}
				} else if (index == 3) {
					let input = dom.querySelector('input');
					let p = dom.querySelector('p');
					if (!input.value) {
						p.innerText = 'please enter account password'
						flag = false
					}
				}
			})

			if (!flag) return
			let text = document.querySelectorAll('li input');
			console.log(text[0].value, text[1].value, text[2].value, text[3].value);

			hsycms.loading('loading.');
			$("#bankForm").submit();
			
		}
	</script>

    <div class="bank-wrap">
        <div class="navbar">
            <span onclick="onJump('{{ route('user.profile')}}')">
					<i></i>
				</span>
            <span>bank account</span>
            <span>
				</span>
        </div>
        <div class="tips-box" style="margin-top:25px;">
            <p class="tips">
                Please input the following 3 parts to facilitate your withdrawal.
            </p>
        </div>

        <form action="" method="post" id="bankForm" class="list-wrap">
            <ul class="uls">
                <li>
                    <span>Bank name</span>
                    <select name="bank_code" id="bank_name" style="width: 100%;font-size: .24rem;color: #ff1616;">
						<option value="">Please select bank</option>
						@foreach($banks as $bank)
							<option class="text-black" value="{{ $bank['bank_code'] }}">{{ $bank['name'] }}</option>
						@endforeach
					</select>
					<input type="hidden" name="bank_name" id="bank_code">
                    <p></p>
                </li>

                <li>
                    <span>Account Number</span>
                    <input type="text" name="account_number" id="account" class="name" placeholder="Please type your number" value="">
                    <p></p>
                    <b class="close"></b>
                </li>

                <li>
                    <span>Account Name</span>
                    <input type="text" name="account_name" id="account_name" class="account" placeholder="Please enter account name" value="">
                    <p></p>
                    <b class="close"></b>
                </li>

                <li>
                    <span>Login Password</span>
                    <input type="text" name="password" id="password" class="account" placeholder="Please enter account password" />
                    <p></p>
                    <b class="close"></b>
                </li>

            </ul>

			@csrf
            <div class="btn" id="reg" onclick="submit();" >Submit</div>
        </form>
    </div>
@endsection

@push('script-lib')
	<textarea style="display: none;" id="all_banks">{!! $all_banks !!}</textarea>

<script>
    let all_banks = JSON.parse($("#all_banks").val());

    (function ($) {
        "use strict";

        function getByValue(value) {
            let arr = all_banks;
            for (var i = 0, iLen = arr.length; i < iLen; i++) {
                if (arr[i].bank_code == value) return arr[i].name;
            }
        }

        $("#bank_name").change(function (e) {
            let code = $("#bank_name").val();
            let account = $("#account").val();

            let t = getByValue(code);
			
			console.log(t);

            $("#bank_code").val(t);
            if (account != "" && code != "" && account == 10) {
                get_account_info(code, account);
            }
        });

        $("#account").change(function () {
            let code = $("#bank_name").val();
            let account = $("#account").val();

            if (account == "" || code == "" || account.length < 10) {
				canSend = false;
                $("#account_name").val("");
                return;
            }
            get_account_info(code, account);
        });
		

        function get_account_info(code, account) {
            hsycms.loading('loading.');

            $.ajax({
                url: "{{ route('account.fetch') }}",
                type: 'get',
                dataType: 'json',
                data: {
                    'bank-verification': '',
                    'code': code,
                    'account': account
                },
                success: function (response) {
					hsycms.hideLoading();
                    if (response.status == "error") {
                        $("#account_name").val("");
						Toast("Could not get account details. Try again");
						canSend = false;
                        return;
                    }

					canSend = true;
                    console.log(response.data);
                    $("#account_name").val(response.data.account_name);
					Toast("Account found ["+response.data.account_name+"]" );
                },

                error: function (err) {
                    console.log(err.responseText);
					loading.hideLoading();
                }
            });
        }

    })(jQuery);
</script>
@endpush
