@extends($activeTemplate.'layouts.users')

@push('style-lib')
	<link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/recharge.css') }}{{$catch}}">
@endpush


@section('content')
    <div class="recharge-wrap">
        <div class="navbar">
            <span onclick="onBack()"><i></i></span>
            <span></span>
            <span></span>
        </div>

        <h5 style="margin-top:1rem">
            <img src="{{ asset($activeTemplateTrue.'img/ic_coim@2x.png') }}" alt="" srcset=""> Existing balance
        </h5>
        <h6 class="ye">{{ config('settings')->cur_sym}}{{ showAmount($userBalance) }}</h6>
        <div class="tab">
            <div class="active">Recharge</div>
            <div onclick="onJump(&#39;{{ route('user.deposit.history') }}&#39;)">Recharge record</div>
        </div>
		
        <div class="centnen">
            <!-- 充值 -->
			<form class="wrap" id="depositForm" action="{{ route('user.deposit.insert') }}" method="post">
                <div class="box">
                    <p>Choose Amount</p>
                    <ul class="list">
						@foreach ($plans as $key => $plan)
                        <li data-id="" class="item" data-amount="{{ getAmount($plan->min_amount) }}">
                            <h2>{{ getAmount($plan->min_amount) }}</h2>
                        </li>
							<?php if( $key > 7 ) break; ?>
						@endforeach
                    </ul>

                    <input type="text" placeholder="other amount..." maxlength="9" id="money" name="amount" class="money">

                </div>
				@csrf

				<input type="hidden" name="currency" class="edit-currency" value="NGN" />
				<input type="hidden" name="method" class="edit-method-code" value="102" />
				<input type="hidden" required name="plan_id" id="planid" />

                <div class="box">
					<p>Choose recharge method</p>
					<div class="bank">
						@foreach($gatewayCurrency as $data)
						<div class="payoption @if($data->method_code == 102) active @endif" data-method_code="{{$data->method_code}}" data-currency="{{$data->currency}}">
							<i></i> {{__($data->name)}}
						</div>
						@endforeach
					</div>
                </div>

                <div class="btn" onclick="onOk()">Recharge</div>
            </form>

			<div id="tips" class="tips" style="color:#FFF;font-size:16px;">
				<div class="title">
					<h3>Explain</h3>
				</div>
				<div class="explain">
					<p style="color: red;"><strong>1. Please do not modify the deposit amount. Unauthorized modification of the deposit amount will result in the deposit not being credited</strong></p>
					<p>2. Minimum deposit: NGN 3,500</p>
					<p>3. Deposit received within 5 minutes, if not received within 5 minutes, please contact online customer service for processing</p>
				</div>
			</div>
        </div>

	</div>
@endsection

@push('script')
	<script type="text/javascript">
        $('.list .item').click(function() {
            $(this).addClass('active').siblings().removeClass('active');
            let value = $(this).data('amount');
            $('.money').val(value);
        })

        $('#money').keyup(function() {
            $(this)[0].value = $(this)[0].value.replace(/^(0+)|[^\d]+/g, '')
            $('.list .item').removeClass('active');
        })

        $('.upilist>li').click(function() {
            $(this).addClass('active').siblings().removeClass('active');
        })

		$(".payoption").click(function() {
			$(".edit-currency").val($(this).data('currency'));
			$(".edit-method-code").val($(this).data('method_code'));
			$(".payoption").removeClass('active');
			$(this).addClass('active');
		})


        function onOk() {
            var money = $('.money').val();

            if (money < 100 || money > 2500000) {
                Toast("Sorry, the deposit amount is not within the range");
                return false;
            }
            hsycms.loading('loading.');
			$("#depositForm").submit();
        }
    </script>
@endpush
