<?php $homeColor = 'bebcbc'; ?>
@extends($activeTemplate.'layouts.users')

@push('style-lib')
	<link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/swiper.min.css') }}{{$catch}}">
	<link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/recharge.css') }}{{$catch}}">
	<link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/withdraw.css') }}{{$catch}}">
	<link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/my.css') }}{{$catch}}">
@endpush

@section('content')
	<div class="home-wrap">
		<div class="top-wrap">
			<h1><img style="height:40px; width:auto" src="{{ getImage(imagePath()['logoIcon']['path'] .'/logo.png') }}{{$catch}}" /> <a onclick="showSupport()"><img src="{{ asset($activeTemplateTrue.'img/customerservice@2x.png') }}" alt=""></a></h1>

			@include($activeTemplate.'user.home.slider')
		</div>
		
		<?php $adLog = \App\Models\Transaction::select('users.username','type','amount', 'details', 'transactions.created_at')->join('users','users.id','=','user_id')->whereIn('type', ['deposit','commission','withdraw','invest'])->orderByRaw('RAND()')->take(30)->get(); ?>
		

		<div class="notice">
			<div>
				<i></i>
				<div class="swiper">
					<div id="auto-scroll" class="wraps">
						<ul style="margin-top: 0px;">
							<?php foreach($adLog as $list ){ ?>
								<li>
									<?php if($list->type == 'invest'){ echo $list->username . ' ' . $list->details . ' with ' . ($list->amount+0); } ?>
									<?php if($list->type == 'deposit'){ echo $list->username . ' ' . $list->details . ' sum of ' . ($list->amount+0); } ?>
									<?php if($list->type == 'commission'){ echo $list->username . ' got ' . ($list->amount+0) . ' for ' . $list->details; } ?>
									<?php if($list->type == 'withdraw'){ echo $list->username . ' got paid ' . $list->details; } ?>
								</li>
							<?php } ?>
						</ul>
					</div>
				</div>
			</div>
		</div>

		<div class="menu">
			<div onclick="onJump('{{ route('user.deposit') }}')">
				<img src="{{ asset($activeTemplateTrue.'img/ic_smart1@2x.png') }}{{$catch}}" alt="">
				<p style="color:#000;">Recharge</p>
			</div>
			<div onclick="onJump('{{ route('user.withdraw') }}')">
				<img src="{{ asset($activeTemplateTrue.'img/ic_smart2@2x.png') }}{{$catch}}" alt="">
				<p style="color:#000;">Withdraw</p>
			</div>
			<div onclick="onJump('{{route('user.app.help')}}')">
				<img src="{{ asset($activeTemplateTrue.'img/ic_smart3@2x.png') }}{{$catch}}" alt="">
				<p style="color:#000;">Company</p>
			</div>
			<div onclick="onJump('{{route('user.twofactor')}}')">
				<img src="{{ asset($activeTemplateTrue.'img/ic_smart4@2x.png') }}{{$catch}}" alt="">
				<p style="color:#000;">Authenticate</p>
			</div>
		</div>

		<h2 class="title" style="color:#000;">Investment Center</h2>
		<ul>
			@foreach($plans as $k => $data)
			<?php $miM = $data->min_amount; $maM = $data->max_amount; ?>
			<li>
				<div class="pic">
					<img src="{{ asset('assets/'.$data->img) }} " alt="" style="border-radius: 8px;" />
					<div class="bot">
						<b>{{strtoupper(@$data->name)}}</b>
						<span>{{$data->total_return}} <span>Total times</span></span>
						<span>24 Hour<span>Cycle</span></span>
					</div>
				</div>
				<p>
					<span>{{ $data->cur_sym }}{{number_format($data->interest_amount,0)}}</span>
					<span>{{ $data->cur_sym }}{{number_format(($data->interest_amount*$data->total_return),0)}}</span>
				</p>
				<h4>
					<span>Per Income 24 Hour</span>
					<span>Gross income</span>
				</h4>
				<h6>
					<span>{{ $data->cur_sym }}<b>{{number_format($miM,0)}}</b></span>
					<div class="btn" data-resource="{{ $data }}" data-currency="{{ $data->cur_sym }}" data-dai="{{ $data->name }}" data-money="{{getAmount($miM,0)}}" data-id="{{ $data->id }}" data-type_id="{{ $data->interest_type }}">Invest Now</div>
				</h6>
			</li>
			@endforeach
		</ul>

        <!-- 购买弹窗 -->
        <div class="mask buy withdraw-wrap">
			<form action="{{ route('user.investment.post') }}" class="box investForm mask-body" method="post" style="background:#FFF" >
				<div class="buyok" style="position: absolute;left: 44%;top: -20px;background: #fff;border-radius: 50%;padding:4px"><img src="{{ asset($activeTemplateTrue.'img/close@2x.png') }}" /></div>
				<input type="hidden" name="id" id="proid" value="0">
                <h3>
                    Please Confirm
                </h3>
                <h4>
                    <span id="product_name">ST-G01</span>
                    <b id="product_money"><span>₦</span> 7500.0</b>
                </h4>
				
				<div class="boxk" style="display:none;" id="amountDiv">
					<h3 style="color:#000;margin-bottom:0px">Withdrawal amount</h3>
					<div class="wrap" style="margin-top:8px;margin-bottom:20px;">
						<b style="color:#000" id="packCurrency">{{ $user->user_currency_sym}}</b>
						<div>
							<input class="money" name="amount" id="orderAmount" type="text" maxlength="9" placeholder="Please enter amount" style="color:#000;" />
							<span class="all">All</span>
						</div>
					</div>
				</div>
				
				<div class="boxk" style="display:block;" >
					<h3 style="color:#000;margin-bottom:0px">Discount Code [optional]</h3>
					<div class="wrap" style="margin-top:8px;margin-bottom:20px;">
						<b style="color:#000"><img src="{{ asset($activeTemplateTrue.'img/coupon.png') }}"  /></b>
						<div>
							<input class="" name="coupon" type="text" maxlength="20" placeholder="Enter code if you have" style="color:#000;text-align:left;">
						</div>
					</div>
				</div>
				
				<input type="hidden" name="pay_with" id="pay_with" value="">
				@csrf
				
                <h4 class="con">
                    <span></span>
                    <b><img src="{{ asset($activeTemplateTrue.'img/ic_coim@2x.png') }}{{$catch}}" alt="" srcset=""> Balance: {{ config('settings')->cur_sym }}{{ showAmount($userBalance['main'],0) }}</b>
                </h4>
                <div class="btn">
                    <div onclick="invest();">Invest</div>
                </div>
            </form>
        </div>

			<!-- 购买弹窗 -->
		<div class="support">
			<div class="supportList">
				<div class="model-mask sClose"></div>
				<div style="position:relative;color: #fff;text-align: center;margin-top: 10px;font-size: large;">ACTIVE SUPPORT LINE</div>
				<ul class="list" style="margin-bottom: 30px;padding: 0 5px;">
					@if( config('settings')->whatsapp_number )
					<li class="socialHandle" data-link="{{ config('settings')->whatsapp_number }}">
						<img class="img" src="{{ asset($activeTemplateTrue.'img/whatsapp.svg') }}{{$catch}}" alt="">
						<span>Support line</span>
						<img class="i" src="{{ asset($activeTemplateTrue.'img/arrow@2x.png') }}{{$catch}}" alt="">
					</li>
					@endif

					@if( config('settings')->telegram_number )
					<li class="socialHandle" data-link="{{ config('settings')->telegram_number }}">
						<img class="img" src="{{ asset($activeTemplateTrue.'img/telegram.svg') }}{{$catch}}" alt="">
						<span>Support line</span>
						<img class="i" src="{{ asset($activeTemplateTrue.'img/arrow@2x.png') }}{{$catch}}" alt="">
					</li>
					@endif

					@if( config('settings')->whatsapp_url )
					<li class="socialHandle" data-link="{{ config('settings')->whatsapp_url }}">
						<img class="img" src="{{ asset($activeTemplateTrue.'img/whatsapp.svg') }}{{$catch}}" alt="">
						<span>Group & Channel</span>
						<img class="i" src="{{ asset($activeTemplateTrue.'img/arrow@2x.png') }}{{$catch}}" alt="">
					</li>
					@endif

					@if( config('settings')->telegram_url )
					<li class="socialHandle" data-link="{{ config('settings')->telegram_url }}">
						<img class="img" src="{{ asset($activeTemplateTrue.'img/telegram.svg') }}{{$catch}}" alt="">
						<span>Group & Channel</span>
						<img class="i" src="{{ asset($activeTemplateTrue.'img/arrow@2x.png') }}{{$catch}}" alt="">
					</li>
					@endif
				</ul>

				<div class="rio-ol-po sClose" style="position:relative;border-radius: 8px;width: 99%;margin: 0 auto;margin-bottom: 5px;border:1px solid #ffffff">
					<div class="Tontb text-white" style="margin-left: 5px;line-height: 17px;font-size: 16px;">CANCEL PAGE</div>
				</div>
			</div>
		</div>
		
	</div>
@endsection

@section('menu')
	@include($activeTemplate.'layouts.menu',['activeLink'=>'dashboard'])
@endsection


@push('script')
	<script src="{{ asset($activeTemplateTrue.'script/swiper.min.js') }}{{$catch}}"></script>
	<script>
        $(function() {
            //banner
            new Swiper('.swiper-banner', {
                loop: false,
                autoplay: {
                    delay: 5000
                }
            });

			$(".sClose").click(function () {
				$('.supportList').fadeOut();
			});

            //广告
            var timer;
            $('#auto-scroll').hover(function() {
                clearInterval(timer);
            }, function() {
                timer = setInterval(function() {
                    $('#auto-scroll').find("ul:first").animate({
                        marginTop: "-.5rem"
                    }, 800, function() {
                        $(this).css({
                            marginTop: "0px"
                        }).find("li:first").appendTo(this);
                    });
                }, 3000);
            }).trigger('mouseleave');

			$(".socialHandle ").click(function () {
				var androidurl = $(this).data('link');

				if (window.android) {
					window.android.callAndroid("open," + androidurl)
					return;
				}
				if (window.webkit && window.webkit.messageHandlers) {
					window.webkit.messageHandlers.nativeExt.postMessage({ msg: 'open,' + androidurl });
					return;
				}
				$("#jump").parent().attr("href", androidurl), $("#jump").trigger("click");
			});


			$(".guanx").click(function() {
				$("#invInterest").html('0.0000'),$("#amountPsk").val('');
				$(".errorRPT").html('');
				$(".mask").hide();wallet = 0;
				$("body").removeClass('overflow');
			})

			$(".widyibtn").click(function() {
				if ( wallet == 0 ) {
					Toast('Kindly select a wallet'); return false;
				}
				return true;
			})

			$("body").delegate('.cion', 'click', function (){
                var result = $(this).data('resource');
                $('.edit-currency').val(result.currency);
				if( result.method_code){
					$('.edit-method-code').val(result.method_code);
				}else{
					$('.edit-method-code').val(result.id);
				}
				wallet = result.id;
				$(".cion").removeClass('anbtnsi');
				$(this).addClass('anbtnsi');
			});

            $('li').on('click', '.btn', function() {
                $('.buy').fadeIn();
                $('body,html').css({
                    overflow: 'hidden'
                })
				
				var info = $(this).data("resource");
				
				var maxAmount = parseFloat(info.max_amount).toFixed(2);
				var minAmount = parseFloat(info.min_amount).toFixed(2);
				
				$("#proid").val(info.id);
				$("#orderAmount").val(minAmount);
				$("#packCurrency").html(info.cur_sym);
				$("#pay_with").val(info.cur_text);
				$("#orderAmount").attr({
				   "max" : maxAmount,
				   "min" : minAmount
				});
				
				if( info.interest_type == 1 ){
					$("#amountDiv").show();
				}else{
					$("#amountDiv").hide();
				}
				
                $('#product_name').text(info.name);
                $('#product_money').html('<span>'+info.cur_sym+'</span>' + minAmount);
                $('.buy').show();
            })

            $('.buy').on('click', function() {
                $('.buy').fadeOut();
                $('body,html').css({
                    overflow: 'auto'
                })
            })
            $('.buy .mask-body').on('click', function() {
                event.stopPropagation()
            })


            $('.buyok').on('click', function(event) {
                $('.buy').fadeOut();
                $('body,html').css({
                    overflow: 'auto'
                })
            })

        });
		
		function invest(){
			hsycms.loading('Buying...');
			$(".investForm").submit();
			return true;
		}
		
		function showSupport(){
			$('.supportList').slideDown(200);
		}
    </script>
@endpush

