@php $pageContent = getContent(config('settings')->active_template, 'myproduct.content', true); @endphp
<?php $diLd = now()->copy()->endOfDay()->timestamp; ?>
<?php
	$last_time = \Carbon\Carbon::parse($user->next_claim);
	$now = \Carbon\Carbon::now();
	$difference = $last_time->diffInHours($now);
	if( $last_time > $now){
		$diLd = $last_time->timestamp;
	}
?>
<?php $sTime = date( 'r', $diLd );?>
<?php
	$pendingIncome = 'pending_income'; 
	if($user->user_currency != 'NGN'){
		$pendingIncome = 'usdt_pending_income'; 
	}
?>

@extends($activeTemplate.'layouts.users')

@push('style')
	<link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/team.css') }}{{$catch}}">
@endpush


@section('content')

@php $link = route('invite', ['code' => auth()->user()->ref_code]); @endphp

    <div class="team-wrap">
        <h1 style="margin-top:40px">Users orders</h1>
        <div class="top-wrap">
            <div class="wrap order">
                <div class="box">
                    <div>
                        <h2>{{ $logs->count() }}<span>
								<img src="{{ asset($activeTemplateTrue.'img/sjt2.png') }}" alt="" srcset="">
								{{ ($logs->count())?'+':'0' }}</span>
                        </h2>
                        <p>Total Purchase Order</p>
                    </div>
                    <div>
                        <h2 >{{ showAmount($userBalance['income'], 0) }}<span class="blue">
							{{ config('settings')->cur_sym }}
							<img src="{{ asset($activeTemplateTrue.'img/sjt.png') }}" alt="" srcset="">
							</span>
                        </h2>
                        <p>Users Income Balance</p>
                    </div>
                </div>
                <h5>Total purchased order：<span id="authenticated">{{ config('settings')->cur_sym }}{{ showAmount($sumIncome) }}</span></h5>
            </div>

        </div>

        <h1 style="margin-top:45px;">Products purchased</h1>
        <ul>
			@forelse($logs as $key => $log)
            <li style="height: auto;">
				<img src="{{ asset('assets') }}/{{ $log->plan->img }}" style='position: absolute;height: 100%;border-radius: .16rem;width: 100%;opacity: 0.1;margin-right: -.32rem;'>
                <div>
                    <span class="lv{{ ($key+1) }}">
						{{ $log->plan->name }}
						<b style="width: auto;">{{$log->plan->cur_sym}}{{showAmount($log->interest_amount,0)}} ~ [Daily]</b>
					</span>
                </div>
                <p>
                    <span>{{$log->total_return}} cycle</span>
                    <span><b>{{ $log->plan->cur_sym }}</b>{{ showAmount($log->amount, 0) }}</span>
                    <span><b>{{ config('settings')->cur_sym }}</b>{{ showAmount(($log->interest_amount * $log->total_paid), 0) }}</span>
                </p>
                <h3>
                    <span>Duration</span>
                    <span>Purchase cost</span>
                    <span>Earnings</span>
                </h3>
				<p style="padding: 5px 0px; color: #FFF; text-align: left; font-size: 14px;">Product was ordered at ~ {{ $log->created_at->format('dS F Y, H:i') }}</p>

				<div class="rio-ol-po sClose" onclick="Toast('Profit now taken. Check accumulated profit');" align="center" style="position:relative;border-radius: 8px;width:100%;margin:10px 0 -7px;border:1px solid #ffffff">
					<div class="Tontb text-white" style="width:100%;text-align:center;margin-left: 5px;line-height: 17px;font-size: 16px;">TAKE PROFIT</div>
				</div>

                <img src="{{ asset($activeTemplateTrue.'img/arrow@2x.png') }}" alt="">
            </li>
			@empty
			<div style="padding:2px; width:95%; margin:0 auto; margin-top:50px;">
				<div style="border-radius: 5px; color:#fff; text-align:center; margin-top:35px;position:relative;">
					<img src="/assets/images/no.png" style=" width:100%;" /><br>
				</div>
			</div>
			<div class="layui-flow-more">You have no active purchase at moment</div>
			@endforelse
        </ul>

		@if( $logs->count() )
		<div style="border-radius: 5px;margin-top:45px;" id="list">
			<div class="btn2" id="whatsapp-share" data-href="{{ $link }}" style="width: 98%; background: #000; margin:0 auto; line-height:20px; border:1px solid #fff; color:#fff; border-radius: 5px !important;text-align: center;">
				<div style="font-weight:bold;font-size:15px;">Accumulated products profit {{ config('settings')->cur_sym }}{{ showAmount($user->$pendingIncome, 2) }}<br/>
				<span>CLAIM ALL NOW</span></div>
			</div>
		</div>
		@endif

	</div>	
@endsection

@section('menu')
	@include($activeTemplate.'layouts.menu',['activeLink'=>'trade'])
@endsection

@push('script')
<script>
    $('#whatsapp-share').on('click', function() {
        var url = $(this).data('url');
		$.ajax({
			type: "POST",
			url: "{{ route('user.collect.income') }}ED",
			data: {
                _token: '{{ csrf_token() }}'
			},
			beforeSend: function() {
				hsycms.loading("Checking...");
			},
			success: function(data) {
				hsycms.hideLoading();
                Toast(data.message, 200, data.link);
			},
			error: function(xhr, status, error) {
                var data = JSON.parse(xhr.responseText);
                var responseMessage = data.message
                Toast(responseMessage);
				hsycms.hideLoading();
			},
			fail: function() {
				hsycms.hideLoading();
				Toast("Request Failed");
			}
		});
		
    });
</script>
@endpush
