@extends($activeTemplate.'layouts.users')

@push('style')
	<link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/team.css') }}{{$catch}}">
@endpush

@section('content')
    <div class="team-wrap">
        <h1>Team</h1>
        <div class="top-wrap">
            <div class="wrap tms">
                <div class="box">
                    <div>
                        <h2>{{ $totalReferral }}<span>
								<img src="{{ asset($activeTemplateTrue.'img/sjt2.png') }}" alt="" srcset="">
								{{ ($totalReferral)?'+':'0' }}</span>
                        </h2>
                        <p>Total direct referrals</p>
                    </div>
                    <div>
                        <h2>{{ config('settings')->cur_sym }}{{ showAmount($user->referral,0) }}<span class="blue">
							<img src="{{ asset($activeTemplateTrue.'img/sjt.png') }}" alt="" srcset="">
							{{ ($user->referral)?'+':'0' }}</span>
                        </h2>
                        <p>Gross Income</p>
                    </div>
                </div>
                <h5>Authenticated user：<span id="authenticated">0</span></h5>
            </div>

        </div>

        <h1>Team details</h1>
		<?php $authUser = 0; ?>
        <ul>
			@foreach($levels as $level)
            <li onclick="onJump(&#39;{{route('user.agents.level', $level->level)}}&#39;)">
				@php $LevelEarn = \App\Models\Transaction::where('type', 'commission')->where('user_id', $user->id)->where('ref_level', $level->level); @endphp
				@php $gAmount = $LevelEarn->sum('amount'); @endphp
                <div>
                    <span class="lv{{$level->level}}">
						Team info
						<b>LV {{$level->level}} ~ [{{ $level->percent }}%]</b>
					</span>
                </div>
                <p><?php $authUser += $LevelEarn->count(); ?>
                    <span>{{$LevelEarn->count()}}</span>
                    <span><b>{{ config('settings')->cur_sym }}</b>{{ showAmount($gAmount,0) }}</span>
                    <span><b>{{ config('settings')->cur_sym }}</b>{{ showAmount((($gAmount*100)/$level->percent), 0) }}</span>
                </p>
                <h3>
                    <span>Users count</span>
                    <span>My bonus</span>
                    <span>All promotions</span>
                </h3>
                <img src="{{ asset($activeTemplateTrue.'img/arrow@2x.png') }}" alt="">
            </li>
			@endforeach
        </ul>

        <h4><img src="{{ asset($activeTemplateTrue.'img/ic_team_help@2x.png') }}" alt="" srcset=""> Team Promotion Award</h4>

        <p class="tips">
		@if( isset($levels[0]) )
			Level 1 receives {{$levels[0]->percent}}% of the recharge amount,
		@endif
		@if( isset($levels[1]) )
			Level 2 {{$levels[1]->percent}}%
		@endif
		@if( isset($levels[2]) )
			and Level 3 receives {{$levels[2]->percent}}%
		@endif
		<br> The bonus will be issued immediately after the referral invest rather than registration.<br>
        </p>

    </div>
@endsection

@section('menu')
	@include($activeTemplate.'layouts.menu',['activeLink'=>'team'])
@endsection


@push('script')
<script>
	$(document).ready(function() {
		var ucont = '{{$authUser}}';
		$('#authenticated').html(ucont);
	});
</script>
@endpush