@extends($activeTemplate.'layouts.users')

@push('style-lib')
	<link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/form.css') }}{{$catch}}">
	<link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/recharge.css') }}{{$catch}}">
@endpush


@section('content')
<div class="recharge-wrap">
	<div class="titleBar" data-v-400f8df7="" data-v-c6f9d966="" style="background-color: transparent;">
		<div class="back" data-v-400f8df7=""><a href="{{route('user.profile')}}" data-v-c35495fc="" class="text-white" ><img src="{{ asset($activeTemplateTrue.'img/back.png') }}" class="back-img" /></a></div>
		<div class="title" data-v-400f8df7="" style="color: rgb(255, 255, 255);"></div>
		<div class="right" data-v-400f8df7=""></div>
	</div>

	@if(Auth::user()->ts)
	<form class="container" method="POST" action="{{route('user.twofactor.disable')}}" data-v-c6f9d966="">
		@csrf
		<div class="part2" data-v-385ac480="" data-v-c6f9d966="">
			<div class="top_lv_VIEw" data-v-385ac480=""><i class="left_icon" data-v-385ac480=""></i><span data-v-385ac480="">@Lang('Disable_2FA')</span></div>
			<div class="m" data-v-385ac480="" style="padding:8px 1.5vmin 3.2vmin">
				<div class="TopUpInstructions" data-v-ee9f835e="" style="padding:0; background:transparent;">
					<p data-v-ee9f835e="">Tips Info</p>
					<p data-v-ee9f835e="">@Lang('2fa_disable_tips')</p>
				</div>
			</div>
		</div>

		<div class="content">
			<div class="topUpCls" data-v-ee9f835e="" style="">
				<div class="priceInput" data-v-ee9f835e="">
					<p data-v-ee9f835e="">@Lang('enter_2fa')</p>
					<p data-v-ee9f835e="">
						<span data-v-ee9f835e=""><img src="{{ asset($activeTemplateTrue.'img/password.svg') }}" /></span>
						<input type="text" name="code" id="google2fa-code" autocomplete="off" required placeholder="Enter 2FA Code" data-v-ee9f835e="" />
					</p>
				</div><br/>

				<div class="TopUpInstructions" data-v-ee9f835e="">
					<p data-v-ee9f835e="">@Lang('Attention'):</p>
					<p data-v-ee9f835e="">@Lang('Attention_Note')</p>
				</div>
				
				<div class="topUpButtonView" data-v-ee9f835e=""><button type="submit" data-v-ee9f835e="">@Lang('Disable 2FA')</button></div>
			</div>
		</div>
		
		<div class="part5" data-v-1a6c58de="" data-v-c6f9d966="">
			<div class="barBox" data-v-1a6c58de="">
			</div>
		</div>
	</form>
	@else
	<div class="centnen" style="margin-top:14.5vmin">
		<div class="wrap">
			<div class="tips-box">
				<h2><img src="{{ asset($activeTemplateTrue.'img/ic_help@2x.png') }}" alt="" srcset=""> @Lang('Enable 2FA')</h2>
				<p data-v-ee9f835e="">@Lang('2fa_step_1') <a target="_blank" href="https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2" class="text-light f16">Google Play</a> or <a target="_blank" href="https://apps.apple.com/us/app/google-authenticator/id388497605" class="text-light f16">App Store</a>.</p>
				<p><br/><hr style="opacity:0.2"/><br/></p>
				<p data-v-ee9f835e="" class="mb-1"><strong class="text-dark">@Lang('2fa_step_2'):</strong></p>
			</div>
		</div>
	</div>

	<form action="{{route('user.twofactor.enable')}}" method="POST" class="container" id="google2faForm">
		@csrf

		<div class="centnen">
			<div class="wrap">
				<div class="box">
					<p>YOUR 2FA CODE</p>
					<div class="bank">
						<div class="active" onclick="copyME(this)" data-clipboard="{{$secret}}" style="width:80%" data-copy-text="2FA CODE NOW COPIED">
							<i></i> {{$secret}} 
							<svg xmlns="http://www.w3.org/2000/svg" width="19" height="19" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-link" style="margin-left: 16px;"><path d="M10 13a5 5 0 0 0 7.54.54l3-3a5 5 0 0 0-7.07-7.07l-1.72 1.71"></path><path d="M14 11a5 5 0 0 0-7.54-.54l-3 3a5 5 0 0 0 7.07 7.07l1.71-1.71"></path></svg>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="chea">
			<div class="log" style="margin-top:10px">
				<img src="{{$qrCodeUrl}}" alt="@lang('image')" style="width:135px;" />
			</div>
		</div>

		<div class="centnen">
			<div class="wrap">
				<div class="box">
					<p>@Lang('enter_2fa')</p>
					<div class="bank">
						<div class="enterM" style="width:100%">
							<input type="text" name="code" id="google2fa" autocomplete="off" placeholder="Enter 2FA Code" data-v-ee9f835e="" style="width:100%;margin-left:20px;"/>
						</div>
					</div>
				</div>
			</div>
		</div>

		<input type="hidden" name="key" value="{{$secret}}">

		<div class="centnen" style="margin-top:2.5vmin">
			<div class="wrap">
				<div class="tips-box">
					<h2><img src="{{ asset($activeTemplateTrue.'img/ic_help@2x.png') }}" alt="" srcset=""> @Lang('Attention'):</h2>
					<p data-v-ee9f835e="">@Lang('Attention_Warning')</p>
				</div>
			</div>
		</div>

		<div class="centnen cmsk">
			<div class="wrap">
				<div onclick="onOk();" class="btn" data-v-385ac480="">@Lang('confirm_enable')</div>
			</div>
		</div>
		</div><p style="margin-top:12.667vmin"><br/></p>

	</form>
	@endif
</div>
@endsection

@section('menu')
	@include($activeTemplate.'layouts.profile',['activeLink'=>'2fa'])
@endsection

@push('script')
    <script>
	function copyME(me){
		var msg = $(me).data('copy-text');
		var copied = $(me).data('clipboard');
		var $temp = $("<input>");
		$("body").append($temp);
		$temp.val(copied).select();
		document.execCommand("copy");
		$temp.remove();
		Toast(msg);
	}
	
	function onOk(){
		let google2fa = $('#google2fa').val();

		if ( !google2fa || google2fa.length < 6 ) {
			Toast('Google 2fa has to be 6 or more digits');
			return false;
		}
		
		hsycms.loading('loading.');
		$("#google2faForm").submit();
	}
	
    </script>
@endpush


