@extends($activeTemplate.'layouts.users')

@push('style')
	<link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/bank.css') }}{{$catch}}">
@endpush

@section('content')
    <div class="bank-wrap">
        <div class="navbar">
            <span onclick="onJump('{{ route('user.profile')}}')">
					<i></i>
				</span>
            <span></span>
            <span></span>
        </div>
		
        <div class="tips-box" style="margin-top:45px;">
            <p class="tips" style="text-align: center;">
                Please input the following 3 parts to facilitate your withdrawal.
            </p>
        </div>

        <form action="" method="post" id="bankForm" class="list-wrap">
            <ul class="uls">
                <li>
                    <span>Crypto network</span>
                    <select name="network" id="network" style="width: 100%;font-size: .24rem;color: #333;">
						<option value="">Please select network</option>
						<option class="text-black" value="BEP20" >BEP-20</option>
						<option class="text-black" value="TRC20" >TRC-20</option>
					</select>
					<input type="hidden" name="bank_name" id="bank_code">
                    <p></p>
                </li>

                <li>
                    <span>Wallet Address</span>
                    <input type="text" name="address" id="address" class="account" placeholder="Please enter wallet address" value="">
                    <p></p>
                    <b class="close"></b>
                </li>

                <li>
                    <span>Login Password</span>
                    <input type="text" name="password" id="password" class="account" placeholder="Please enter account password" />
                    <p></p>
                    <b class="close"></b>
                </li>
            </ul>

			@csrf
            <div class="btn" id="reg" onclick="submit();" >Submit</div>
        </form>
    </div>
@endsection

@push('script-lib')
<script>
    (function ($) {
        "use strict";

        $("#network").change(function (e) {
            let code = $("#network").val();
            $("#bank_code").val(t);
        });
    })(jQuery);

	function submit() {
		let flag = true;
		let li = document.querySelectorAll('li');
		li.forEach((dom, index) => {
			dom.querySelector('p').innerText = '';
			if (index == 0) {
				let input = dom.querySelector('input');
				let p = dom.querySelector('p');
				if (!input.value) {
					p.innerText = 'Please select your crypto wallet'
					flag = false
				}
			} else if (index == 1) {
				let input = dom.querySelector('input');
				let p = dom.querySelector('p');
				if (!input.value) {
					p.innerText = 'Please enter your wallet address'
					flag = false
				}
			} else if (index == 2) {
				let input = dom.querySelector('input');
				let p = dom.querySelector('p');
				if (!input.value) {
					p.innerText = 'Please enter account password'
					flag = false
				}
			}
		})

		if (!flag) return
		let text = document.querySelectorAll('li input');
		console.log(text[0].value, text[1].value, text[2].value);

		hsycms.loading('loading.');
		$("#bankForm").submit();
		
	}
</script>
@endpush
