@extends($activeTemplate.'layouts.users')

@push('style-lib')
	<link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/withdraw.css') }}{{$catch}}">
@endpush

@section('content')
    <div class="withdraw-wrap">
        <div class="navbar">
            <span onclick="onBack()"><i></i></span>
            <span></span>
            <span></span>
        </div>

        <p class="title">Withdrawable amount</p>
        <h2>
            <span>{{ $user->user_currency_sym}}</em>{{ showAmount($user->bonus_balance) }}</span>
            <b onclick="onJump(&quot;{{ route('user.withdraw.history') }}&quot;)">Withdrawals record</b>
        </h2>

        <div class="box">
            <h3>Withdrawal amount</h3>
            <div class="wrap">
                <b>{{ $user->user_currency_sym}}</b>
                <div>
                    <input class="money" id="money" type="text" maxlength="9" placeholder="Please enter amount">
					@csrf
                    <span class="all">All</span>
                </div>
            </div>

			@if( $user->withdrawal_password )
            <h3 style="margin-top: .80rem;">Withdrawal security pin</h3>
            <div class="wrap" style="margin-top: .25rem;">
                <b><img src="{{ asset($activeTemplateTrue.'img/n2_on.png') }}" style="width:24px" /></b>
                <div>
                    <input class="money" id="withPassword" type="password" placeholder="Required withdrawal pin" style="text-align:left" />
                    <b class="eye"></b>
                </div>
            </div>
			@endif

			@if( $user->ts )
            <h3 style="margin-top: .80rem;">Google authenticator code</h3>
            <div class="wrap" style="margin-top: .25rem;">
                <b><img src="{{ asset($activeTemplateTrue.'img/n2_on.png') }}" style="width:24px" /></b>
                <div>
                    <input class="authenticator" id="authenticator" type="password" placeholder="Requires two factor code" style="text-align:left" Required />
                    <b class="eye"></b>
                </div>
            </div>
			@endif

            <input type="hidden" id="method" value="{{ $withdrawMethod[0]->id}}">
            <input type="hidden" id="debit_with" value="bonus_balance">
			
            <div class="btn" id="withdrawBTN">Withdraw</div>
        </div>
		
        <div class="list">
            <div>
                <img src="{{ asset($activeTemplateTrue.'img/ic_vip1.png') }}" alt="" srcset="">
                <p>{{ ($withdrawMethod[0]->percent_charge + 0)}}% fee</p>
            </div>
            <div>
                <img src="{{ asset($activeTemplateTrue.'img/ic_vip2.png') }}" alt="" srcset="">
                <p>{{ $withdrawMethod[0]->delay}} Arrival</p>
            </div>
            <div>
                <img src="{{ asset($activeTemplateTrue.'img/ic_vip3.png') }}" alt="" srcset="">
                <p>{{ $currency['cur_sym'] }}{{ ($withdrawMethod[0]->min_limit + 0)}}</p>
            </div>
            <div>
                <img src="{{ asset($activeTemplateTrue.'img/ic_vip4.png') }}" alt="" srcset="">
                <p>{{ $currency['cur_sym'] }}{{ ($withdrawMethod[0]->max_limit + 0)}}</p>
            </div>
        </div>

        <div class="list">
			<div class="charge-description" style="margin-top:25px;text-align:justify;">
				<p style="font-size:20px;color:#fff;text-decoration:underline;">Withdrawal instructions</p>
				{!! $withdrawMethod[0]->description !!}
			</div>
		</div>

	</div>

@endsection

@push('script')
<script>
	$('#money').keyup(function() {
		$(this)[0].value = $(this)[0].value.replace(/^(0+)|[^\d]+/g, '')
	})
	$('.all').click(function() {
		$('#money').val("{{ getAmount($user->bonus_balance) }}")
	})

    $("#withdrawBTN").click(function() {

        var amount = $('#money');
        var method = $('#method');
        var debit_from = $('#debit_with');
        var password = $('#withPassword');
        var gFactore = $('#authenticator');
        var token = document.querySelector('input[name="_token"]').value;
        var is_status = true;

        if (!amount.val()) {
			Toast('Withdrawing amount required',2000);
            is_status = false; return false;
        }

		<?php if( $user->withdrawal_password ){ ?>
        if (!password.val()) {
            Toast("Please enter withdrawal security pin");
            is_status = false;
        }
		<?php } ?>

		<?php if( $user->ts ){ ?>
        if (!gFactore.val()) {
            Toast("Google two factor code Required");
            is_status = false;
        }
		<?php } ?>

        if (is_status) {
            $.ajax({
                type: "POST",
                url: "{{ route('user.withdraw.bonus') }}",
                data: {
                    amount: amount.val(),
                    method: method.val(),
                    debit_from: debit_from.val(),
                    password: password.val(),
                    _token: token
                },
                beforeSend: function() {
					hsycms.loading('loading.');
                },
                success: function(data) {
					Toast(data.message, 2000);
					setTimeout(function() {
						onJump(data.link);
					}, 2000);
                },
                error: function(xhr, status, error) {
                    var responseText = JSON.parse(xhr.responseText);
					hsycms.hideLoading();
					Toast(responseText.message, 3000);
                },
                fail: function() {
					Toast('Request Failed', 3000);
					hsycms.hideLoading();
                }
            });
        }


        return false;
    })
</script>
@endpush
